/* Copyright (C) 1994, 1998 by Thomas Glen Smith.	All Rights Reserved. */
/* circulax APL2 V1.0.1 ************************************************
* Circle functions for complex numbers.                                *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
void circulax(left,rrr,ret)
double *left,*rrr,*ret;
{
	Circulap; Circulas; Circulat; Circulav; Circulaw; Circulay; Circulaz;
	int ileft;

	ileft = *left; /* Convert to integer. */
	for(;;) { /* Lets me use break. */
		if (!(*(rrr+1) == 0)) break; /* Not a real number. */
		if (ileft < ATANH) break; /* Complex number functions. */
		if (ileft > TANH) break; /* Complex number functions. */
		if (ileft == -6 && *rrr < 1.0) break; /* Complex answer. */
		if (ileft == -4 && *rrr >= 0.0 && *rrr < 1.0) break;
		*(ret+1) = 0;
		circulap(left,rrr,ret);	/* Process a real number. */
		return; /* All done. */
	} /* End for(;;) */
	if (ileft < ATANH || ileft == -4)	/* -7 */
		circulas(left,rrr,ret);	/* Neg. key, non-trig. */
	else if (ileft > TANH || ileft == 0 || ileft == 4)
		circulat(left,rrr,ret);	/* Pos. key, non-trig. */
	else if (ileft < ATAN)		/* -3 */
		circulay(left,rrr,ret);	/* ATANH(-7), ACOSH(-6), ASINH(-5) */
	else if (ileft < SIN)		/* +1 */
		circulaz(left,rrr,ret);	/* ATAN(-3), ACOS(-2), ASIN(-1) */
	else if (ileft < SINH)		/* +5 */
		circulaw(left,rrr,ret);	/* TAN(3), COS(2), SIN(1) */
	else circulav(left,rrr,ret);	/* TANH(7) COSH(6) SINH(5) */
}
