/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* axispre APL2 V1.0.0 *************************************************
* Called by cat.                                                       *
* This subroutine obtains three values essential to any APL operation  *
* affected by an axis value:                                           *
* axicnt: count along axis (origin 1).                                 *
* botcnt: the greater of 1 or the product of dimensions below the axis.*
* topcnt: the greater of 1 or the product of dimensions above the axis.*
* Returns 1 of processing successful, and 0 otherwise.                 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int axispre(rite,axis,paxicnt,pbotcnt,ptopcnt)
Aplcb rite; /* operand */
int axis;
int *paxicnt,*pbotcnt,*ptopcnt;
{
	Isign;
	extern int aplerr;
	int axicnt,botcnt,topcnt;
	int *dimptr,i;

	if (rite==NULL)
		return(0);
	if (rite->aplrank>0 && (axis<1 || axis>rite->aplrank)) {
		aplerr=9; /* bad axis */
		return(0);
	}
	axicnt=botcnt=topcnt=1;
	dimptr=rite->apldim;
	for (i=1; i<=rite->aplrank; i++)
		switch (isign(i-axis)) {
			case -1: /* dimension < axis */
				topcnt*=*dimptr++;
				break;
			case  0: /* dimension = axis */
				axicnt =*dimptr++;
				break;
			case +1: /* dimension > axis */
				botcnt*=*dimptr++;
				break;
		} /* end switch */
	*paxicnt=axicnt;
	*pbotcnt=botcnt;
	*ptopcnt=topcnt;
	return(1); /* all ok */
}
