/* Copyright (C) 1993, 1997 by Thomas Glen Smith. All Rights Reserved. */
/* aplinit.c APL2 V1.0.1 ***********************************************
* Called by apl.                                                       *
* Certain variables are required globally in the APL environment.      *
* Aplinit initializes those variables.                                 *
***********************************************************************/
#define INCLUDES APLCB+APLDEBUG+APLFUNCI+APLMEM+TREE
#include "includes.h"
void aplinit(void)
{
#include "quadext.h"
	Chrcopy; Getcb; Quadinit; Treeroot;
	extern int aplcurs; /* # chars put in current output line.		*/
	extern int aplerr; /* Set to 0 before calling an APL function,	*/
		/* may set to indicate error occurred.					*/
	extern char *aplfile; /* Starts null. May later contain pointer	*/
		/* to file most recently	ref. in a )SAVE or )LOAD command.	*/
	extern double fuzz; /* Fuzz contains the comparison tolerance,	*/
		/* e.g. if a number is within plus or minus this value of	*/
		/* an integer, then it is considered to be equal to that	*/
		/* integer.										*/
	extern int indxorg; /* Indxorg must contain either a 0 or 1.	*/
		/* When indxorg=0, the first element along each axis is	*/
		/* selected by the index 0, and when indxorg=1, the index	*/
		/* would be 1.  See also the indxsub routine.			*/
	extern double pp; /* Print precision.						*/
	extern Treelist treehdr; /* Treehdr is the state		*/
		/* indicator and variable pool stack.					*/
	extern struct aplcb *aplwkcb; /* Aplwkcb is a pointer to the	*/
		/* delayed workspace command aplcb. Certain commands such	*/
		/* as )OFF and )LOAD must be deferred.					*/
	extern int aplwkcd; /* Code indicates which is deferred.		*/
	extern int aplfont; /* =1 if special font is used to print.		*/
	extern int apldigs; /* Maximum places left of d.p. in output.	*/
	extern int aplquiet; /* =1 if no copywrite notice. */
	Aplcb qfc;

#if APL_DEBUG
void mem_init();
mem_init(); /* initialize the memory debugging package */
#endif
	apldigs = 15;
	aplcurs = 0;
	aplerr = 0;
	aplfile = NULL;
	fuzz = 1.0e-13;
	indxorg = 1;
	pp = 8;
	quadinit(); /* initialize external name variables */
	treehdr = NULL;
	treeroot(NULL); /* set treehdr */
	aplwkcb = NULL;
	aplwkcd = 0;
	aplfont = 0;
	aplquiet = 0;
	qfc = getcb(NULL,5,APLCHAR+APLTEMP,1,NULL);
	if (qfc != NULL) {
		chrcopy(qfc->aplptr.aplchar,".,*0_",5,1);
		assign(quadfc,qfc);
	}
}
