/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplgrpsb APL2 V1.0.0 ************************************************
* Called from aplgrps and aplsi to print names in a tree.              *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN+STRING+TREE
#include "includes.h"
void aplgrpsb(ch,code,node)
char *ch;				/* alphabetic character */
int code;				/* 1=groups, 2=variables, 3=functions, 4=all */
struct avlnode *node;	/* points to node of binary tree */
{
#include "quadext.h"
	Execmsg; Quadname;
	Aplcb cb;
	char *qn;
	int hit;

	if (node == NULL) return;
	aplgrpsb(ch,code,node->left_child); /* visit left branch */
	if (*(node->avlname) >= *ch && NULL != (cb = node->avlleaf)) {
		switch (code) {
			case 1: /* groups */
				hit = cb->aplflags & APLGROUP;
				break;
			case 3: /* functions */
				hit = cb->aplflags & APLFUNC;
				break;
			case 2: /* variables */
				hit = (0 == strcmp(node->avlname,quadfc)) ?
					0 : !(cb->aplflags & (APLLABEL+APLGROUP+APLFUNC));
				break;
			case 4: /* all */
				hit = 1;
				break;
			default:
				hit = 0;
				break;
		} /* end switch */
		if (hit) {
			qn = quadname(node->avlname); /* Transform Q-names. */
			execmsg(qn,strlen(qn),0,NULL); /* Display name. */
		}
	}
	aplgrpsb(ch,code,node->rite_child); /* visit right branch */
}
