/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* aplfill APL2 V1.0.0 *************************************************
* Called by expane and comprest.                                       *
* Returns a pointer to the fill value for the argument, marked         *
* permanent in the case of data type APLAPL.                           *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void *aplfill(rite)
Aplcb rite;
{
	Enclose; First; Perm; Reshape; Scalar;
	void *out;
	int tempsave;
	static int ifill=0;
     static double dblfill[2] = {0e0,0e0};
     static char chrfill = ' ';

     switch(rite->aplflags & (APLMASK | APLAPL)) {
		case APLCPLX:
          case APLNUMB: out = (void *) dblfill; break;
          case APLINT : out = (void *) &ifill; break;
          case APLCHAR: out = (void *) &chrfill; break;
		case APLAPL :
			rite->aplflags -= (tempsave = rite->aplflags & APLTEMP);
			out = perm(first(reshape(scalar(0),enclose(first(rite),
				NULL))));
			rite->aplflags += tempsave;
			break;
     } /* end switch */
	return(out);
}
