/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplerase APL2 V1.0.0 ************************************************
* Called from aplwksp to do )ERASE.                                    *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN+STRING+TREE
#include "includes.h"
void aplerase(rite,cp,cpend)
Aplcb rite;	/* Aplcb for command text. */
char *cp;		/* Pointer to char immediately after right parenthesis. */
char *cpend;	/* Pointer to end of command text. */
{
	Endoper; Execmsg; Execpars; Execpop; Execqext; Execqncs; Leafdel;
	Treenode;
	extern int aplerr;
	Apltoken tok,tokhdr;
	Avlnode p;
	Aplcb cb;

	for (tok = tokhdr = execpars(cp,cpend-cp);
		tok != NULL && aplerr == 0;
		tok = tok->token_queue.token_next_ptr) {
		if (tok->token_code != OPERAND_TOKEN)
			aplerr = 58; /* syntax error */
		else if (NULL != (p = treenode(tok->token_ptr.token_string))
			&& NULL != (cb = p->avlleaf) && 
			!(cb->aplflags & APLLABEL)) {
			if (cb->aplflags & APLGROUP)
				endoper(execqncs(execqext,cb)); /* delete group */
			leafdel(p->avlleaf); /* free func., grp. or var. */
			p->avlleaf = NULL; /* indicate name available */
		}
		else execmsg(tok->token_ptr.token_string,
			strlen(tok->token_ptr.token_string),0,"not found");
	}
	execpop(&tokhdr); /* pop and free tokens on stack */
}
