/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledrc APL2 V1.0.0 *************************************************
* Called from aplediz to process a line of input.                      *
***********************************************************************/
#define MAXLINE 1024
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLTOKEN+STDIO+STRING
#include "includes.h"
void apledrc(e,line)
struct apledst *e;		/* Edit common area.					*/
char *line;			/* Current input.						*/
{
	Aplediy; Aplscan; Edline; Execpars; Execqfxk; Pop;
	extern int aplerr;
	Apltoken tokhdr;
	int i,j,loop,stmtlen,tokcnt;
	char *cp,*cpend,*cpsave;

	loop = 1; /* start loop */
	while (loop) {
		cpend = (cp = line) + (stmtlen = strlen(line));
		while(cp < cpend && RIGHT_BRACKET != aplscan(&cp,cpend));
		cpsave = cp; /* save spot after right bracket, maybe cap null */
		if (SPACE == (i = aplscan(&cp,cpend))) {
			cpsave = cp; /* save potential position of cap null */
			i = aplscan(&cp,cpend); /* first token of statement */
		}
		if (i == CAP_NULL) /* handle comment */
			j = cp - line; /* let execparse see only to CAP_NULL */
		else
			j = stmtlen; /* original length */
		tokhdr = execpars(line,j); /* tokenize input */
		if (loop = aplerr) {
			aplerr = 0; /* reset error */
			j = edline(line,0,MAXLINE,1); /* edit at terminal */
		}
	}
	if (tokhdr->token_code == DEL)
		e->delptr = pop(&tokhdr); /* pop DEL token */
	if (tokhdr != NULL) {
		*(e->fp->functokp) = tokhdr;
		execqfxk(e->fp); /* count tokens, transform to contig. */
		if (aplerr == 0 && (tokcnt = *(e->fp->functokc)))
			aplediy(e,line,stmtlen,cpsave,tokcnt); /* do it */
	}
}
