/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* apldrop APL2 V1.0.0 *************************************************
* Called from aplwksp to do )DROP.                                     *
***********************************************************************/
#define INCLUDES APLDOS+APLCB
#include "includes.h"
void apldrop(rite,cp,cpend)
Aplcb rite; /* aplcb for command text */
char *cp; /* Pointer to first char of filename */
char *cpend; /* Pointer to end of command text */
{
	#define MAXNAME 80
	char *q,*work,filename[MAXNAME+4];
#if APL_DOS
	static char *qual=".APL";
#else
	extern int errno;
	static char *qual=".apl";
#endif
	int i,j;
	
	if (0 >= (j = cpend-cp))
		return; /* get out if no name supplied */
	j = (j > MAXNAME) ? MAXNAME : j; /* allow only MAXNAME chars */
	for (i = 0, work = filename; i < j; i++)
		*work++ = *(cp+i);
	q = qual;
	while('\0' != (*work++ = *q++));
#if APL_DOS
	bdosx(0x41,filename,0x00); /* delete file */
	i = errno; /* save error, if any */
#else
	i = unlink(filename);
#endif
	errno = 0; /* reset error, if any */
	if (i)
		execmsg(cp,j,j,"not deleted");
	else
		execmsg(cp,j,j,"deleted");
}
