/*Copyright (C) 1993, 1996 by Thomas Glen Smith.  All Rights Reserved. */
/* dublins.h APL2 V1.0.0 ************************************************
* This text is included in dublin.c to determine the sign of the        *
* current constant. Val will contain the constant, converted from ASCII *
* to double floating point, and will be a whole number.  Div will       *
* contain the factor by which to divide val to obtain the true real     *
* number constant.                                                      *
************************************************************************/
	sw=0; /* set=1 if constant found */
	for (s = a; s < e
		&& *s == *(aplchar[SPACE])
		|| *s == '\n' 
		|| *s == '\t'; s++); /* white space */
	sign=1; /* default sign is plus */
	if (s < e && *s == *(aplchar[OVERBAR])) {
		sign = -1;
		s++;
	}
	for (val = 0.0; s < e
		&& *s >= *(aplchar[APL_0]) && *s <= *(aplchar[APL_9]); s++) {
		sw=1; /* constant found */
		val = 10.0 * val + (*s - *(aplchar[APL_0]));
	}
	if (s < e && *s == *(aplchar[DOT])) {
		s++;
		if (sw == 1)
			sw = 2; /* real number */
	}
	if ((sign == +1 && val > MAXINT) || 
		(sign == -1 && val > MININT)) sw = 2; /* real number */
	for (div = 1.0; s < e
		&& *s >= *(aplchar[APL_0]) && *s <= *(aplchar[APL_9]); s++) {
		sw=2; /* constant found */
		val = 10.0 * val + (*s - *(aplchar[APL_0]));
		div *= 10.0;
	}
	if (sw==0) return(0); /* no constant */
	t=s; /* save for later */
	/* end of dublins.h **********************************************/
