/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* aplfunc.h APL2 V1.0.0 ************************************************
* This structure is used to fix user-defined functions in the workspace.*
* r/w-Execqfx* "fixes" functions.  They're called with an aplcb         *
*     containing the character representation of the function.          *
* r  -Funcexec, which is called by funcmain after variables have been   *
*     localized, gets its pointer to the aplfunc structure from         *
*     treehdr->avlfun.                                                  *
* r  -Funcexee is called by funcexec after stop control is handled to   *
*     execute the next function statement.  It too gets its aplfunc     *
*     pointer from treehdr->avlfun.                                     *
* r  -Funcinit is called by funcmain to initialize local variables. It  *
*     is passed pointers to the aplfunc structure, and the left and     *
*     arguments to the function, if they exist.                         *
* r/w-Funcmain is called by execnila, execdyan, and execmons, with      *
*     pointers to the aplfunc structure and any arguments to the        *
*     user-defined function.  It checks the APLFUNC_IN_USE flag, and    *
*     makes a copy of aplfunc, if so.  It also turns on APLFUNC_IN_USE  *
*     at the start, and off again at the end of execution.              *
* r  -Aplcpyc calls execqfx, passing it functext, during a )COPY        *
*     operation when the item to copy is a user-defined function.       *
* r  -Aplediu is called from apledit to prepare a niladic function for  *
*     editing.                                                          *
* r  -Aplediw is called from aplediu to prepare a function for editing. *
* r  -Execexei is called by execexee to execute the operand token, if   *
*     it represents a niladic user-defined function.                    *
* r  -Execnila is called from execexei to execute a niladic user        *
*     defined function.                                                 *
* r  -Execqcr is called from execmonq to obtain the character           *
*     representation of a user-defined function.                        *
* r/w-Expunge is called from execqex and execqfxb to expunge a user     *
*     defined function.                                                 *
* r  -Funcgoto is called by funcexec when a branch is to be made.       *
* r  -Funcmsg is called by funcexec to generate an error message.       *
* r/w-Lovfsfn is called to read a function definition during a )LOAD.   *
* r  -Treeroot assigns its aplfunc argument to the new avlfun root.     *
************************************************************************/
#if !defined(APLFUNC_INCL)
#define APLFUNC_INCL
#define NILAD 256
#define MONAD 512
#define DYAD 1024
#define RETVAL 2048
#define MOP 4096
#define DOP 8192
typedef struct aplfunc *Aplfunc;
struct aplfunc {
     struct aplfunc *funcsiqp; /* Used for stacking operations.       */
				/* Execqfxa assigns NULL. No other reference.	*/
				/* Funcsiqp m/b defined so funcflag will be in	*/
				/* the same relative position as aplflags in		*/
				/* an aplcb structure, because avlnodes can point */
				/* to both aplcbs and aplfuncs.				*/
     int funcflag;  /* Always 256 to indicate fixed function          */
				/* Ref: execexee, execexei, execqfxa, funcmain,	*/
				/*      lovfsfn savfsfn.						*/
     int functype;  /* Ref: apledit, execexei, execnila, execqfxa,	*/
				/*      execqfxd execqfxg, funcinit, funcopy,	*/
				/*      funcmain, funcopy, lovfsfn.	*/
				/*  256 = niladic, F                              */
                    /*  512 = monadic, F r                            */
                    /* 1024 = dyadic,  l F r                          */
                    /* 2048 = result,  z # F                          */
                    /*                 z # F r                        */
                    /*                 z # l F r                      */
                    /*                 z # (lo mop) r                 */
                    /*                 z # l (lo mop) r               */
                    /*                 z # (lo dop ro) r              */
                    /*                 z # l (lo dop ro) r            */
                    /* 4096 = monadic operator                        */
                    /*                 (lo mop) r                     */
                    /*                 l (lo mop) r                   */
                    /* 8192 = dyadic operator                         */
                    /*                 (lo dop ro) r                  */
                    /*                 l (lo dop ro) r                */
     int functotl;  /* Count of tokens in functary.                   */
				/* Ref: apledcl, apledit, aplediv, execexee,		*/
				/*      execqfxam expunge, execqfxk, funcopy,	*/
				/*      lovfsfn, lovfsfo, lovfsfp, savfsfn,		*/
				/*      savfsfo.							*/
     int funcstmt;  /* Count of statements in function.               */
				/* Ref: apledit, aplediw, execqfxa, execqfxb,	*/
				/*      execqfxf, execqfxj, execqfxk, funcopy,	*/
				/*      funcexec, funcexef, funcgoto, funcopy,	*/
				/*      functrgo, lovfsfn.					*/
     int *functokc; /* Array of token counters, one per statement.    */
                    /* For statements with labels, this count will    */
                    /* be reduced by 2.                               */
				/* Ref: apledcl, aplediu, aplediv, aplediw,		*/
				/*      apledrc, execqfxa, execqfxd, execqfxf,	*/
				/*      execqfxj, execqfxk, expunge, funcexee,	*/
				/*      funcopy, lovfsfn, savfsfn.				*/
     struct aplcb *functext; /* Pointer to function text.			*/
				/* Ref: aplcpyc, aplediw, execqcr, execqfxa,		*/
				/*      execqfxb, expunge, funcmsg, funcopy,		*/
				/*      lovfsfn, savfsfn.					*/
     struct apltoken *funcname; /* Pointer to function name token.	*/
				/* Ref: aplediv, execqfxa, execqfxl, funcexec,	*/
				/*      funcmsg, funcopy, functrac, functrgo,	*/
				/*      lovfsfp, savfsfn, treeroot.			*/
     struct apltoken **functokp; /* Ptr to array of token headers,	*/
                    /* one for each statement in the function.        */
				/* The queue of tokens gets altered during		*/
				/* statement execution.						*/
				/* Ref: apledcl, apleddl, apledit, aplediu,		*/
				/*      aplediv, aplediw, aplediy, apledmd,		*/
				/*      aplednw, apledqu, apledrc, execqfxa,		*/
				/*      execqfxb, execqfxd, execqfxf, execqfxj,	*/
				/*      execqfxk, expunge, funcexee, funcopy,	*/
				/*      lovfsfn, lovfsfp, savfsfn.				*/
     struct apltoken *functary; /* Memory for all tokens is obtained	*/
                    /* once. This points to that block of memory.     */
				/* Ref: apledcl, aplediv, execqfxa, execqfxb,	*/
				/*      execqfxk, expunge, funcopy, lovfsfn,		*/
				/*      lovfsfo, lovfsfp, savfsfn, savfsfo.		*/
     struct apltoken *funcvars; /* List of local variables.			*/
				/* Ref: execqfxa, execqfxd, execqfxg, execqfxi,	*/
				/*      funcinit, funcmain, funcopy, lovfsfp,	*/
				/*      savfsfn.							*/
                    /* The variable to contain the returned value, if */
                    /* there is a returned value, will be first in    */
                    /* this list.  If the function is dyadic, the left*/
                    /* operand will be next, followed by the right    */
                    /* operand, if the function is either dyadic or   */
                    /* monadic.  The rest of the list is the local    */
                    /* variables as indicated on the function header. */
     struct apltoken *funclabs; /* List of labels.				*/
				/* Ref: aplediw, execqfxa, execqfxf, execqfxi,	*/
				/* funcinit, funcopy, lovfsfp, savfsfn.			*/
				/* Token_offset will contain the number of the	*/
				/* statement with the given label.				*/
};
#endif
