;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   Cellular Automata Unit 1.0 / 286 for real mode.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;   * 286 version limitations *
;   - 16-bit math / processing of 32-bit counters, pointers, and timers
;   - source buffer -> destination buffer requires segment override
;
;

                .286p
                .model medium, pascal
                jumps

include         support.inc

                .code

;
;   evenodd()   evenodd cellular automata
;   author:     Lorne Kirkland Chartier (1996) - public domain
;   palette:    0 = off, all else on
;
;              -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
;
;     EVENS / ODDS
;
;             state  |
;            old new |           reason
;            --------+----------------------------------------
;             0   1  | if # of neighbours is even & <= 2
;             1   0  | if the number of neighbours is odd
;
;

                public evenodd

evenodd         proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, es, si, di
                cld

                lds si,b1ptr
                add si,bufw
                inc si                          ; si = source + 1*x + 1
                les di,b2ptr
                add di,bufw
                inc di                          ; di = dest + 1*x + 1

                mov dx,bufd
                sub dx,2                        ; dx = rows to calculate

align 2
evenodd1:
                mov bx,bufw                     ; bx = buffer width
                mov cx,bx
                sub cx,2                        ; cx = columns to calculate

align 2
evenodd2:
                mov ah,0                        ; neighbor counter

                sub si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y-1
                adc ah,0                        ;      2/1
                cmp byte ptr [si],1             ;      5/2      x, y-1
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y-1
                adc ah,0                        ;      2/1

                add si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y
                adc ah,0                        ;      2/1

                add si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y+1
                adc ah,0                        ;      2/1
                cmp byte ptr [si],1             ;      5/2      x, y+1
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y+1
                adc ah,0                        ;      2/1

                sub si,bx

                sub ah,8
                not ah
                inc ah                          ; convert to neighbor count

                mov al,byte ptr [si]            ; is cell dead?
                cmp al,0
                jne evenodd3a

                test ah,1                       ; odd number of neighbors?
                jnz evenodd3b                   ; yes, skip
                cmp ah,2                        ; <= 4?
                je evenodd3b                    ; yes, skip
                cmp ah,4                        ; <= 4?
                je evenodd3b                    ; yes, skip

                @rand
                and ax,127
                add al,128                      ; yes, activate it
                jmp evenodd3b

evenodd3a:
                test ah,1                       ; odd number of neighbors?
                jz evenodd3b                    ; no, cell lives
                cmp ah,3
                je evenodd3b

                mov al,0                        ; cell dies

evenodd3b:
                mov byte ptr es:[di],al
                inc di                          ; advance destination
                inc si                          ; advance source

                ; loop for remaining cols
                dec cx
                jnz evenodd2

                ; loop for remaining rows
                add si,2
                add di,2
                dec dx
                jnz evenodd1

                ret
evenodd         endp


;
;   lichens()   lichens cellular automata
;   author:     Lorne Kirkland Chartier (1996) - public domain
;   palette:    0 = off, all else on
;
;              -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
;
;     LICHENS - see CARULES.TXT
;
;             state  |
;            old new |           reason
;            --------+----------------------------------------
;             0   1  | if the number of neighbours is 3,7 or 8
;             1   0  | if the number of neighbours is 4
;
;

                public lichens

lichens         proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, es, si, di
                cld

                lds si,b1ptr
                add si,bufw
                inc si                          ; si = source + 1*x + 1
                les di,b2ptr
                add di,bufw
                inc di                          ; di = dest + 1*x + 1

                mov dx,bufd
                sub dx,2                        ; dx = rows to calculate

align 2
lichens1:
                mov bx,bufw                     ; bx = buffer width
                mov cx,bx
                sub cx,2                        ; cx = columns to calculate

align 2
lichens2:
                mov ah,0                        ; neighbor counter

                sub si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y-1
                adc ah,0                        ;      2/1
                cmp byte ptr [si],1             ;      5/2      x, y-1
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y-1
                adc ah,0                        ;      2/1

                add si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y
                adc ah,0                        ;      2/1

                add si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y+1
                adc ah,0                        ;      2/1
                cmp byte ptr [si],1             ;      5/2      x, y+1
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y+1
                adc ah,0                        ;      2/1

                sub si,bx

                sub ah,8
                not ah
                inc ah                          ; convert to neighbor count

                mov al,byte ptr [si]            ; is cell dead?
                cmp al,0
                jne lichens3a

                cmp ah,3                        ; time to be active?
                je lichens3aa
                cmp ah,7
                je lichens3aa
                cmp ah,8
                jne lichens3b                   ; no, nothing happens
lichens3aa:

                @rand
                and ax,127
                add al,128                      ; yes, activate it
                jmp lichens3b

lichens3a:
                cmp ah,4                        ; stay alive?
                jne lichens3b                   ; yes

                mov al,0                        ; no, cell dies

lichens3b:
                mov byte ptr es:[di],al
                inc di                          ; advance destination
                inc si                          ; advance source

                ; loop for remaining cols
                dec cx
                jnz lichens2

                ; loop for remaining rows
                add si,2
                add di,2
                dec dx
                jnz lichens1

                ret
lichens         endp


;
;   life()      Conway's classic game of life
;   author:     Lorne Kirkland Chartier (1996) - public domain
;   palette:    0 = off, all else on
;
;              -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
;
;     LIFE - see CARULES.TXT
;
;            Conways classic game of life. I'm using  state  2  to
;            show that the cell has survived.
;
;             state  |
;            old new |           reason
;            --------+----------------------------------------
;             0   1  | if the (number of neighbours) is 3
;             1   2  | if the (number of neighbours) is 2 or 3
;             C   0  | otherwise
;
;

                public life

life            proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, es, si, di
                cld

                lds si,b1ptr
                add si,bufw
                inc si                          ; si = source + 1*x + 1
                les di,b2ptr
                add di,bufw
                inc di                          ; di = dest + 1*x + 1

                mov dx,bufd
                sub dx,2                        ; dx = rows to calculate

align 2
life1:
                mov bx,bufw                     ; bx = buffer width
                mov cx,bx
                sub cx,2                        ; cx = columns to calculate

align 2
life2:
                mov ah,0                        ; neighbor counter

                sub si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y-1
                adc ah,0                        ;      2/1
                cmp byte ptr [si],1             ;      5/2      x, y-1
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y-1
                adc ah,0                        ;      2/1

                add si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y
                adc ah,0                        ;      2/1

                add si,bx
                cmp byte ptr [si-1],1           ;      5/2      x-1, y+1
                adc ah,0                        ;      2/1
                cmp byte ptr [si],1             ;      5/2      x, y+1
                adc ah,0                        ;      2/1
                cmp byte ptr [si+1],1           ;      5/2      x+1, y+1
                adc ah,0                        ;      2/1

                sub si,bx

                sub ah,8
                not ah
                inc ah                          ; convert to neighbor count

                mov al,byte ptr [si]            ; is cell dead?
                cmp al,0
                jne life3a

                cmp ah,3                        ; time to be active?
                jne life3b                      ; no, nothing happens

                @rand
                and ax,127
                add al,128                      ; yes, activate it

                jmp life3b

life3a:
                cmp ah,2                        ; stay alive?
                je life3b
                cmp ah,3
                je life3b
                mov al,0                        ; no, cell dies

life3b:
                mov byte ptr es:[di],al
                inc di                          ; advance destination
                inc si                          ; advance source

                ; loop for remaining cols
                dec cx
                jnz life2

                ; loop for remaining rows
                add si,2
                add di,2
                dec dx
                jnz life1

                ret
life            endp

                end

