;   motor.asm   turn on motor for a: drive for 2 seconds        
;   Drive light comes on but can not see any thing move ?
;           Use FDC floppy disk controller and Digital Output Register 3F2H
;                                                                    
;
;
.model       small
.stack       200h    ; 512 byte stack
.data


.code

start:             
             mov          ax,@data
             mov          ds,ax
             sti
                                      ;    bits 1,0    Select drive
                                      ;                    00 = a
                                      ;                    01 = b
                                      ;                    10 = c
                                      ;                    11 = d
                                      ;          2    0 = reset FDC
                                      ;          3    1 = enable FDC interrupt
                                      ;                   and DMA access
                                      ;         4-7   1 = turn on drive motor
                                      ;                   Bit 4 = drive A
                                      ;
             mov          dx,3f2h     ; turn on A drive motor
             mov          al,28       ; set bits 2,3,4 (Drive A = 28h)
             
             
             out          dx,al
             call         motor_delay
             mov          dx,3f2h
             mov          al,12
             out          dx,al
             jmp          short exit

motor_delay:
             mov          ah,0
             int          1ah
             add          dx,9       ; add  second delay
             mov          bx,dx
repeat:
             int          1ah
             cmp          dx,bx
             jne          repeat

exit:             
             mov          ah,4ch
             int          21h

end          start


