; The 71-byte Mandelbrot Set generator!!
; By Tenie Remmel

Ideal
Model Tiny
CodeSeg
P386
Org 100h

Proc        Prog
               
            push 0A000h             ;Point ES to video memory
            pop es
            mov ax,13h              ;Set MCGA video mode
            int 10h
            xor di,di               ;Zero DI
            mov cx,200              ;Init row counter
RowLoop:    mov si,320              ;Init column counter
PixLoop:    mov bp,79               ;Init color counter
            xor bx,bx               ;Zero i coefficient
            xor dx,dx               ;Zero j coefficient
ClrLoop:    push dx                 ;Save j
            mov ax,bx               ;AX = i
            sub ax,dx               ;AX = i - j
            add dx,bx               ;DX = i + j
            imul dx                 ;DX:AX = (i+j)*(i-j) = i*i-j*j
            mov al,ah               ;Save middle bits
            mov ah,dl               ;(i*i-j*j)/100h
            pop dx                  ;Restore j
            xchg bx,ax              ;Now swap new i with old i
            sub bx,si               ;Subtract column counter
            imul dx                 ;Now DX:AX = old i * j
            shld dx,ax,9            ;Get middle bits in DX
            sub dx,cx               ;Add row counter
            test dh,dh              ;Is j >= 256 ?
            jg Draw                 ;If so, draw this pixel
            dec bp                  ;Dec color counter
            jnz ClrLoop             ;Loop back
Draw:       xchg ax,bp              ;Get pixel in AL
            stosb                   ;Write pixel
            dec si                  ;Dec column counter
            jnz PixLoop             ;Loop back
            loop RowLoop            ;Row loop
            int 16h                 ;Wait for a key
            mov ax,3                ;Switch back to text mode
            int 10h
            ret                     ;Return

EndP        Prog

End Prog
