/*
	CONVERT.H

	28-jun-88, Marc Savary, AdLib Inc.

	Header for conversion procedures of *.ROL files to
	*.MUS ( MIDI like) files.
*/

#define SYSTEM_XOR_BYTE	0xF0
#define EOX_BYTE			0xF7
#define OVERFLOW_BYTE		0xF8
#define STOP_BYTE			0xFC

#define NOTE_OFF_BYTE		0x80
#define NOTE_ON_BYTE		0x90
#define AFTER_TOUCH_BYTE	0xA0
#define CONTROL_CHANGE_BYTE	0xB0
#define PROG_CHANGE_BYTE	0xC0
#define CHANNEL_PRESSURE_BYTE	0xD0
#define PITCH_BEND_BYTE	0xE0

#define ADLIB_CTRL_BYTE	0x7F	/* for System exclusive */
#define TEMPO_CTRL_BYTE	0

#define NR_VOICES			11
#define N_ROLL_VOICES		NR_VOICES
#define TUNE_NAME_SIZE		30
#define FILLER_SIZE		8
#define FILLER2_SIZE		8
#define TIMBRE_DEF_LEN		28
#define TIMBRE_DEF_SIZE 	( TIMBRE_DEF_LEN * sizeof( int))
#define OVERFLOW			240
#define DEFAULT_TICK_BEAT	240

struct MusHeader {
	char		majorVersion;
	char		minorVersion;
	long		tuneId;
	char		tuneName[ TUNE_NAME_SIZE];
	char		tickBeat;
	char		beatMeasure;
	long		totalTick;
	long		dataSize;
	long		nrCommand;
	char		filler[ FILLER_SIZE];

	char		soundMode;			/* 0: melodic, 1: percussive */
	char		pitchBRange;			/* 1 - 12 */
	unsigned	basicTempo;
	char		filler2[ FILLER2_SIZE];

	/* char		data[]; */
	};

