/* One-Byte Opcode Map */
char	*OpMap1[256]={
/* 0 */
	"add %Eb,%Gb",  "add %Ev,%Gv",  "add %Gb,%Eb",  "add %Gv,%Ev",
	"add al,%Ib",   "add %eax,%Iv", "push es",      "pop es",
	"or %Eb,%Gb",   "or %Ev,%Gv",   "or %Gb,%Eb",   "or %Gv,%Ev",
	"or al,%Ib",    "or %eax,%Iv",  "push cs",      "%2 ",
/* 1 */
	"adc %Eb,%Gb",  "adc %Ev,%Gv",  "adc %Gb,%Eb",  "adc %Gv,%Ev",
	"adc al,%Ib",   "adc %eax,%Iv", "push ss",      "pop ss",
	"sbb %Eb,%Gb",  "sbb %Ev,%Gv",  "sbb %Gb,%Eb",  "sbb %Gv,%Ev",
	"sbb al,%Ib",   "sbb %eax,%Iv", "push ds",      "pop ds",
/* 2 */
	"and %Eb,%Gb",  "and %Ev,%Gv",  "and %Gb,%Eb",  "and %Gv,%Ev",
	"and al,%Ib",   "and %eax,%Iv", "%pe",          "daa",
	"sub %Eb,%Gb",  "sub %Ev,%Gv",  "sub %Gb,%Eb",  "sub %Gv,%Ev",
	"sub al,%Ib",   "sub %eax,%Iv", "%pc",          "das",
/* 3 */
	"xor %Eb,%Gb",  "xor %Ev,%Gv",  "xor %Gb,%Eb",  "xor %Gv,%Ev",
	"xor al,%Ib",   "xor %eax,%Iv", "%ps",          "aaa",
	"cmp %Eb,%Gb",  "cmp %Ev,%Gv",  "cmp %Gb,%Eb",  "cmp %Gv,%Ev",
	"cmp al,%Ib",   "cmp %eax,%Iv", "%pd",          "aas",
/* 4 */
	"inc %eax",     "inc %ecx",     "inc %edx",     "inc %ebx",
	"inc %esp",     "inc %ebp",     "inc %esi",     "inc %edi",
	"dec %eax",     "dec %ecx",     "dec %edx",     "dec %ebx",
	"dec %esp",     "dec %ebp",     "dec %esi",     "dec %edi",
/* 5 */
	"push %eax",    "push %ecx",    "push %edx",    "push %ebx",
	"push %esp",    "push %ebp",    "push %esi",    "push %edi",
	"pop %eax",     "pop %ecx",     "pop %edx",     "pop %ebx",
	"pop %esp",     "pop %ebp",     "pop %esi",     "pop %edi",
/* 6 */
	"pusha%d ",     "popa%d ",      "bound %Gv,%Ma","arpl %Ew,%Gw",
	"%pf",          "%pg",          "%so",          "%sa",
	"push %Iv",  "imul %Gv,%Ev,%Iv","push %3v%Ib",  "imul %Gv,%Ev,%Ib",
	"insb %Yb,dx",  "ins%wd %Yv,dx","outsb dx,%Xb", "outs%wd dx,%Xv",
/* 7 */
	"jo %Jb",       "jno %Jb",      "jb %Jb",       "jnb %Jb",
	"jz %Jb",       "jnz %Jb",      "jbe %Jb",      "jnbe %Jb",
	"js %Jb",       "jns %Jb",      "jp %Jb",       "jnp %Jb",
	"jl %Jb",       "jnl %Jb",      "jng %Jb",      "jg %Jb",
/* 8 */
	"%g0 %Eb,%Ib",  "%g0 %Ev,%Iv",  "%g0 %Eb,%Ib","%g0 %3v%Ev,%Ib",
	"test %Eb,%Gb", "test %Ev,%Gv", "xchg %Eb,%Gb", "xchg %Ev,%Gv",
	"mov %Eb,%Gb",  "mov %Ev,%Gv",  "mov %Gb,%Eb",  "mov %Gv,%Ev",
    "mov %EW,%Sw",  "lea %Gv,%M ",  "mov %Sw,%Ew",  "pop %Ev",
/* 9 */
	"nop",        "xchg %eax,%ecx","xchg %eax,%edx","xchg %eax,%ebx",
     "xchg %eax,%esp","xchg %eax,%ebp","xchg %eax,%esi","xchg %eax,%edi",
	"c%bw%wd%qe",   "c%w d%qq",     "call %Ap",     "wait",
	"pushf%d ",     "popf%d ",      "sahf",         "lahf",
/* A */
	"mov al,%Ob",   "mov %eax,%Ov", "mov %Ob,al",   "mov %Ov,%eax",
      "movsb %Yb,%Xb","movs%wd %Yv,%Xv","cmpsb %Yb,%Xb","cmps%wd %Yv,%Xv",
	"test al,%Ib",  "test %eax,%Iv","stosb %Yb,al", "stos%wd %Yv,%eax",
     "lodsb al,%Xb", "lods%wd %eax,%Xv","scasb %Yb,al", "scas%wd %Yv,%eax",
/* B */
	"mov al,%Ib",   "mov cl,%Ib",   "mov dl,%Ib",   "mov bl,%Ib",
	"mov ah,%Ib",   "mov ch,%Ib",   "mov dh,%Ib",   "mov bh,%Ib",
	"mov %eax,%Iv", "mov %ecx,%Iv", "mov %edx,%Iv", "mov %ebx,%Iv",
	"mov %esp,%Iv", "mov %ebp,%Iv", "mov %esi,%Iv", "mov %edi,%Iv",
/* C */
	"%g1 %Eb,%Ib",  "%g1 %Ev,%Ib",  "ret %Iw",      "ret",
	"les %Gv,%Mp",  "lds %Gv,%Mp",  "mov %Eb,%Ib",  "mov %Ev,%Iv",
	"enter %Iw,%Ib","leave",        "retf %Iw",     "retf",
	"int 3",        "int %Ib",      "into",         "iret%d ",
/* D */
	"%g1 %Eb,1",    "%g1 %Ev,1",    "%g1 %Eb,cl",   "%g1 %Ev,cl",
	"aam%11",       "aad%11",       "salc",         "xlat",
	"%f0",          "%f1",          "%f2",          "%f3",
	"%f4",          "%f5",          "%f6",          "%f7",
/* E */
        "loopne %Jb",   "loope %Jb",    "loop %Jb",     "j%aecxz %Jb",
	"in al,%Ib",    "in %eax,%Ib",  "out %Ib,al",   "out %Ib,%eax",
	"call %Jv",     "jmp %Jv",      "jmp %Ap",      "jmp %Jb",
	"in al,dx",     "in %eax,dx",   "out dx,al",    "out dx,%eax",
/* F */
	"lock %p ",     0,              "repne %p ",    "repe %p ",
	"hlt",          "cmc",          "%rb%g2",       "%rv%g2",
	"clc",          "stc",          "cli",          "sti",
	"cld",          "std",          "%g3",          "%g4" };

/* Two-Byte Opcode Map (first byte is 0Fh) */
char	*Second[256]={
/* 0 */
	"%g5",          "%g6",          "lar %Gv,%Ew",  "lsl %Gv,%Ew",
	0,		"loadall",      "clts",         "loadalld",
	"invd",         "wbinvd",       0,              0,
	0,		0,		0,		0,

/* 1 */
	"mov %Eb,%Gb",  "mov %Gv,%Ev",  "mov %Gb,%Eb",  "mov %Ev,%Gv",
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 2 */
	"mov %Rd,%Cd",  "mov %Rd,%Dd",  "mov %Cd,%Rd",  "mov %Dd,%Rd",
	"mov %Rd,%Td",  0,              "mov %Td,%Rd",  0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 3 */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 4 */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 5 */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 6 */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 7 */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,

/* 8 */
	"jo %Jv",       "jno %Jv",      "jb %Jv",       "jnb %Jv",
	"jz %Jv",       "jnz %Jv",      "jna %Jv",      "ja %Jv",
	"js %Jv",       "jns %Jv",      "jp %Jv",       "jnp %Jv",
	"jl %Jv",       "jnl %Jv",      "jng %Jv",      "jg %Jv",

/* 9 */
	"seto %Eb",     "setno %Eb",    "setb %Eb",     "setnb %Eb",
	"setz %Eb",     "setnz %Eb",    "setna %Eb",    "seta %Eb",
	"sets %Eb",     "setns %Eb",    "setp %Eb",     "setnp %Eb",
	"setl %Eb",     "setnl %Eb",    "setng %Eb",    "setg %Eb",

/* A */
        "push fs",      "pop fs",       "cpuid",        "bt %Ev,%Gv",
   "shld %Ev,%Gv,%Ib","shld %Ev,%Gv,cl",0,              0,
	"push gs",      "pop gs",       0,              "bts %Ev,%Gv",
   "shrd %Ev,%Gv,%Ib","shrd %Ev,%Gv,cl",0,              "imul %Gv,%Ev",

/* B */
    "cmpxchg %Eb,%Gb","cmpxchg %Ev,%Gv","lss %Mp",      "btr %Ev,%Gv",
	"lfs %Mp",      "lgs %Mp",      "movzx %Gv,%Eb","movzx %Gv,%Ew",
	0,		0,		"%g7 %Ev,%Ib",  "btc %Ev,%Gv",
	"bsf %Gv,%Ev",  "bsr %Gv,%Ev",  "movsx %Gv,%Eb","movsx %Gv,%Ew",

/* C */
	"xadd %Eb,%Gb", "xadd %Ev,%Gv", 0,              0,
	0,		0,		0,		0,
	"bswap eax",    "bswap ecx",    "bswap edx",    "bswap ebx",
	"bswap esp",    "bswap ebp",    "bswap esi",    "bswap edi",

/* D */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
/* E */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
/* F */
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0,
	0,		0,		0,		0 };

char	*Groups[][8]={
/* 0 */ {
	"add",          "or",           "adc",          "sbb",
	"and",          "sub",          "xor",          "cmp"       },

/* 1 */ {
	"rol",          "ror",          "rcl",          "rcr",
	"shl",          "shr",          "shl",          "sar"       },

/* 2 */ {
	"test %Er,%Ir", "test %Er,%Ir", "not %Er",      "neg %Er",
	"mul %Er",      "imul %Er",     "div %Er",      "idiv %Er"  },

/* 3 */ {
	"inc %Eb",      "dec %Eb",      0,              0,
	0,		0,		0,		0	    },

/* 4 */ {
	"inc %Ev",      "dec %Ev",      "call %Ev",     "call %Ep",
	"jmp %Ev",      "jmp %Ep",      "push %Ev",     0           },

/* 5 */ {
	"sldt %Ew",     "str %Ew",      "lldt %Ew",     "ltr %Ew",
	"verr %Ew",     "verw %Ew",     0,              0           },

/* 6 */ {
	"sgdt %Ms",     "sidt %Ms",     "lgdt %Ms",     "lidt %Ms",
	"smsw %Ew",     0,              "lmsw %Ew",     "invlpg"    },

/* 7 */ {
	0,		0,		0,		0,
	"bt",           "bts",          "btr",          "btc"       }
	};

	/* These maps are directly copied from table.c (2asm) */
char	*f0[]	  = { 0, 0, 0, 0, 0, 0, 0, 0};
char	*fop_9[]  = { "*fxch st,%GF" };
char	*fop_10[] = { "fnop", 0, 0, 0, 0, 0, 0, 0 };
char	*fop_12[] = { "fchs", "fabs", 0, 0, "ftst", "fxam", 0, 0 };
char	*fop_13[] = { "fld1", "fldl2t", "fldl2e", "fldpi",
		      "fldlg2", "fldln2", "fldz", 0 };
char	*fop_14[] = { "f2xm1", "fyl2x", "fptan", "fpatan",
		      "fxtract", "fprem1", "fdecstp", "fincstp" };
char	*fop_15[] = { "fprem", "fyl2xp1", "fsqrt", "fsincos",
		      "frndint", "fscale", "fsin", "fcos" };
char	*fop_21[] = { 0, "fucompp", 0, 0, 0, 0, 0, 0 };
char	*fop_28[] = { 0, 0, "fclex", "finit", 0, 0, 0, 0 };
char	*fop_32[] = { "*fadd %GF,st" };
char	*fop_33[] = { "*fmul %GF,st" };
char	*fop_36[] = { "*fsubr %GF,st" };
char	*fop_37[] = { "*fsub %GF,st" };
char	*fop_38[] = { "*fdivr %GF,st" };
char	*fop_39[] = { "*fdiv %GF,st" };
char	*fop_40[] = { "*ffree %GF" };
char	*fop_42[] = { "*fst %GF" };
char	*fop_43[] = { "*fstp %GF" };
char	*fop_44[] = { "*fucom %GF" };
char	*fop_45[] = { "*fucomp %GF" };
char	*fop_48[] = { "*faddp %GF,st" };
char	*fop_49[] = { "*fmulp %GF,st" };
char	*fop_51[] = { 0, "fcompp", 0, 0, 0, 0, 0, 0 };
char	*fop_52[] = { "*fsubrp %GF,st" };
char	*fop_53[] = { "*fsubp %GF,st" };
char	*fop_54[] = { "*fdivrp %GF,st" };
char	*fop_55[] = { "*fdivp %GF,st" };
char	*fop_60[] = { "fstsw ax", 0, 0, 0, 0, 0, 0, 0 };

char	**fspecial[] = { /* 0=use st(i), 1=undefined 0 in fop_* means undefined */
	0, 0, 0, 0, 0, 0, 0, 0,
	0, fop_9, fop_10, 0, fop_12, fop_13, fop_14, fop_15,
	f0, f0, f0, f0, f0, fop_21, f0, f0,
	f0, f0, f0, f0, fop_28, f0, f0, f0,
	fop_32, fop_33, f0, f0, fop_36, fop_37, fop_38, fop_39,
	fop_40, f0, fop_42, fop_43, fop_44, fop_45, f0, f0,
	fop_48, fop_49, f0, fop_51, fop_52, fop_53, fop_54, fop_55,
	f0, f0, f0, f0, fop_60, f0, f0, f0,
};

char	*floatops[] = { /* assumed " %EF" at end of each.  mod != 3 only */
/*00*/	"fadd",         "fmul",         "fcom",         "fcomp",
	"fsub",         "fsubr",        "fdiv",         "fdivr",
/*08*/	"fld",          0,              "fst",          "fstp",
	"fldenv",       "fldcw",        "fstenv",       "fstcw",
/*16*/	"fiadd",        "fimul",        "ficomw",       "ficompw",
	"fisub",        "fisubr",       "fidiv",        "fidivr",
/*24*/	"fild",         0,              "fist",         "fistp",
	"frstor",       "fldt",         0,              "fstpt",
/*32*/	"faddq",        "fmulq",        "fcomq",        "fcompq",
	"fsubq",        "fsubrq",       "fdivq",        "fdivrq",
/*40*/	"fldq",         0,              "fstq",         "fstpq",
	0,		0,		"fsave",        "fstsw",
/*48*/	"fiaddw",       "fimulw",       "ficomw",       "ficompw",
	"fisubw",       "fisubrw",      "fidivw",       "fidivr",
/*56*/	"fildw",        0,              "fistw",        "fistpw",
	"fbldt",        "fildq",        "fbstpt",       "fistpq"
};
