
/*****************************************************************************
 *									     *
 *      Header          :       Sample.H                                     *
 *      By              :       Marq /Fit                                    *
 *	V		:	0.1					     *
 *      Description     :       Plays 8-bit samples through some devices...  *
 *      Thanx to        :       Yzi & Pete /Fit                              *
 *									     *
 *****************************************************************************/

#include <dos.h>
#include <alloc.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>

#define PIIP 0
#define SB 1
#define DAC 2
#define DEFAULT 0
#define S_ERROR -1
#define S_OK 0
#define DEFR 8192
#define LPT1 get_lpt(1)
#define LPT2 get_lpt(2)
#define LPT3 get_lpt(3)
#define LPT4 get_lpt(4)

int     s_total,s_pnt,s_portti,s_thing;

unsigned        s_cnt,s_len,s_last;

unsigned char far       *s_data[20],*s_current;

int s_load(char *nimi);
int s_init(int laite,int port);
int s_play(unsigned freq);
void s_stop(void);
void s_clear(void);

void settimer(unsigned Hertz);
void resettimer(void);
int resetSB(int ba);
void interrupt (*oldfunc)();
void interrupt DAC_handler(void);
void interrupt SB_handler(void);
void interrupt PIIP_handler(void);
unsigned bcd2d(unsigned bcd);
int get_lpt(int num);

int s_load(char *nimi)
{
        int     _hand,_blks,_rem,de;

	long	_len;

        _hand=open(nimi,O_RDONLY|O_BINARY);
        if(_hand==-1)
		return(S_ERROR);

        _len=filelength(_hand);
        _blks=(int)(_len/32768); _rem=_len%32768;

        for(de=0;de<_blks;de++)
	{
		if((s_data[de]=farmalloc(32769))==NULL)
		{
                        close(_hand);
			return(S_ERROR);
		}
	}

        if(_rem)
	{
		if((s_data[_blks]=farmalloc(_rem+1))==NULL)
		{
                        close(_hand);
			return(S_ERROR);
		}
	}

        for(de=0;de<_blks;de++)
                read(_hand,s_data[de],32768);

        if(_rem)
	{
                read(_hand,s_data[_blks],_rem);

                s_total=_blks+1;
	}
	else
                s_total=_blks;

        close(_hand);

        s_last=_rem;

	return(S_OK);
}

int s_init(int laite,int port)
{
	int	h;

        s_thing=laite;

	if(laite==DAC)
	{
        	if(port==DEFAULT)
                        s_portti=0x378;
		else
                        s_portti=port;

		return(S_OK);
	}

	if(laite==SB)
	{
        	if(port==DEFAULT)
			port=0x220;

                s_portti=port+0xc;

		if(resetSB(port)==S_ERROR)
			return(S_ERROR);

                outp(port+0xc,0xd1);
		return(S_OK);
	}

        if(laite==PIIP)
	{
                outp(0x61,inp(0x61)|3);
                outp(0x43,0xa0);
                outp(0x42,0);

                s_portti=0x42;

		return(S_OK);
	}

	return(S_ERROR);
}

int s_play(unsigned freq)
{
	if(freq==DEFAULT)
		freq=DEFR;

        s_current=s_data[0];
        s_pnt=0;
        s_cnt=0;

        if(s_total==1)
                s_len=s_last;
	else
                s_len=32768;

	oldfunc=getvect(0x8);

	disable();

	settimer(freq);

        if(s_thing==DAC)
		setvect(0x8,DAC_handler);

        if(s_thing==SB)
		setvect(0x8,SB_handler);

        if(s_thing==PIIP)
		setvect(0x8,PIIP_handler);

	enable();
}

void s_stop(void)
{
	struct REGPACK reg1,reg2;

	disable();

	resettimer();
	setvect(0x8,oldfunc);

	enable();

        if(s_thing==PIIP)
		sound(65535);

	reg1.r_ax=0x0200;
	intr(0x1a,&reg1);

	reg1.r_cx=(bcd2d(reg1.r_cx>>8)<<8)+bcd2d(reg1.r_cx&0xff);
	reg1.r_dx=bcd2d(reg1.r_dx>>8)<<8;
	reg2.r_ax=0x0400;
	intr(0x1a,&reg2);

	reg2.r_cx=bcd2d(reg2.r_cx>>8)*100+bcd2d(reg2.r_cx&0xff);
	reg2.r_dx=(bcd2d(reg2.r_dx>>8)<<8)+bcd2d(reg2.r_dx&0xff);
	reg2.r_ax=0x2b00;
	intr(0x21,&reg2);

	reg1.r_ax=0x2d00;
	intr(0x21,&reg1);
}

void s_clear(void)
{
	int	hy;

        if(s_thing==PIIP)
		nosound();

        if(s_thing==SB)
                resetSB(s_portti-0xc);

        if(s_thing==DAC)
                outp(s_portti,0);

        for(hy=0;hy<s_total;hy++)
		farfree(s_data[hy]);
}

void settimer(unsigned Hertz)
{
	unsigned	help;

        help=(unsigned)(1193182/(long)Hertz);

        outp(0x40,help & 0xff);
        outp(0x40,help >> 8);
        outp(0x43,0);
}

void resettimer(void)
{
        outp(0x40,0xff);
        outp(0x40,0xff);
        outp(0x43,0);
}

int resetSB(int ba)
{
	unsigned	tries=50;

        outp(ba+6,1);
	delay(1);
        outp(ba+6,0);
	delay(1);

        while(inp(ba+0xa)!=0xaa && tries)
	{
                outp(ba+6,1);
		delay(1);
                outp(ba+6,0);
		delay(1);
		tries--;
	}

	if(!tries)
		return(S_ERROR);

	return(S_OK);
}

void interrupt DAC_handler(void)
{
        outp(s_portti,s_current[s_cnt]);

        s_cnt++;
        if(s_cnt==s_len)
	{
                s_cnt=0;

                s_pnt++;
                if(s_pnt==s_total)
                        s_pnt=0;

                if(s_total==1)
                        s_len=s_last;
		else
                        if(s_pnt==s_total-1)
                                s_len=s_last;
                        else
                                s_len=32768;

                s_current=s_data[s_pnt];
	}

        outp(0x20,0x20);
}

void interrupt SB_handler(void)
{
        while(inp(s_portti) & 0x80)
		;
        outp(s_portti,0x10);

        s_cnt++;
        if(s_cnt==s_len)
	{
                s_cnt=0;

                s_pnt++;
                if(s_pnt==s_total)
                        s_pnt=0;

                if(s_total==1)
                        s_len=s_last;
		else
                        if(s_pnt==s_total-1)
                                s_len=s_last;
                        else
                                s_len=32768;

                s_current=s_data[s_pnt];
	}

        while(inp(s_portti) & 0x80)
		;
        outp(s_portti,s_current[s_cnt]);

        outp(0x20,0x20);
}

void interrupt PIIP_handler(void)
{
        outp(0x43,0x90);
        outp(0x42,s_current[s_cnt]/2+1);

        s_cnt++;
        if(s_cnt==s_len)
	{
                s_cnt=0;

                s_pnt++;
                if(s_pnt==s_total)
                        s_pnt=0;

                if(s_total==1)
                        s_len=s_last;
		else
                        if(s_pnt==s_total-1)
                                s_len=s_last;
                        else
                                s_len=32768;

                s_current=s_data[s_pnt];
	}

        outp(0x20,0x20);
}

unsigned bcd2d(unsigned bcd)
{
	unsigned apu;

	apu=bcd/16;
	apu=bcd-16*apu+apu*10;

	return(apu);
}

int get_lpt(int num)
{
	return(peek(0x40,0x6 + num*2));
}

/*	EOS	*/
