/* ***********************************************************************
   *									 *
   *		       Quaternion Mathematics Routines			 *
   *									 *
   *		 Original Material by Christopher D. Watkins		 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

   QAdd         - quaternion addition
   QSubtract	- quaternion subtraction
   QMultiply	- quaternion multiplication
   QDivide	- quaternion division
   QSquareRoot  - quaternion square root
   QSquare	- quaternion square

   Q = R + Ai + Bj + Ck = q[0] + q[1]i + q[2]j + q[3]k
*/

void QAdd(FDA p, FDA q, FDA r)			/* r=p+q */
{
  r[0]=p[0]+q[0];
  r[1]=p[1]+q[1];
  r[2]=p[2]+q[2];
  r[3]=p[3]+q[3];
}

void QSubtract(FDA p, FDA q, FDA r)		/* r=p-q */
{
  r[0]=p[0]-q[0];
  r[1]=p[1]-q[1];
  r[2]=p[2]-q[2];
  r[3]=p[3]-q[3];
}

void QMultiply(FDA p, FDA q, FDA r)		/* r=p*q */
{
  r[0]=p[0]*q[0]-p[1]*q[1]-p[2]*q[2]-p[3]*q[3];
  r[1]=p[0]*q[1]-p[1]*q[0]-p[2]*q[3]-p[3]*q[2];
  r[2]=p[0]*q[2]-p[2]*q[0]-p[3]*q[1]-p[1]*q[3];
  r[3]=p[0]*q[3]-p[3]*q[0]-p[1]*q[2]-p[2]*q[1];
}

void QDivide(FDA p, FDA q, FDA r)		/* r=p/q */
{
  FDA t, s;
  float a;

  q[1]=-q[1];
  q[2]=-q[2];
  q[3]=-q[3];
  QMultiply(p, q, t);
  QMultiply(q, q, s);
  a=1.0/s[0];
  r[0]=t[0]*a;
  r[1]=t[1]*a;
  r[2]=t[2]*a;
  r[3]=t[3]*a;
}

void QSquareRoot(FDA q, FDA s)
{
  float len, l, m;
  float a, b;
  FDA r;

  len=sqrt(SqrFP(q[0])+SqrFP(q[1])+SqrFP(q[2]));
  l=1.0/len;
  r[0]=q[0]*1.0;
  r[1]=q[1]*1.0;
  r[2]=q[2]*1.0;
  r[3]=0.0;
  m=1.0/sqrt(SqrFP(r[0])+SqrFP(r[1]));
  a=sqrt((1.0+r[2])/2.0);
  b=sqrt((1.0-r[2])/2.0);
  s[0]=sqrt(len)*b*r[0]*m;
  s[1]=sqrt(len)*b*r[1]*m;
  s[2]=sqrt(len)*a;
  s[3]=q[3];
}

void QSquare(FDA q, FDA r)			/* r=q^2 */
{
  float a;

  a=2.0*q[0];
  r[0]=SqrFP(q[0])-SqrFP(q[1])-SqrFP(q[2])-SqrFP(q[3]);
  r[1]=a*q[1];
  r[2]=a*q[2];
  r[3]=a*q[3];
}
