/* ***********************************************************************
   *									 *
   *	              Generate Magnetic Fields Database			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

int Xa, Ya, Xb, Yb;
float Ia, Ib;
float k;

void Parameters()
{
  Xa=Round((float) Res*0.34);
  Ya=Round((float) Res*0.60);
  Xb=Round((float) Res*0.68);
  Yb=Round((float) Res*0.40);
  Ia=100.0;
  Ib=-40.0;
  k=2E-07;
}

void CreatMagneticFieldHeightBuffer()
{
  int x, y;
  float Da, Db;
  float Hgt, b;
  Byte Inten;
  int z;

  MaxHeight=Res/2-1;
  HeightBufferScalingFactor();
  for(x=0; x<=Res; x++)
  {
    for(y=0; y<=Res; y++)
    {
      Da=sqrt(Sqr(Xa-x)+Sqr(Ya-y));
      Db=sqrt(Sqr(Xb-x)+Sqr(Yb-y));
      if((Da!=0.0) && (Db!=0.0))
	b=k*(Ia/Da+Ib/Db);
      else
	b=0.0;
      Hgt=fabs(b*1E+08+0.5);
      z=Round(Hgt*0.25);
      Height[x][y]=z;
      Inten=Round(Hgt)&255;
      PutPixel(x, 199-y, Inten/MaxCol, Inten%MaxInten);
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  clrscr();
  printf("Creating Magnetic Field Height Buffer\n");
  ClearHeightBuffer();
  Res=MaxRes;
  Parameters();
  InitGraphics();
  CreatMagneticFieldHeightBuffer();
  strcpy(ObjectFile, "MAGNFLDS");
  SaveHeightBuffer(ObjectFile);
  ExitGraphics();
}



