/* ***********************************************************************
   *									 *
   *		     Cone and Pyramid Database Generator		 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "alloc.h"
#include "math.inc"
#include "graph.inc"
#include "model.inc"
#include "shpmk.inc"

int Theta, DTheta, HalfDTheta;

void SetupCone(int NumOfFacets)
{
  VertexNum=1;
  VertexNumInFacet=1;
  LastFacet=NumOfFacets;
  LastVertexNumInFacet=4;
  LastVertex=LastFacet*LastVertexNumInFacet;
  DTheta=360/LastFacet;
  HalfDTheta=DTheta/2;
  Theta=HalfDTheta;
}

int NumFacetsOnEndCap, T;

void EndCap()
{
  int tmp;

  NumFacetsOnEndCap=LastFacet/2-1;
  tmp=NumFacetsOnEndCap&1;
  if(tmp==1)
    Theta=-90+HalfDTheta;
  else
    Theta=-90+DTheta;
  if(LastFacet==4)
    NumFacetsOnEndCap=2;
  for(T=1; T<=NumFacetsOnEndCap; T++)
  {
    AddVertex(CosD(Theta+HalfDTheta), SinD(Theta+HalfDTheta), -1.0);
    AddVertex(CosD(Theta-HalfDTheta), SinD(Theta-HalfDTheta), -1.0);
    AddVertex(CosD(180-Theta+HalfDTheta), SinD(180-Theta+HalfDTheta), -1.0);
    AddVertex(CosD(180-Theta-HalfDTheta), SinD(180-Theta-HalfDTheta), -1.0);
    ++FacetNum;
    ++LastFacet;
    VertexNumInFacet=1;
    Theta+=DTheta;
  }
}

void MakeConeDatabase()
{
  for(FacetNum=1; FacetNum<=LastFacet; FacetNum++)
  {
    AddVertex(CosD(Theta-HalfDTheta), SinD(Theta-HalfDTheta), -1.0);
    AddVertex(CosD(Theta+HalfDTheta), SinD(Theta+HalfDTheta), -1.0);
    AddVertex(0.0, 0.0, 1.0);
    AddVertex(0.0, 0.0, 1.0);
    Theta+=DTheta;
    VertexNumInFacet=1;
  }
  EndCap();
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupCone(4);
  MakeConeDatabase();
  SaveData("PYRAMID.DAT");
  SetupCone(180);
  MakeConeDatabase();
  SaveData("CONE.DAT");
  ExitGraphics();
  farfree(Facet);
}
