/* Turbo C source for uuclean version 1.70 J.VanBuskirk */

#include <stdio.h>              /* use standard IO header file */
extern unsigned _stklen = 128;  /* set stacklen to 128 words
				 smallest c will allow */

void main(int argc, char *argv[])
{
FILE *in;           /* pointer to input file */
FILE *out;          /* pointer to output file */
char line[81];      /* variables for reading and writing lines */
unsigned int x = 0; /* line counter */
unsigned char c;    /* used for ture/false in filters */

  printf("\nUUClean V1.70 - J.VanBuskirk\n");

  /* check to see if there are 2 arguments */
  if (argc < 2)
  {
  printf("Usage:\nUUClean <INPUT_FILE> <OUTPUT_FILE>\n");
  exit(); /* exit to dos if there are not enough params */
  }

  /* open input file, and check for error */
  if (( in = fopen(argv[1], "r" )) == NULL)
  {
  printf("Could not open file!\n");
  exit(); /* exit to dos if input file cannot be opend */
  }

  /* create output file, and check for error.
  if it exist, overwrite it.             */
  if ((out = fopen(argv[2], "w" )) == NULL)
  {
  printf("Could not create file!\n");
  exit(); /* exit to dos if output file cannot be named */
  }

  while (!feof(in)) /*  while not end of input file */
  {
  c = 0;                              /* set c to false */
  x++;                                /* increment x by 1 */
  printf("\rFilterd %d lines." ,x);
  fgets(line,81,in);                  /* get one line of input file */

 /* filter check for begin, and end */
 if ( ( (line[0] == 'b') || (line[0] == 'e') ) &&
 ( (line[1] == 'e') || (line[1] == 'n') ) ) c = 1;

 /* filter check for UUencoded lines */
 if ( ( (line[0] == 'M') &&  (!islower(line[1]))) || (line[0] =='`') ) c = 1;

 /* if line falls though filter then write to output file */
 if (c == 1)   fprintf(out,"%s",line);
 }

fclose(in); /* close files */
fclose(out);
}
