#include <graphics.h>
#include <stdio.h>
#include <dos.h>
#include <alloc.h>

#define ON  1
#define OFF 0

union REGS regs;

int init_mouse(void);
void show_mouse(void);
void hide_mouse(void);
void mouse_stat(void);

struct mouse_status
{
	int x;
	int y;
	int button;
} mouse;

void main(int count, char *list[])
{
	FILE *f;
	int ega = EGA, egahi = EGAHI, error, i, color, x, y, xx, yy, size;
	char quit, *buffer;

	registerbgidriver(EGAVGA_driver);
	initgraph(&ega, &egahi, "");
	error = graphresult();
	if (!error && init_mouse())
	{
		setcolor(8);
		for (i = 0; i <= 288; i += 9)
		{
			line(0, i, 288, i);
			line(i, 0, i, 288);
		}
		line(290, 0, 323, 0);
		line(290, 33, 323, 33);
		line(290, 0, 290, 33);
		line(323, 0, 323, 33);
		for (i = 0; i < 15; i++)
		{
			setfillstyle(SOLID_FILL, i + 1);
			bar(i * 32, 317, i * 32 + 32, 349);
		}
		line(0, 316, 481, 316);
		line(481, 316, 481, 349);
		setcolor(7);
		line(0, 315, 482, 315);
		line(482, 315, 482, 349);
		line(624, 0, 639, 0);
		line(624, 0, 624, 63);
		line(624, 15, 639, 15);
		line(624, 31, 639, 31);
		line(624, 47, 639, 47);
		line(624, 63, 639, 63);
		line(639, 63, 639, 0);
		outtextxy(628, 5, "X");
		outtextxy(628, 20, "L");
		outtextxy(628, 36, "S");
		outtextxy(628, 52, "C");
		color = 15;
		setfillstyle(SOLID_FILL, color);
		bar(607, 316, 639, 349);
		setcolor(color);
		show_mouse();
		quit = OFF;
		while (quit == OFF)
		{
			mouse_stat();
			if (mouse.button == 1 && mouse.x < 288 && mouse.y < 288)
			{
				hide_mouse();
				while (mouse.button == 1 && mouse.x < 288 && mouse.y < 288)
				{
					setfillstyle(SOLID_FILL, color);
					xx = mouse.x / 9;
					yy = mouse.y / 9;
					x = xx * 8 + xx + 1;
					y = yy * 8 + yy + 1;
					bar(x, y, x + 7, y + 7);
					putpixel(291 + xx, 1 + yy, color);
					mouse_stat();
				}
				show_mouse();
			}
			else
			if (mouse.button == 2 && mouse.x < 288 && mouse.y < 288)
			{
				hide_mouse();
				while (mouse.button == 2 && mouse.x < 288 & mouse.y < 288)
				{
					setfillstyle(SOLID_FILL, 0);
					xx = mouse.x / 9;
					yy = mouse.y / 9;
					x = xx * 8 + xx + 1;
					y = yy * 8 + yy + 1;
					bar(x, y, x + 7, y + 7);
					putpixel(291 + xx, 1 + yy, 0);
					mouse_stat();
				}
				show_mouse();
			}
			else
			if (mouse.button == 1 && mouse.x > 624 && mouse.y < 15)
				quit = ON;
			else
			if (mouse.button == 1 && mouse.x > 624 && mouse.y > 15 && mouse.y < 31)
			{
				if (count == 2)
				{
					f = fopen(list[1], "rb");
					if (f != NULL)
					{
						size = imagesize(291, 1, 322, 32);
						buffer = (char *) malloc(size);
						fread(buffer, size, 1, f);
						fclose(f);
						i = 0;
						putimage(291, 1, buffer, COPY_PUT);
						for (y = 0; y < 32; y++)
							for (x = 0; x < 32; x++)
							{
								setfillstyle(SOLID_FILL, getpixel(291 + x, 1 + y));
								i++;
								xx = x * 8 + x + 1;
								yy = y * 8 + y + 1;
								bar(xx, yy, xx + 7, yy + 7);
							}
						free(buffer);
					}
				}
			}
			else
			if (mouse.button == 1 && mouse.x > 624 && mouse.y > 31 && mouse.y < 47)
			{
				if (count == 2)
				{
					f = fopen(list[1], "wb");
					size = imagesize(291, 1, 322, 32);
					buffer = (char *) malloc(size);
					getimage(291, 1, 322, 32, buffer);
					fwrite(buffer, size, 1, f);
					fclose(f);
					free(buffer);
				}
			}
			else
			if (mouse.button == 1 && mouse.x > 624 && mouse.y > 47 && mouse.y < 63)
			{
				setfillstyle(SOLID_FILL, color);
				bar(291, 1, 322, 32);
				for (y = 0; y < 32; y++)
					for (x = 0; x < 32; x++)
					{
						xx = x * 8 + x + 1;
						yy = y * 8 + y + 1;
						bar(xx, yy, xx + 7, yy + 7);
					}
			}
			else
			if (mouse.button == 2 && mouse.x > 624 && mouse.y > 47 && mouse.y < 63)
			{
				setfillstyle(SOLID_FILL, 0);
				bar(291, 1, 322, 32);
				for (y = 0; y < 32; y++)
					for (x = 0; x < 32; x++)
					{
						xx = x * 8 + x + 1;
						yy = y * 8 + y + 1;
						bar(xx, yy, xx + 7, yy + 7);
					}
			}
			else
			if (mouse.button == 1 && mouse.x < 481 && mouse.y > 316)
			{
				hide_mouse();
				color = getpixel(mouse.x, mouse.y);
				setfillstyle(SOLID_FILL, color);
				bar(607, 316, 639, 349);
				show_mouse();
			}
		}
		hide_mouse();
		closegraph();
	}
}

int init_mouse(void)
{
	regs.x.ax = 0;
	int86(0x33, &regs, &regs);
	return regs.x.ax;
}

void show_mouse(void)
{
	regs.x.ax = 1;
	int86(0x33, &regs, &regs);
}

void hide_mouse(void)
{
	regs.x.ax = 2;
	int86(0x33, &regs, &regs);
}

void mouse_stat(void)
{
	regs.x.ax = 3;
	int86(0x33, &regs, &regs);
	mouse.x = regs.x.cx;
	mouse.y = regs.x.dx;
	mouse.button = regs.x.bx & 3;
}