/*===========================================================================*\
| PULLWORK.C - Work Window functions for main work area     ver 2.0, 04-15-89 |
|              for PULLDEMO.C                                                 |
| This file contains all the functions executed for the work window.  These   |
| are the main steps of your program.  With this, you can create a sophisti-  |
| cated multi-level window environment.                                       |
|   Copyright (c) 1989 James H. LeMay, All rights reserved.                   |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include "pullc20.h"
#include "pulldemo.h"

/*========================= Work Window Steps ===============================*\
| This module will have all the functions for the work window(s).             |
| Each step assumes that some keystroke has been pressed and returns a value  |
| for key and extkey and any necessary change to workwndwstep.                |
\*---------------------------------------------------------------------------*/
int start1=ABYTE2_DE;
int start2=AHEX2_DE;

#ifdef MULTIWORKWNDWS
extern int topworkwndwname=WINDOW1;

/*=========================| resetworkwndwstep |============================*\
\*==========================================================================*/
void resetworkwndwstep(void)
{
    switch(tws.wsname) {
        case WINDOW1:  workwndwstep = 1;  break;
        case WINDOW2:  workwndwstep = 3;  break;
    }
}

/*============================| hideworkwndw |==============================*\
\*==========================================================================*/
void hideworkwndw(void)
{
    hidewindow();
    topworkwndwname = tws.wsname;
    resetworkwndwstep();
}

/*===========================| accessworkwndw |=============================*\
\*==========================================================================*/
void accessworkwndw( int wn )
{
    if(wn != tws.wsname) {
        /* -- if accessing a PERMMODE window, hide all upper windows. -- */
        if(getlevelindex(wn) <= pli)
            while(li>pli)
                hidewindow();      /* Use removewindow for serial access */
        accesswindow(wn);
        resetworkwndwstep();
    }
}
#endif

/*==============================| kbdidle |=================================*\
\*==========================================================================*/
void kbdidle(void)
{
    /* Nothing to include this time, but fill in what you want to do while */
    /* the keyboard is idle. */
}

/*=============================| showfields |===============================*\
\*==========================================================================*/
void showfields(void)
{
    wwrite( 14,  5, "Byte:" );
    wwrite( 15,  5, "Unsigned byte:" );
    wwrite( 16,  5, "Int:" );
    wwrite( 17,  5, "Unsigned int:" );
    wwrite( 18,  5, "Long:" );
    wwrite( 19,  5, "Double:" );
    wwrite( 14, 39, "Hex:" );
    wwrite( 15, 39, "Char:" );
    wwrite( 16, 39, "String:" );
    wwrite( 17, 39, "File name:" );
    displayfields( ABYTE2_DE, FILENAME_DE );
}    

#if 0

/*===========================| makeworkwndw2 |==============================*\
\*==========================================================================*/
void makeworkwndw2(void)
{
    setwindowmodes( HIDDENMODE );
    makewindow( 8, 21, 10, 40, LIGHTBLUE+LIGHTGRAY_BG, LIGHTBLUE+LIGHTGRAY_BG,
                DOUBLE_BORDER, WINDOW2 );
    setwindowmodes(0);
    writetohidden( WINDOW2 );
    titlewindow( TOP,   LEFT  ,SAMEATTR, "2" );
    titlewindow( TOP,   CENTER,SAMEATTR, " Work Window 2 " );
    titlewindow( BOTTOM,CENTER,SAMEATTR, " Press ESC to Hide " );
    wwritec( 1, "Type in any input" );
    wgotorc( 2, 1 );
    writetocrt();
}

#endif

void editfields(void)
{
    /* Only filename may have been changed */
    displayfields( FILENAME_DE, FILENAME_DE );
    enterseq( ABYTE2_DE, FILENAME_DE, &start1 );
}

void initworkwndws(void)
{
    showfields();
    workwndwstep = 1;
    key = NULLKEY;     /* 0x00 */
}

void workwndw(void)
{
#ifdef MULTIWORKWNDWS
    accessworkwndw( topworkwndwname );
#endif
    switch(workwndwstep) {
        case 0:  initworkwndws();  break;
        case 1:  editfields();     break;
    }
}

