/*===========================================================================*\
| GOOF.C - displays fatal programming errors                ver 2.0, 04-15-89 |
|          for PULLC and WNDWC                                                |
|                                                                             |
| This file contains a convenient way to alert you of programming errors      |
| since it is possible to create unseen errors with virtual and hidden        |
| windows.                                                                    |
|   Copyright (c) 1989 by James H. LeMay,  All rights reserved.               |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <process.h>

#include "pullc20.h"

void showgoof( char errornum )
{
    char msg1[41],msg2[41],core[41],farcore[41];

    msg2[0]=0;

    switch(errornum) {
        case  1:
            strcpy( msg1, "Not enough Heap space!" );
            ltoa(coreleft(),core,10);
            ltoa(farcoreleft(),farcore,10);
            strcpy( msg2, "core=" );      strcat( msg2, core );
            strcat( msg2, "/farcore=" );  strcat(msg2,farcore);   break;
        case  2: strcpy( msg1, "Too many Windows!" );             break;
        case  3: strcpy( msg1, "Too many Virtual Windows!" );     break;
        case  4: strcpy( msg1, "Perm window out of order!" );     break;
        case  5: strcpy( msg1, "No window to remove!" );          break;
        case  6: strcpy( msg1, "Hidden window not found!" );      break;
        case  7: strcpy( msg1, "Virtual screen not found!" );     break;
        case  8: strcpy( msg1, "Video page not available!" );     break;
        case 10: strcpy( msg1, "A Submenu could not fit!" );      break;
    }
    li = 0;                       /* set top window level */
    topwndwstat = wndwstat[0];    /* get original CRT stat */
    qscr = tws.vscr;              /* set QWIKC stats */
    qwritepage(0);                /* ensure we are writing to page 0 */
    qviewpage(0);                 /* ensure we are viewing page 0 */
    windowmodes = RELMODE;
    makewindow( 0, 0, 5, 42, LIGHTGRAY_BG, LIGHTGRAY_BG+BLINK,
                DOUBLE_BORDER, AWINDOW );
    wwritec( 1, msg1 );
    wwritec( 2, msg2 );
    wwritec( 3, "Program halted." );
    setcursor( cursor_initial );
    exit(1);
}

