;
;                        MEMBLOCK Reallocate Mem Block
;
;
; Borland C++ 4.0 for WIN32 prototype:
; PTR   __pascal mbrealloc (MEMBLOCK *mb, PTR ptr, DWORD size);
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBREALLOC


extrn MBMALLOC:near, MBFREE:near


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 8
arg2 = 4
arg3 = 0

MBREALLOC:      push ebx esi edi ebp
pct = (4)+(4*4)

                mov  ecx, [esp+pct+arg3]        ; - New size
                mov  edx, [esp+pct+arg2]        ; -> MemArea to resize
                mov  esi, [esp+pct+arg1]        ; -> MEMBLOCK

                ;-- Align new size; is size valid
                add  ecx, 03h
                and  ecx, NOT (03h)             ; dword alignment
                js   ExitNull
                jnz  a00                        ; if zero, then free

;--------------- Do FREE
; void __pascal mbfree (MEMBLOCK *mb, PTR ptr);
                push esi                        ; -> MEMBLOCK
                push edx                        ; -> MemArea to free
                call MBFREE
                xor  eax, eax
                jmp  Exit

;---------------

a00:            ; 0 < requested size < 2^31
                ;-- MemArea ptr null (do a regular malloc) ?
                or   edx, edx
                jnz  a10

;--------------- Do MALLOC
;PTR __pascal mbmalloc (MEMBLOCK *mb, DWORD size);
                push esi                        ; -> MEMBLOCK
                push ecx                        ; New size
                call MBMALLOC
                ; eax = ptr to memarea (or null)
                jmp  Exit
;---------------

a10:            ;-- Get MemNode ptr
                sub  edx, size MemNode          ; -> MemNode to resize

                ;-- Load MEMBLOCK info
                mov  ebx, [esi+MEMBLOCK.base]   ; linear adx
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  ebp, [esi+MEMBLOCK.size]   ; size of MEMBLOCK
                add  ebp, ebx                   ; -> final adx + 1

                ;-- MEMBLOCK uninitalized?
                cmp  ebp, ebx
                je   ExitNull

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  CorruptMB
                add  ebx, MBSigSize             ; -> 1st MemNode
EndIf
                ;-- Init previous MemNode ->
                xor  edi, edi

;---------------

FindNode:
; ebx -> current MemNode
; ecx - new size
; edx -> MemNode to resize
; edi -> Previous MemNode
; ebp -> final byte of MEMBLOCK + 1

If DebugMode    ;-- Check MemNode
                mov  eax, [ebx+MemNode.size]
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  CorruptMB                  ; invalid MemNode?
EndIf
                ;-- Is current MemNode the one to resize?
                cmp  edx, ebx
                je   FoundNode

                ;-- Store previous MemNode
                mov  edi, ebx

                ;-- Point to next node
                mov  eax, [ebx+MemNode.size]
                and  eax, 7fffffffh             ; kill 'used' flag if there
                add  ebx, size MemNode          ; skip MemNode
                add  ebx, eax                   ; skip MemAera

                ;-- Any more nodes to check?
                cmp  ebx, ebp
                jb   FindNode
                ja   CorruptMB
                jmp  ExitNull                   ; end of MEMBLOCK

;---------------

FoundNode:
; ebx -> MemNode to resize
; ecx - new size
; edi -> Previous MemNode (null if none)
; ebp -> final byte of MEMBLOCK + 1

                ;-- Get old size
                mov  eax, [ebx+MemNode.size]
                xor  eax, 80000000h
                js   ExitNull                   ; MemNode was free

                ;-- Make MemArea larger, smaller or equal?
                cmp  ecx, eax
                ja   Larger

;--------------- Make MemArea smaller (or equal)

Smaller:
; eax - old size
; ebx -> MemNode to resize
; ecx - new size
; ebp -> final byte of MEMBLOCK + 1

                ;-- Get Ptr to next Node
                mov  esi, ebx
                add  esi, size MemNode
                add  esi, eax
                cmp  esi, ebp
                je   NoNextMemArea
                ja   CorruptMB

                ;-- Is it free memory?
                mov  edx, [esi+MemNode.size]
If DebugMode
                xor  edx, NodeSigKey
                cmp  [esi+MemNode.sig], edx
                jne  CorruptMB
                xor  edx, NodeSigKey
EndIf
                or   edx, edx
                js   NoNextMemArea

                ;-- Kill next MemNode if free memory
                mov  [esi+MemNode.size], 0      ; invalidate MemNode

                ;-- add to current block size
                add  edx, size MemNode
                add  eax, edx                   ; must create 2 nodes now!!
NoNextMemArea:

                ;-- Can we create a new MemNode and Area?
                sub  eax, ecx                   ; # bytes left over
                sub  eax, size MemNode          ; # bytes after header
                jbe  ExitPtr                    ; not enough bytes left
                ; eax - # bytes for 2nd MemArea

                ;-- Write 1st MemNode info
                mov  edx, ecx
                or   edx, 80000000h             ; mark area used
                mov  [ebx+MemNode.size], edx
If DebugMode
                xor  edx, NodeSigKey
                mov  [ebx+MemNode.sig], edx
EndIf

                ;-- Get ptr to 2nd MemNode
                add  ebx, size MemNode          ; for 1st MemNode
                add  ebx, ecx                   ; -> 2nd MemNode

                ;-- Write 2nd MemNode info
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
EndIf
                ;-- Return with pointer on stack
                jmp  ExitPtr

;--------------- Make MemArea larger

Larger:
; eax - old size
; ebx -> MemNode to resize
; ecx - new size
; edi -> Previous MemNode (null if none)
; ebp -> final byte of MEMBLOCK + 1

                ;-- Check next node
                mov  esi, ebx
                add  esi, size MemNode          ; for orig MemNode
                add  esi, eax
                cmp  esi, ebp
                ja   CorruptMB
                je   NoNext

                ;-- Is next MemArea free?
                mov  edx, [esi+MemNode.size]
If DebugMode
                xor  edx, NodeSigKey
                cmp  [esi+MemNode.sig], edx
                jne  CorruptMB
                xor  edx, NodeSigKey
EndIf
                or   edx, edx
                js   NoNext                     ; not free!

                ;-- Next MemNode enough?
                add  eax, size MemNode          ; for next MemNode
                add  eax, edx
                cmp  ecx, eax
                ja   NextNotEnough

                ;-- Kill 2nd MemNode header
                mov  [esi+MemNode.size], 0

                ;-- Join with 1st MemNode
                or   eax, 80000000h             ; mark as used
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh
                ;-- Now we're making the new node smaller (or equal)
                ;   with no memory moves
; eax - avail size
; ebx -> orig MemNode of size EAX
; ecx - new size
; ebp -> final byte of MEMBLOCK + 1
                jmp  Smaller

;---------------

NoNext:         xor  esi, esi                   ; no next node
NextNotEnough:
; eax - total avail size so far
; ebx -> orig MemNode
; ecx - requested size
; esi -> next MemNode (or null)
; edi -> prev MemNode (or null)

                ;-- Any prev MemNode?
                or   edi, edi
                jz   NoPrev

                ;-- Is previous MemArea free?
                mov  edx, [edi+MemNode.size]
If DebugMode
                xor  edx, NodeSigKey
                cmp  [edi+MemNode.sig], edx
                jne  CorruptMB
                xor  edx, NodeSigKey
EndIf
                or   edx, edx
                js   NoPrev                     ; not free!

                ;-- With prev enough?
                add  eax, edx
                add  eax, size MemNode          ; for orig MemNode
                cmp  ecx, eax
                ja   PrevNotEnough

                ;-- Kill next MemNode if exists
                or   esi, esi
                jz   NoNextKill
                mov  [esi+MemNode.size], 0
NoNextKill:
                ;-- Save requested size
                mov  edx, ecx

                ;-- Set copy length
                mov  ecx, [ebx+MemNode.size]    ; from orig MemNode
                and  ecx, 7fffffffh

                ;-- Kill orig MemNode
                mov  [ebx+MemNode.size], 0

                ;-- Set source for copy
                mov  esi, ebx
                add  esi, size MemNode          ; -> orig MemArea

                ;-- Save prev MemNode ptr
                mov  ebx, edi

                ;-- Set dest for copy
                add  edi, size MemNode          ; -> prev MemArea

                ;-- Update stack MemArea ptr for exit code
                mov  [esp+pct+arg2], edi

                ;-- Copy data, length dword aligned
                shr  ecx, 2
                rep  movsd

                ;-- Write info for new node
                or   eax, 80000000h             ; mark size as used
                mov  [ebx+MemNode.size], eax    ; -> prev MemNode
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh

                ;-- Restore requested size
                mov  ecx, edx

                ;-- Shrink new node
; eax - avail size (new size of prev MemNode)
; ebx -> prev MemNode
; ecx - requested size
; ebp -> final byte of MEMBLOCK + 1
                jmp  Smaller

;---------------

NoPrev:
PrevNotEnough:
; ebx -> orig memnode
; ecx - requested size

                ;-- Try a malloc within the same memory block
                ; PTR   __pascal mbmalloc (MEMBLOCK *mb, DWORD size);
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                push eax
                push ecx
                call MBMALLOC                   ; ebx is preserved

                ;-- Did we get the requested memory?
                or   eax, eax
                jz   ExitNull                   ; could not increase size

                ;-- Copy memory
                mov  ecx, [ebx+MemNode.size]
                and  ecx, 7fffffffh             ; orig MemArea size
                mov  esi, ebx
                add  esi, size MemNode          ; -> orig MemArea
                mov  edi, eax                   ; -> new MemArea
                shr  ecx, 2                     ; copy size / 4
                rep  movsd

                ;-- Update stack MemArea ptr (for exit)
                mov  [esp+pct+arg2], eax

                ;-- Free orig MemArea
                ; void  __pascal mbfree (MEMBLOCK *mb, PTR ptr);
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                add  ebx, size MemNode          ; -> orig MemArea
                push eax
                push ebx
                call MBFREE

                jmp  short ExitPtr

;---------------

ExitNull:       xor  eax, eax
                jmp  short Exit

;---------------

ExitPtr:        mov  eax, [esp+pct+arg2]        ; -> MemArea

;---------------

Exit:           pop  ebp edi esi ebx
                ret  12                         ; 3 args

;---------------

CorruptMB:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ebx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ebx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  [dword ebx], MBSigInvl
EndIf
                jmp  short ExitNull


;
EndS    _TEXT
End

