#include <time.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <i86.h>
#include "screen.h"

typedef struct {
        WORD x0;
        WORD y0;
        WORD x1;
        WORD y1;
        } RECTANGLE;

RECTANGLE Rects[5000];
WORD RectIndex = 1;
BYTE ColBuffer[256][3];

void DrawPlasmaRect(WORD x0, WORD y0, WORD x1, WORD y1);
void SetCol(WORD nr, BYTE r, BYTE g, BYTE b);
void GetCol(WORD nr, BYTE *r, BYTE *g, BYTE *b);

void main(void)
{
  WORD count;
  WORD x1, y1, x0 = 0, y0 = 0;
  BYTE col1, col2, col3, col4;
  WORD ColCount, bak;

  cprintf("\n\rx1 (e.g. 319): ");
  scanf("%d", &x1);
  cprintf("y1 (e.g. 199): ");
  scanf("%d", &y1);
  cprintf("col1 (1-255): ");
  scanf("%d", &col1);
  cprintf("col2 (1-255): ");
  scanf("%d", &col2);
  cprintf("col3 (1-255): ");
  scanf("%d", &col3);
  cprintf("col4 (1-255): ");
  scanf("%d", &col4);

  InitGraph();

  for(count = 1; count < 64; count++)
    SetCol(count, count, 0, 0);
  for(count = 64; count < 128; count++)
    SetCol(count, ~count, 0, count);
  for(count = 128; count < 128+64; count++)
    SetCol(count, 0, count, ~count);
  for(count = 128+64; count < 256; count++)
    SetCol(count, 0, ~count, 0);
  for(count = 1; count <= 255; count++)
    GetCol(count, &ColBuffer[count-1][0], &ColBuffer[count-1][1],
           &ColBuffer[count-1][2]);

  SetPixel(x0, y0, col1);
  SetPixel(x1, y0, col2);
  SetPixel(x1, y1, col3);
  SetPixel(x0, y1, col4);
  getch();

  while(RectIndex > 0 && !kbhit())
  {
    while((x1 - x0) > 1)
    {
      DrawPlasmaRect(x0, y0, x1, y1);

      RectIndex++;
      Rects[RectIndex].x0 = x0;
      Rects[RectIndex].y0 = (y1+y0)/2;
      Rects[RectIndex].x1 = (x1+x0)/2;
      Rects[RectIndex].y1 = y1;

      RectIndex++;
      Rects[RectIndex].x0 = (x1+x0)/2;
      Rects[RectIndex].y0 = (y1+y0)/2;
      Rects[RectIndex].x1 = x1;
      Rects[RectIndex].y1 = y1;

      RectIndex++;
      Rects[RectIndex].x0 = (x1+x0)/2;
      Rects[RectIndex].y0 = y0;
      Rects[RectIndex].x1 = x1;
      Rects[RectIndex].y1 = (y1+y0)/2;

      x1 = (x1+x0)/2;
      y1 = (y1+y0)/2;
    }

    x0 = Rects[RectIndex].x0;
    y0 = Rects[RectIndex].y0;
    x1 = Rects[RectIndex].x1;
    y1 = Rects[RectIndex].y1;
    RectIndex--;
  }

  ColCount = 1;
  while(!kbhit())
  {
    bak = ColCount;

    for(count = 1; count < 255; count++)
    {
      SetCol(count, ColBuffer[ColCount][0], ColBuffer[ColCount][1],
             ColBuffer[ColCount++][2]);

      if(ColCount > 255)
        ColCount = 0;
    }

    ColCount = bak + 1;

    if(ColCount >= 255)
      ColCount = 1;
  }
  CloseGraph();
}

void DrawPlasmaRect(WORD x0, WORD y0, WORD x1, WORD y1)
{
  BYTE Color[4];

  Color[0] = GetPixel(x0, y0);
  Color[1] = GetPixel(x1, y0);
  Color[2] = GetPixel(x1, y1);
  Color[3] = GetPixel(x0, y1);

  SetPixel((x1+x0)/2, (y1+y0)/2, ((Color[0]+Color[1]+Color[2]+Color[3])/4));
  SetPixel((x1+x0)/2, y0, (Color[0]+Color[1])/2);
  SetPixel((x1+x0)/2, y1, (Color[3]+Color[2])/2);
  SetPixel(x0, (y1+y0)/2, (Color[0]+Color[3])/2);
  SetPixel(x1, (y1+y0)/2, (Color[1]+Color[2])/2);
}

void SetCol(WORD nr, BYTE r, BYTE g, BYTE b)
{
  outp(0x3C8, nr);
  outp(0x3C9, r);
  outp(0x3C9, g);
  outp(0x3C9, b);
}

void GetCol(WORD nr, BYTE *r, BYTE *g, BYTE *b)
{
  outp(0x3C7, nr);
  *r = inp(0x3C9);
  *g = inp(0x3C9);
  *b = inp(0x3C9);
}