/*	PCXshow.c   -  Simple PCX Slide Show for all three video boards.

	Update History:
	
	10-Mar-88:  starting. using the PCX Tech Doc as documentation
	            for now.
	12-Mar-88:  This file created from PCX.C. Works but needs 
	            ability to handle color planes.
	01-Apr-88:  starting on a version that uses the VGR functions
	            to show PCX files on any video board.
	21-Jun-88:  Extremely late! mods that should've been done 2 
	            months ago!

	Note: sorry, I was too busy to write the routines to convert
	      pictures from one format to another. This routine will
	      actually display any picture on any adapter, but the
	      results will look funny in some cases.

	15-Aug-88:  re-installed the ref_expand() code for file names.
*/


#define ALLOCATE
#include <stdio.h>
#undef NULL
#include <defs.h>
#include <fcntl.h>
#include "pcx.h"
#include <stpwatch.h>

char *spec;

int show_flg = 0;
long show_time = 100;
struct TIMER timer;
int inverse = 0;
int palette = 0;


char language = 'E';


main( argc, argv )
char **argv;
int argc;
{
	int i;

	if ( argc < 2 )
	{  help();
	   exit(1);
	};

	for ( i=1; i < argc; i++ )
	   if ( *argv[i] == '-' )
	      check_option( argv[i]+1 );

	if ( vgr_setup( spec ) )
	   CRASH("vgr_setup failed!");

	if ( vgr_type == TYPE_UNKNOWN )
	   CRASH( "ERROR: Can't Identify Video Board!" );
	if ( vgr_type == TYPE_MDA )
	   CRASH( "ERROR: Requires a graphic board" );

	printf("%s Video Board Detected\n", vgr_type_name );
	printf("hit return to continue, or ^C to exit:");
	getchar();

	for ( i=1; i < argc; i++ )
	   if ( *argv[i] != '-' )
	      dmppcx( argv[i] );

	enjoy();
	if ( show_flg )
	   vgr_mode( 3 );
}


check_option( opt )
char *opt;
{
	     if ( *opt == 'd' )
	        show_time = atoi( opt + 1 ) * 10l;
	else if ( *opt == 'i' )
	        inverse = 1;
	else if ( *opt == 'n' )
	        inverse = 0;
	else if ( *opt == 'p' )
	        palette = 1;
	else if ( !strcmp( opt, "cga" ) )
	        spec = opt;
	else if ( !strcmp( opt, "ega" ) )
	        spec = opt;
	else if ( !strcmp( opt, "cga2" ) )
	        spec = opt;
	else if ( !strcmp( opt, "herc" ) )
	        spec = opt;
	else if ( *opt == '?' )
	        help();
	else {  printf( "unknown option: %s, try \"PCXDISP -?\"\n", opt );
	        exit(1);
	     };
}


dmppcx( fn )
char *fn;
{
	char *argv[99];
	int i, argc;

	argc = ref_expand( argv, 99, fn );
	if ( argc < 0 )
	   err_exitf( -argc, "error expanding %s\n", fn );

	for ( i=0; i < argc; i++ )
	   _dmppcx( argv[i] );
}


_dmppcx( fn )
char *fn;
{
	PCXPIC *pic, *load_picture();

	pic = load_picture( fn );

	if (inverse) 
	   pcx_invert_pic( pic );

	if ( palette && vgr_type == TYPE_EGA )
	   play_with_palette( pic );
	else display_picture( pic );

	pcx_free_pic( pic );
}


PCXPIC *load_picture( fn )
char *fn;
{
	PCXPIC *pic, *pcx_init_pic();
	FILE *fp, *bufopen();

	fp = bufopen( fn, "r" );

	if ( !( pic = pcx_init_pic( 0, 0, 0 ) ) )
	   CRASH( "out of memory" );

	if ( pcx_read_pic( pic, fp ) )
	{  printf( "pcx_read_pic failed reading %s", fn );
	   CRASH("");
	};

	bufclose(fp);
	return pic;
}


display_picture( pic )
PCXPIC *pic;
{
	unsigned long stopwatch();

	enjoy();
	if ( (*vgr_nit)() )
	   CRASH( "Board init failed" );
	if ( VGR_MODE( vgr_md ) )
	   CRASH( "Mode select failed" );

	VGR_CLEAR();

	pcx_showpic( pic, 0, 0, 0 );

	stopwatch( 1, &timer );
	show_flg = 1;
}


enjoy()
{
	int c = 0;

	if ( show_flg )
	   while ( stopwatch( 0, &timer ) < show_time )
	      if ( constat() )
	         if ( (c = conin()) == 27 || c == 32 )
	            break;
	         else errbeep();

	if ( c == 27 )
	{  vgr_mode( 3 );
	   exit(0);
	};
}


play_with_palette( pic )
PCXPIC *pic;
{
	char buf[64];
	int p, c, r, g, b;

	p = r = g = b = 0;
top:	vgr_mode( 3 );
	printf("Palette=%d, R%d G%d B%d\n", p, r, g, b );
	printf("p#, r#, g# or b#:");
	gets(buf);

	if ( *buf )
	{  if ( *buf == 'r' )
	      r = atoi(buf+1);
	   if ( *buf == 'g' )
	      g = atoi(buf+1);
	   if ( *buf == 'b' )
	      b = atoi(buf+1);
	   if ( *buf == 'p' )
	      p = atoi(buf+1);
	};

	show_flg = 0;
	display_picture( pic );
pal:	r &= 0x03; g &= 0x03; b &= 0x03; p &= 0x0f;
	ega_set_palette( p, r, g, b );

	sound( 500 + ( (b & 0x01)     | !!(b & 0x02) *  8
	           | !!(g & 0x01) * 2 | !!(g & 0x02) * 16
	           | !!(r & 0x01) * 4 | !!(r & 0x02) * 32 )
	               * 100, 10 );

	while ( (c=conin()) != 27 && c != 3 && c != '+' && c != '-' )
	   errbeep();

	if ( c == 3 )
	{  vgr_mode( 3 );
	   exit(0);
	};

	if ( c == '+' || c == '-' )
	   if ( *buf == 'r' || *buf == 'g' || *buf =='b' )
	   {  if ( *buf == 'r' )
	         r += (c=='+') ? 1 : -1;
	      if ( *buf == 'g' )
	         g += (c=='+') ? 1 : -1;
	      if ( *buf == 'b' )
	         b += (c=='+') ? 1 : -1;
	      goto pal;
	   };

	goto top;
}


help()
{
err_exitf( 1, "\
usage: PCXDISP [options...] [file_refs...]\n\
\n\
       PCXDISP is a simple slide show utility. Each .PCX file\n\
       listed is shown for a period of time. Options are as follows:\n\
\n\
       -cga   force CGA 640x200x2 mode\n\
       -cga2  force CGA 320x200x4 mode\n\
       -ega   force EGA 640x350x16 mode\n\
       -herc  force HERC 720x348x2 mode\n\
       -dnn   set the delay between 'slides' to <nn> seconds\n\
       -i     Invert all bits in the image before displaying\n\
       -n     Stop inverting bits in the image\n\
       -p     Allow interactive tinkering with palette registers\n\
              works only in EGA mode; try ESC, ^C, +, -, r, g & b keys.\n\
       -?     Show this help message\n" );
}


