/* DISPCX.C       READ & DISPLAY A *.PCX FILE ms Quick C set for EGA mode */

/* M. CLYNES  07-24-89 */

/*  command line format >DISPCX photo1.pcx */
/*  program set for 1/4  file size display */

#include "stdio.h"
#include "math.h"
#include "graph.h"

#define COLOR 1
#define HOROFF   10
#define TOPOFF   70

struct pcxheader{
       char manufact;
       char version;
       char encode;
       char bpp;
       int xmin;
       int ymin;
       int xmax;
       int ymax;
       int hres;
       int vres;
       char colormap[50];
       int bpline;
       int paletinfo;
       char blank[58];
       } header;

/*=======================================================================*/
/*========================== MAIN() =====================================*/
int main( argc, argv )
	int argc;
	char *argv[2];
{
       int data, line, status, bytesline, cnt;
       char decodebuff[200];
       FILE *fp;


       _setvideomode(_ERESCOLOR);
       _clearscreen(_GCLEARSCREEN);

	if((fp = fopen(argv[1],"rb")) == NULL)
	 {
	  printf("ERROR: FILE '%s' CANNOT BE OPENED.\n",argv[2]);
	  exit(0);
	  _setvideomode(_DEFAULTMODE);
	 }

       bytesline =  readheader(fp);
       cnt = 0;
       line = TOPOFF;
       status = 0;
			      /* do EXTRA READS to srink vertical */
       while(status != EOF)
	    {
	     status = decodepcx(decodebuff, bytesline, fp);
	     status = decodepcx(decodebuff, bytesline, fp);
	     status = decodepcx(decodebuff, bytesline, fp);
	     pixeldump(decodebuff, bytesline, line);
	     line++;
	    }

    printf("PRESS 'ENTER' to contimue");
    getch();
    _setvideomode(_DEFAULTMODE);
}  /* End of main() */


/*========================================================================*/
/*                   read .PCX header into structure */
/*========================================================================*/
readheader(fp)
FILE *fp;
{
   int count;
   char *loader;


   loader = (char *) &header;

   for(count = 0; count < 127; count++)
     {
      *loader = (char)fgetc(fp);
      loader++;
     }

printf("Encoding type %d\n",header.encode);
printf("Window X-min = %4d,  Y-min = %4d\n",header.xmin, header.ymin);
printf("Window X-max = %4d,  Y-max = %4d\n",header.xmax, header.ymax);
printf("Hres = %4d,  Vres = %4d\n",header.hres, header.vres);

printf("# bytes per/scan line %4d   ",header.bpline);

return(header.bpline);
}
/*========================================================================*/
/*   gobal decoded data   char decodebuff[200];  */
/*========================================================================*/
/* Decode a line of .PCX */
/* This procedure reads one encoded line from the image file */
/* 0 = valid data stored     */
/* EOF = out of data in file */

decodepcx(decodebuff, bytesline, fp)
char *decodebuff;          /* where to place data */
int bytesline;            /* # of bytes per line */
FILE *fp;                 /*  image file handle  */
{
   int data;
   int cnt;

    while(bytesline > 0 )
	{
	cnt = 1;
	if(EOF == (data = getc(fp))) return(EOF);   /* retrive a data byte */
	if(0xc0 == (0xc0 & data))
	  {
	   cnt = 0x3f & data;                        /* get repeat count */
	   if(EOF == (data = getc(fp))) return(EOF); /* get real data */
	  }

	 /* expand data into buffer */
	  while(cnt)
	       {
		*decodebuff = data;
		decodebuff++;
		bytesline--;
		cnt--;
	       }
	}
	return(0);   /* file read status */
}

/* decodepcx()  end */

/*========================================================================*/
/*                      pixel line dump */
/*========================================================================*/
/* DUMP A RASTER LINE TO DISPLAY */
/* pixeldump((pointer buffer), (# of BYTES), (Y line on screen to dump))*/

pixeldump(rdbuff, bytes, line)
char *rdbuff;
int bytes, line;
{
	unsigned x;
	unsigned char byte, loop;

	bytes = (bytes * 8) + HOROFF;

	for(x = HOROFF; x < bytes; rdbuff++)
	  {
	   byte = *rdbuff;              /*  >>= 2 srink HORZ.  or >>= 1 */
	   for (loop = 0x80; loop > 0; loop >>= 2)
	     {
	      if (loop & byte) _setpixel(x, line);
	      x++;
	     }
	  }
}

/* pixeldump() End */

