/*    ͻ
          quadrics = Program to demonstrate the drawing of        
                     three dimensional quadric surfaces.          
      ͼ*/

                 #include <dos.h>
                 #include <stdio.h>
                 #include <math.h>

                 #include "gtools.h"
                 #include "gdraws.h"

                 float rad_per_degree=0.0174533, x_angle, y_angle,
                     z_angle, step, x3, y3, z3;
                 int x,y,horz_scale,vert_scale,color,type,x_offset,
                     y_offset,OPERATOR = 0;
		int XCENTER, YCENTER, ANGLE, LINEWIDTH;
		unsigned long PATTERN;

                 float radians_to_degrees(float degrees);
                 void projection (float x_angle, float y_angle,
                     float z_angle, float x3, float y3, float z3,
                     int color);
                 void wait(char title[]);

                 main ()
                 {
		        char adapt;

			adapt = getAdapter();

			if ((adapt != 'E') && (adapt != 'C') &&
				(adapt != 'V'))
	  	              printf("Cannot Run Demo -- No CGA,"
					" EGA or VGA Installed!");
		        else
			{
				if (adapt == 'V')
                			setMode(0x12);
		                if (adapt == 'E')
		                	setMode(16);
		                if (adapt == 'C')
		                	setMode(4);
			}
	             cls(0);
                     gotoxy(2,10);
                     printf("Enter x axis angle in degrees: ");
                     scanf("%f",&x_angle);
                     gotoxy(2,11);
                     printf("Enter y axis angle in degrees: ");
                     scanf("%f",&y_angle);
                     gotoxy(2,12);
                     printf("Enter z axis angle in degrees: ");
                     scanf("%f",&z_angle);
                     x_angle = radians_to_degrees(x_angle);
                     y_angle = radians_to_degrees(y_angle);
                     z_angle = radians_to_degrees(z_angle);
                     cls(1);
                     for (type=1; type<=6; type++)
                     {
                         switch (type)
                         {
                             case 1:
                                 x_offset = 450;
                                 y_offset = 195;
                                 horz_scale = 9;
                                 vert_scale = 2.2;
                                 for (y3=-6; y3<=6; y3+=.4)
                                 {
                                     color = 3;
                                     step = .05;
                                     for (x3=-6; x3<=6; x3+=step)
                                     {
                                         z3 = x3*x3 + y3*y3;
                                         projection(x_angle,
                                             y_angle,z_angle,
                                             x3,y3,z3,color);
                                         if (x3>=0)
                                         {
                                             step = .2;
                                             color = 12;
                                         }
                                     }
                                 }
                                 gotoxy(5,12);
				 #ifndef CGA
				 writString("Elliptic Paraboloid",11,0);
                                 #endif
				 break;
                             case 2:
                                 x_offset = 20;
                                 y_offset = 120;
                                 horz_scale = 12;
                                 vert_scale = 2;
                                 for (y3=-5; y3<=5; y3+=.4)
                                 {
                                     step = .1;
                                     color = 3;
                                     for (x3=-5; x3<=5; x3+=step)
                                     {
                                         z3 = y3*y3 - x3*x3;
                                         projection(x_angle,y_angle,
                                         z_angle,
                                         x3,y3,z3,color);
                                         if (x3>=0)
                                         {
                                             step = .4;
                                             color = 14;
                                         }
                                     }
                                 }
                                 gotoxy(30,12);
                                 #ifndef CGA
				 writString("Hyperbolic Paraboloid ",11,0);
                                 #endif
				 break;
                             case 3:
                                 x_offset = 220;
                                 y_offset = 120;
                                 horz_scale = 7;
                                 vert_scale = 3;
                                 for (y3=-6; y3<=6; y3+=.75)
                                 {
                                     step = .2;
                                     color = 2;
                                     for (x3=-6; x3<=6; x3+=step)
                                     {
                                         z3 = sqrt(y3*y3 + x3*x3)*2;
                                         projection(x_angle,y_angle,
                                             z_angle,
                                             x3,y3,z3,color);
                                         projection(x_angle,y_angle,
                                             z_angle,
                                             x3,y3,-z3,color);
                                         if (x3>=0)
                                         {
                                             step = .5;
                                             color = 12;
                                         }
                                     }
                                 }
                                 gotoxy(60,12);
				 #ifndef CGA
				 writString("Elliptic Cone ",11,0);
                                 #endif
				 break;
                             case 4:
                                 y_offset = -85;
                                 x_offset = 420;
                                 horz_scale = 7;
                                 vert_scale = 5;
                                 for (y3=-4; y3<=4; y3+=.5)
                                 {
                                     for (x3=-4; x3<=4; x3+=.2)
                                     {
                                         if (x3<0)
                                             color = 4;
                                         else
                                             color = 14;
                                         if (x3*x3+y3*y3>2)
                                         {
                                             z3 = sqrt(y3*y3 +
                                                 x3*x3-2)*2;
                                             projection(x_angle,
                                                 y_angle,z_angle,
                                                 x3,y3,z3,color);
                                             projection(x_angle,
                                                 y_angle,z_angle,
                                                 x3,y3,-z3,color);
                                         }
                                     }
                                 }
                                 #ifdef VGA
                                 gotoxy(0,28);
				 writString(" Hyperboloid of one sheet",
                                     11,0);
                                 #endif
                                 #ifdef EGA
                                 gotoxy(0,23);
				 writString(" Hyperboloid of one sheet",
                                     11,0);
                                 #endif
				 break;
                             case 5:
                                 y_offset = -95;
                                 x_offset = 0;
                                 horz_scale = 2;
                                 vert_scale = 2;
                                 for (y3=-20; y3<=20; y3+=2)
                                 {
                                     for (x3=-20; x3<=20; x3+=.3)
                                     {
                                         if (x3<0)
                                             color = 10;
                                         else
                                             color = 12;
                                         if (y3*y3>=x3*x3+1)
                                         {
                                             z3 = sqrt(y3*y3
                                                 - x3*x3 - 1);
                                             projection(x_angle,
                                                 y_angle,z_angle,
                                                 x3,y3,z3,color);
                                             projection(x_angle,
                                                 y_angle,z_angle,
                                                 x3,y3,-z3,color);
                                         }
                                     }
                                 }
                                 #ifdef VGA
                                 gotoxy(30,28);
                                 writString("Hyperboloid of two sheets ",
					11,0);
                                 #endif
                                 #ifdef EGA
                                 gotoxy(30,23);
                                 writString("Hyperboloid of two sheets ",
					11,0);
                                 #endif
                                 gotoxy(30,23);
                                 break;
                             case 6:
                                 y_offset = -95;
                                 x_offset = 210;
                                 horz_scale = 60;
                                 vert_scale = 50;
                                 for (y3=-.99; y3<=1; y3+=.15)
                                 {
                                     step = .015;
                                     color = 11;
                                     for (x3=-1; x3<=1; x3+=.03)
                                     {
                                         if (x3*x3+y3*y3<1)
                                         {
                                             z3 = sqrt(1-x3*x3 -
                                                 y3*y3);
                                             projection(x_angle,
                                                 y_angle,
                                                 z_angle,x3,y3,z3,
                                                 color);
                                             projection(x_angle,
                                                 y_angle,
                                                 z_angle,x3,y3,-z3,
                                                 color);
                                         }
                                         if (x3>0)
                                         {
                                             step = .03;
                                             color = 10;
                                         }
                                     }
                                 }
                                 #ifdef VGA
                                 gotoxy(63,28);
                                 writString("Ellipsoid",11,0);
                                 #endif
                                 #ifdef EGA
                                 gotoxy(63,23);
                                 writString("Ellipsoid",11,0);
                                 #endif
                         }
                     }
                     wait("Quadric Surfaces");
                 }

                 float radians_to_degrees(float degrees)
                 {
                     float angle;

                     while (degrees >= 360)
                         degrees -= 360;
                     while (degrees < 0)
                         degrees += 360;
                     angle = rad_per_degree*degrees;
                     return angle;
                 }

                 void projection (float x_angle, float y_angle,
                     float z_angle, float x3, float y3, float z3,
                     int color)
                 {
                     float temp_x, temp_y;
                     int x,y;

                     temp_x = x3*cos(x_angle) + y3*cos(y_angle) +
                         z3*cos(z_angle);
                     temp_y = x3*sin(x_angle) + y3*sin(y_angle) +
                         z3*sin(z_angle);
                     x = x_offset + (temp_x*horz_scale);
                     y = y_offset - (temp_y*vert_scale);
                     plots (x,y,color);
                 }

                 void wait(char title[])
                 {
                     int tab,width;
                     getMode(&width);
		     tab = (width - strlen(title))/2;
                     gotoxy(tab,0);
                     writString(title,15,0);
                     tab = (width - 28)/2;

		     #ifdef VGA
		     gotoxy(tab,29);
                     #endif

		     #ifndef VGA
		     gotoxy(tab,24);
                     #endif

		     #ifdef CGA
		     writString("Press any key to end demo...", 2,0);
                     #endif

		     #ifndef CGA
		     writString("Press any key to continue demo...", 15,0);
                     #endif

		     getch();
                     cls(1);
                 }


