/************************************************************
*                                                           *
*                  GRAPHICS DEMO PROGRAM                    *
*                                                           *
*************************************************************/

#include <stdio.h>
#include <math.h>
#include <dos.h>

/* USER WRITTEN INCLUDES */
#include "colors.h"
#include "gdraws.h"
#include "gtools.h"

/* GLOBALS */


int LINEWIDTH,OPERATOR,XCENTER,YCENTER,ANGLE;
unsigned long int PATTERN;

void image_draw(int color);
void wait(char title[]);

int adapt,mode;
int j, k, xscale,yscale,xoffset,yoffset,pr,p[4],pk[4];
long unsigned int i;
float a[4],b[4],c[4],d[4],e[4],f[4],x,y,newx;

main()
{
        adapt = getAdapter();
        if ((adapt != 'E') && (adapt != 'C') && (adapt != 'V'))
                printf("Cannot Run Demo -- No CGA, EGA or VGA Installed!");
        else
	{
		if (adapt == 'V')
                	setMode(0x12);
                if (adapt == 'E')
                	setMode(16);
                if (adapt == 'C')
                	setMode(4);
		a[0] =0; a[1] = .20; a[2] = -.15; a[3] = .85;
        	b[0] = 0; b[1] = -.26; b[2] = .28; b[3] = .04;
	        c[0] = 0; c[1] = .23; c[2] = .26; c[3] = -.04;
        	d[0] = .16; d[1] = .22; d[2] = .24; d[3] = .85;
	        e[0] = 0; e[1] = 0; e[2] = 0; e[3] = 0;
        	f[0] = 0; f[1] = 1.60; f[2] = .44; f[3] = 1.6;
	        p[0] = 328; p[1] = 2621; p[2] = 4915; p[3] = 32767;
		xscale = 25;
		yscale = 25;
		xoffset = 0;
		yoffset = -160;
		cls (1);
		image_draw(10);
		wait("Fern");

		a[0] = 0; a[1] = .1; a[2] = .42; a[3] = .42;
	        b[0] = 0; b[1] = 0; b[2] = -.42; b[3] = .42;
        	c[0] = 0; c[1] = 0; c[2] = .42; c[3] = -.42;
	        d[0] = .5; d[1] = .1; d[2] = .42; d[3] = .42;
        	e[0] = 0; e[1] = 0; e[2] = 0; e[3] = 0;
	        f[0] = 0; f[1] = .2; f[2] = .2; f[3] = .2;
        	p[0] = 1638; p[1] = 6553; p[2] = 19660; p[3] = 32767;
		xscale = 750;
		yscale = 750;
		xoffset = 0;
		yoffset = -160;
		cls(1);
		#ifdef CGA
		image_draw(2);
		#endif
		#ifndef CGA
		image_draw(13);
		#endif
		wait("Tree");

		a[0] = .5; a[1] = .5; a[2] = .5; a[3] = 0;
	        b[0] = 0; b[1] = 0; b[2] = 0; b[3] = 0;
        	c[0] = 0; c[1] = 0; c[2] = 0; c[3] = 0;
	        d[0] = .5; d[1] = .5; d[2] = .5; d[3] = 0;
        	e[0] = 0; e[1] = 1.; e[2] = .5; e[3] = 0;
	        f[0] = 0; f[1] = 0; f[2] = .5; f[3] = 0;
        	p[0] = 10813; p[1] = 21626; p[2] = 32767; p[3] = 32767;
		xscale = 200;
		yscale = 200;
		xoffset = -180;
		yoffset = -160;
		cls(7);
		image_draw(5);
		wait("Sierpinski Triangle");

		cls(7);
		a[0] = .333; a[1] = .333; a[2] = .667; a[3] = 0;
        	b[0] = 0; b[1] = 0; b[2] = 0; b[3] = 0;
	        c[0] = 0; c[1] = 0; c[2] = 0; c[3] = 0;
        	d[0] = .333; d[1] = .333; d[2] = .667; d[3] = 0;
	        e[0] = 0; e[1] = 1.; e[2] = .5; e[3] = 0;
        	f[0] = 0; f[1] = 0; f[2] = .5; f[3] = 0;
	        p[0] = 10813; p[1] = 21626; p[2] = 32767; p[3] = 32767;
		xscale = 120;
		yscale = 140;
		xoffset = -100;
		yoffset = -160;
		#ifdef CGA
		image_draw(1);
		#endif
		#ifndef CGA
		image_draw(4);
		#endif
		wait("Cantor Tree");

		cls(7);
		a[0] = .5; a[1] = .5; a[2] = .5; a[3] = .5;
        	b[0] = 0; b[1] = 0; b[2] = 0; b[3] = 0;
	        c[0] = 0; c[1] = 0; c[2] = 0; c[3] = 0;
        	d[0] = .5; d[1] = .5; d[2] = .5; d[3] = .5;
	        e[0] = 0; e[1] = .5; e[2] = 0; e[3] = .5;
        	f[0] = 0; f[1] = 0; f[2] = .5; f[3] = .5;
	        p[0] = 8182; p[1] = 16383; p[2] = 24575; pk[3] = 32767;
		xscale = 250;
		yscale = 250;
		xoffset = -100;
		yoffset = -160;
		image_draw(1);
		wait("Square");
	}
}

void image_draw(int color)
{

	int px,py;

	x = 0;
	y = 0;
	#ifdef CGA
	for (i=1; i<=2500; i++)
	#endif
	#ifndef CGA
	for (i=1; i<=10000; i++)
	#endif
	{
		j = rand();
		k = (j < p[0]) ? 0 : ((j < p[1]) ? 1 : ((j < p[2]) ? 2 : 3));
		newx = (a[k]* x + b[k] * y + e[k]);
		y = (c[k] * x + d[k] * y + f[k]);
		x = newx;
                px = x*xscale + xoffset;
                py = (y*yscale + yoffset);
		if ((px>=-320) && (px<320)	&& (py>=-240) && (py<240))
			plots (px,py,color);
	}
}

void wait(char title[])
{
	int tab,width;
	getMode(&width);
	tab = (width - strlen(title))/2;
	gotoxy(tab,0);
	writString(title,WHITE,0);
	tab = (width - 23)/2;

	#ifdef VGA
	gotoxy(tab,29);
	#endif

	#ifndef VGA
	gotoxy(tab,24);
	#endif

	writString("Press any key to continue demo...", WHITE,0);
	getch();
	cls(0);
}


