/*****************************************************************************
*   Main module of "Irit" - the 3d polygonal solid modeller.		     *
******************************************************************************
* Usage:								     *
*   Irit [-t] [-z]							     *
*									     *
* Written by:  Gershon Elber				Ver 3.0, Apr. 1990   *
*****************************************************************************/

#ifdef __MSDOS__
#include <stdlib.h>
#include <conio.h>
#include <dir.h>
#include <dos.h>
#endif /* __MSDOS__ */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include "program.h"
#include "config.h"
#include "ctrl-brk.h"
#include "dataprsr.h"
#include "dosintr.h"
#include "graphgen.h"
#include "inptprsg.h"
#include "matherr.h"
#include "objects.h"
#include "windows.h"

#ifdef NO_CONCAT_STR
static char *VersionStr = "Irit		Vertion 3.0, Gershon Elber,\n\
	(C) Copyright 1989/90/91/92 Gershon Elber, Non commercial use only.";
#else
static char *VersionStr = "Irit	        " VERSION
	",	Gershon Elber,	" __DATE__ ",   " __TIME__ "\n"
	"(C) Copyright 1989/90/91/92 Gershon Elber, Non commercial use only.";
#endif /* NO_CONCAT_STR */

static char *CtrlStr = "Irit [-t] [-z] [file.irt]";

char *GlblHelpFileName = "irit.hlp";

static char
     *GlblPrgmHeader = "                    Irit - the polygonal solid modeller";
static char
     *GlblCopyRight  =
#ifdef __MSDOS__
     "(C) Copyright 1989/90/91/92 Gershon Elber,  IBMPC " VERSION ",   "
		__DATE__;
#else
#ifdef DJGCC
     "(C) Copyright 1989/90/91/92 Gershon Elber,  DJGCC " VERSION ",   "
		__DATE__;
#else
     "(C) Copyright 1989/90/91/92 Gershon Elber,  Unix  Version 3.0";
#endif /* DJGCC */
#endif /* __MSDOS__ */
static char
     *GlblAuthorName = "                         Written by Gershon Elber";

ObjectStruct *GlblObjList = NULL;	   /* All objects defined on system. */

char GlblCrntWorkingDir[LINE_LEN];     /* Save start CWD to recover on exit. */

FILE *GlblLogFile = NULL;

jmp_buf GlblLongJumpBuffer;		          /* Used in error recovery. */

/* The following are setable variables (via configuration file poly3d-h.cfg).*/
#ifdef __MSDOS__
static char
    *SVGANameMode = "",
    *BGIDriverPath = "";
static int
    GraphDriver = DETECT;
#else

static int
    PopTransAlways = FALSE;
#endif /* __MSDOS__ */

int
#if defined(__MSDOS__) || defined(DJGCC)     /* Defaults for MSDOS intr_lib. */
    GlblWindowFrameWidth = 8,
    GlblViewFrameColor   = INTR_COLOR_RED,
    GlblViewBackColor    = INTR_COLOR_BLACK,
    GlblTransFrameColor  = INTR_COLOR_GREEN,
    GlblTransBackColor   = INTR_COLOR_BLACK,
    GlblStatusFrameColor = INTR_COLOR_MAGENTA,
    GlblStatusBackColor  = INTR_COLOR_BLACK,
    GlblInputFrameColor  = INTR_COLOR_YELLOW,
    GlblInputBackColor   = INTR_COLOR_BLACK,
    GlblDrawHeader       = FALSE,
    GlblSmoothTextScroll = TRUE,
    GlblIntrSaveMethod   = INTR_SAVE_DISK,
    GlblMouseSensitivity = 10,       /* Sensitivity control of mouse device. */
    GlblJoystickExists   = FALSE,
#endif /*__MSDOS__ || DJGCC */
    GlblMouseExists      = TRUE,
    GlblLoadColor        = DEFAULT_LOAD_COLOR,
    GlblBoolColor        = DEFAULT_BOOL_COLOR,
    GlblICrvColor        = DEFAULT_ICRV_COLOR,
    GlblPrimColor        = DEFAULT_PRIM_COLOR,
    GlblDoGraphics       = TRUE,/* Control if running in graphics/text mode. */
    GlblFatalError       = FALSE, /* True if disaster in system - must quit! */
    GlblTransformMode    = TRANS_SCREEN,       /* Screen/Object trans. mode. */
    GlblViewMode         = VIEW_ORTHOGRAPHIC,		 /* Persp/Ortho etc. */
    GlblDepthCue         = TRUE,		   /* Activate depth cueing. */
    GlblDrawSolid        = FALSE,	 /* Use hardware Z buffer rendering. */
    GlblPrintLogFile     = FALSE;    /* If TRUE everything goes to log file. */

char
#if defined(__MSDOS__) || defined(DJGCC)     /* Defaults for MSDOS intr_lib. */
    *GlblViewWndwPos   = "0.02, 0.02, 0.72, 0.66",
    *GlblTransWndwPos  = "0.75, 0.02, 0.98, 0.66",
    *GlblStatusWndwPos = "0.75, 0.02, 0.98, 0.66",
    *GlblInputWndwPos  = "0.04, 0.7,  0.98, 0.98",
    *GlblIntrSaveDisk  = "c:\\",
#endif /*__MSDOS__ || DJGCC */
#ifdef __GL__
    /* Preferance position and size of view and transformation windows. */
    *GlblTransPrefPos = "455, 640, 520, 965",
    *GlblViewPrefPos  = "1,   450, 520, 965",
#endif /* __GL__ */
    *GlblStartFileName = "",
    *GlblLogFileName = "",
    *GlblEditPrgm = "";

static ConfigStruct SetUp[] =
{
#if defined(__MSDOS__) || defined(DJGCC)
  { "Joystick",		(VoidPtr) &GlblJoystickExists,	SU_BOOLEAN_TYPE },
  { "Mouse",		(VoidPtr) &GlblMouseExists,	SU_BOOLEAN_TYPE },
  { "MouseSensitivity",	(VoidPtr) &GlblMouseSensitivity,SU_INTEGER_TYPE },
  { "WndwWidth",	(VoidPtr) &GlblWindowFrameWidth,SU_INTEGER_TYPE },
  { "WndwHeader",	(VoidPtr) &GlblDrawHeader,	SU_BOOLEAN_TYPE },
  { "WndwSmthTxtScrl",	(VoidPtr) &GlblSmoothTextScroll,SU_BOOLEAN_TYPE },
  { "WndwViewClr",	(VoidPtr) &GlblViewFrameColor,	SU_INTEGER_TYPE },
  { "WndwTransClr",	(VoidPtr) &GlblTransFrameColor,	SU_INTEGER_TYPE },
  { "WndwInputClr",	(VoidPtr) &GlblInputFrameColor,	SU_INTEGER_TYPE },
  { "WndwViewPos",	(VoidPtr) &GlblViewWndwPos,	SU_STRING_TYPE },
  { "WndwTransPos",	(VoidPtr) &GlblStatusWndwPos,	SU_STRING_TYPE },
  { "WndwInputPos",	(VoidPtr) &GlblInputWndwPos,	SU_STRING_TYPE },
  { "WndwBackSave",	(VoidPtr) &GlblIntrSaveMethod,	SU_INTEGER_TYPE },
  { "WndwBackSavePath",	(VoidPtr) &GlblIntrSaveDisk,	SU_STRING_TYPE },
#else
  { "PopTransAlways",   (VoidPtr) &PopTransAlways,	SU_BOOLEAN_TYPE },
#endif /* __MSDOS__ || DJGCC */
#ifdef __MSDOS__
  { "SVGANameMode",	(VoidPtr) &SVGANameMode,	SU_STRING_TYPE },
  { "BGIDriverPath",	(VoidPtr) &BGIDriverPath,	SU_STRING_TYPE },
  { "GraphDriver",	(VoidPtr) &GraphDriver,		SU_INTEGER_TYPE },
  { "WndwStatusClr",	(VoidPtr) &GlblStatusFrameColor,SU_INTEGER_TYPE },
  { "WndwStatusPos",	(VoidPtr) &GlblStatusWndwPos,	SU_STRING_TYPE },
#endif /* __MSDOS__ */
#ifdef __GL__
  { "TransPrefPos",	(VoidPtr) &GlblTransPrefPos,	SU_STRING_TYPE },
  { "ViewPrefPos",	(VoidPtr) &GlblViewPrefPos,	SU_STRING_TYPE },
#endif /* __GL__ */
  { "DoGraphics",	(VoidPtr) &GlblDoGraphics,	SU_BOOLEAN_TYPE },
  { "LoadColor",	(VoidPtr) &GlblLoadColor,	SU_INTEGER_TYPE },
  { "BoolColor",	(VoidPtr) &GlblBoolColor,	SU_INTEGER_TYPE },
  { "ICrvColor",	(VoidPtr) &GlblICrvColor,	SU_INTEGER_TYPE },
  { "PrimColor",	(VoidPtr) &GlblPrimColor,	SU_INTEGER_TYPE },
  { "StartFile",	(VoidPtr) &GlblStartFileName,	SU_STRING_TYPE },
  { "LogFile",		(VoidPtr) &GlblLogFileName,	SU_STRING_TYPE },
  { "EditPrgm",		(VoidPtr) &GlblEditPrgm,	SU_STRING_TYPE },
};
#define NUM_SET_UP	(sizeof(SetUp) / sizeof(ConfigStruct))

#ifdef __MSDOS__
extern unsigned int _stklen = 16384;	     /* Increase default stack size. */
#endif /* __MSDOS__ */

static void Interact(void);
static void PrintInptPrsrError(void);

/*****************************************************************************
* Main routine - Read Parameter	line and do what you need...		     *
*****************************************************************************/
void
#ifdef __MSDOS__
cdecl        /* So we can use -rp in Borland 3.0 (parameters in registers.). */
#endif /* __MSDOS__ */
main(int argc, char **argv)
{
    char *FullPathStartFileName;

    Config("irit", SetUp, NUM_SET_UP);       /* Read config. file if exists. */

    while (argc >= 2) {
    	if (strncmp(argv[1], "-z", 2) == 0) {
	    fprintf(stderr, "\n%s\n\nUsage: %s\n", VersionStr, CtrlStr);
	    ConfigPrint(SetUp, NUM_SET_UP);
	    exit(0);
    	}
	else if (strncmp(argv[1], "-t", 2) == 0) {
	    GlblDoGraphics = FALSE;
	}
	else {
	    break;
	}
    	argv++;
	argc--;
    }

    getcwd(GlblCrntWorkingDir, LINE_LEN - 1);

    SetUpCtrlBrk();	     /* Set up control break trap routine (int 1bh). */
    SetUpHardErr();	    /* Set up hardware error trap routine (int 24h). */
    signal(SIGFPE, DefaultFPEHandler);	 /* Will trap floating point errors. */

    if (GlblDoGraphics) {
#	ifdef __MSDOS__
	    GGSetStatusInputWindows(TRUE, TRUE);
	    GGInstallBGI(BGIDriverPath, SVGANameMode);
	    GGInitGraph(GraphDriver, FALSE);
#	else
#	ifdef DJGCC
	    GGSetStatusInputWindows(FALSE, TRUE);
	    GGInitGraph(0, FALSE);
#	else
	    GGInitGraph(argc, argv, FALSE, PopTransAlways);
#       endif /* DJGCC */
#	endif /* __MSDOS__ */
    }

    /* Print some copyright messages: */
    WndwInputWindowPutStr(GlblPrgmHeader);
    WndwInputWindowPutStr(GlblCopyRight);
    WndwInputWindowPutStr(GlblAuthorName);

#ifdef __MSDOS__
    DosGetTime(1.0);				    /* Reset the time count. */
#endif /* __MSDOS__ */
    SetUpPredefObjects();		  /* Prepare the predefined objects. */

    AliasReset();

    /* Execute the file specified in the command line if was one: */
    if (argc == 2) FileInclude(argv[1]);

    /* Execute the start up file first by inserting it to the include stack. */
    if ((int) strlen(GlblStartFileName) > 0 &&
	(FullPathStartFileName = searchpath(GlblStartFileName)) != NULL)
	FileInclude(FullPathStartFileName);

    Interact();				      /* Go and do some real work... */

    MyExit(0);
}

/*****************************************************************************
* Interact - the main read/eval/print routine. This routine reads data from  *
* standart input and execute it for ever (using Input Parser).		     *
* Note exit from this program is controled by input parser itself.	     *
*****************************************************************************/
static void Interact(void)
{
    /* setjmp return 0 on first install time. Will return 1 if error is      */
    /* recoverable, 2 if cannt continue - must quit the program now.	     */
    switch (setjmp(GlblLongJumpBuffer)) {         /* Used in error recovery. */
	case 0:
	case 1:
	    while (TRUE) {
		if (!InputParser())		 /* Print the error message. */
		    PrintInptPrsrError();
	    }
	case 2:
	    WndwInputWindowPutStr("Press return to die...");
#ifdef __MSDOS__
	    while (kbhit()) getch();		/* Flush any old keystrokes. */
	    getch();
#else
	    getchar();
#endif /* __MSDOS__ */
	    break;
    }
}

/*****************************************************************************
* Routine to query (and print) the errors found in InputParser:		     *
*****************************************************************************/
static void PrintInptPrsrError(void)
{
    InptPrsrEvalErrType ErrorNum;
    char *ErrorMsg, *p;
    char Line[LINE_LEN_LONG];

    if ((ErrorNum = InptPrsrParseError(&ErrorMsg)) != IPE_NO_ERR) {/*Prsr err*/
	sprintf(Line, "Parsing Error: ");
	p = &Line[strlen(Line)];
	switch (ErrorNum) {
	    case IP_ERR_WRONG_SYNTAX:
		sprintf(p, "Wrong syntax\n");
		break;
	    case IP_ERR_PARAM_EXPECT:
		sprintf(p, "Parameter Expected\n");
		break;
	    case IP_ERR_ONE_OPERAND:
	    case IP_ERR_TWO_OPERAND:
		sprintf(p, "Wrong # of operands - %s\n", ErrorMsg);
		break;
	    case IP_ERR_STACK_OV:
		sprintf(p, "Internal Stack OverFlow at - %s\n", ErrorMsg);
		break;
	    case IP_ERR_PARAM_MATCH:
		sprintf(p, "Parenthesis mismatch - %s\n", ErrorMsg);
		break;
	    case IP_ERR_UNDEF_TOKEN:
		sprintf(p, "Undefined token - %s\n", ErrorMsg);
		break;
	    case IP_ERR_UNDEF_FUNC:
		sprintf(p, "Undefined function - %s\n", ErrorMsg);
		break;
	    case IP_ERR_NAME_TOO_LONG:
		sprintf(p, "Object name too long - %s\n", ErrorMsg);
		break;
	    case IP_ERR_PARAM_FUNC:
		sprintf(p, "Parameters expected in func %s\n", ErrorMsg);
		break;
	    case IP_ERR_NO_PARAM_FUNC:
		sprintf(p, "No Parameters expected in func %s\n", ErrorMsg);
		break;
	    default:
		sprintf(p, "Undefined error %d", ErrorNum);
		break;
	}
	WndwInputWindowPutStr(Line);
	return;
    }

    if ((ErrorNum = InptPrsrEvalError(&ErrorMsg)) != IPE_NO_ERR) {/*Eval err.*/
	sprintf(Line, "Eval Error: ");
	p = &Line[strlen(Line)];
	switch (ErrorNum) {
	    case IE_ERR_FATAL_ERROR:
		sprintf(p, "Fatal error - %s\n", ErrorMsg);
		break;
	    case IE_ERR_DIV_BY_ZERO:
		sprintf(p, "Division by zero - %s\n", ErrorMsg);
		break;
	    case IE_ERR_NO_OBJ_METHOD:
		sprintf(p, "No such method for object - %s\n", ErrorMsg);
		break;
	    case IE_ERR_TYPE_MISMATCH:
		sprintf(p, "Parameter type mismatch - %s\n", ErrorMsg);
		break;
	    case IE_ERR_ASSIGN_LEFT_OP:
		sprintf(p, "Lval is not a parameter - %s\n", ErrorMsg);
		break;
	    case IE_ERR_MIXED_OBJ:
		sprintf(p, "Mixed types in expression - %s\n", ErrorMsg);
		break;
	    case IE_ERR_UNDEF_OBJECT:
		sprintf(p, "No such object defined - %s\n", ErrorMsg);
		break;
	    case IE_ERR_NO_ASSIGNMENT:
		sprintf(p, "Assignment was expected\n");
		break;
	    case IE_ERR_FP_ERROR:
		sprintf(p, "Floating Point Error - %s\n", ErrorMsg);
		break;
	    case IE_ERR_NUM_PRM_MISMATCH:
		sprintf(p, "Number of func. param. mismatch - %s\n", ErrorMsg);
		break;
	    case IE_ERR_MAT_POWER:
		sprintf(p, "Wrong range or not exists, operator - %s\n", ErrorMsg);
		break;
	    case IE_ERR_FREE_SIMPLE:
		sprintf(p, "Free only geometric objects - %s\n", ErrorMsg);
		break;
	    case IE_ERR_MODIF_ITER_VAR:
		sprintf(p, "Iteration var. type modified or freed - %s\n", ErrorMsg);
		break;
	    case IE_ERR_BOOLEAN_ERR:
		sprintf(p, "Geometric Boolean operation error - %s\n", ErrorMsg);
		break;
	    case IE_ERR_LIST_TOO_LONG:
		sprintf(p, "List length too big - up to %d only.\n", MAX_OBJ_LIST);
		break;
	    case IE_ERR_DATA_PRSR_ERROR:
		sprintf(p, "%s", ErrorMsg);
		break;
	    default:
		sprintf(p, "Undefined error %d\n", ErrorNum);
		break;
	}
	WndwInputWindowPutStr(Line);
	return;
    }
}

/*****************************************************************************
* Exit routine - called when this program should terminate.		     *
*****************************************************************************/
void MyExit(int ExitCode)
{
    if (GlblDoGraphics) {
    	GGCloseGraph();				/* Close the graphic driver. */
    }

    RestoreCtrlBrk();			      /* Restore ctrl-brk interrupt. */

    chdir(GlblCrntWorkingDir);	  /* Recover original directory before exit. */
#ifdef __MSDOS__
    setdisk(GlblCrntWorkingDir[0] - 'A');	    /* Move to the old disk. */
#endif /* __MSDOS__ */

    if (GlblPrintLogFile) fclose(GlblLogFile);/* Close log file if was open. */

    exit(ExitCode);
}

/*****************************************************************************
* Trap Cagd_lib errors right here.					     *
*****************************************************************************/
void CagdFatalError(CagdFatalErrorType ErrID)
{
    char Line[LINE_LEN],
	*ErrorMsg = CagdDescribeError(ErrID);

    sprintf(Line, "CAGD_LIB: %s", ErrorMsg);
    WndwInputWindowPutStr(Line);

    longjmp(GlblLongJumpBuffer, 1);		/* Go back to menu directly. */
}

/*****************************************************************************
* FatalEror routine. print a fatal error message and go back to cursor mode  *
*****************************************************************************/
void FatalError(char *ErrorMsg)
{
    if (ErrorMsg != NULL) {
	WndwInputWindowPutStr("Fatal error occured, please report it:");
	WndwInputWindowPutStr(ErrorMsg);
    }

    longjmp(GlblLongJumpBuffer, 1);		/* Go back to menu directly. */
}

/*****************************************************************************
*   Routine that is called from the floating point package in case of fatal  *
* floating point error. Print error message, long jump to main loop. Default *
* FPE handler - must be reset after redirected to other module.		     *
*****************************************************************************/
#ifdef __MSDOS__
void cdecl DefaultFPEHandler(int Sig, int Type, int *RegList)
#else
void DefaultFPEHandler(int Type)
#endif /* __MSDOS__ */
{
    PrintFPError(Type);		     /* Print the floating point error type. */

    longjmp(GlblLongJumpBuffer, 1);
}
