@echo off
rem
rem Tests for the gif_lib utilities.
rem Usage:
rem	testgif [gif_dir] [display_prgm]
rem
rem   This test assumes the gif_lib utilities are available from one of the
rem path directorys, and that DIR is set (directly or through command line)
rem to the directory holf these gif files:
rem 1. SOLID2.GIF
rem 2. CHERYL.GIF
rem 3. PORSCHE.GIF
rem   In addition, set DISPLAY ( directly or through command line) to the
rem program to display gif files in our system.
rem   As this batch file intensively uses pipes which on msdos are saved as
rem files on CURRENT disk, it is going to be a good idea to execute this batch
rem from a ram disk.

set GIF_DIR=d:\gif\pic
if not x%1 == x set GIF_DIR = %1

set GIF_DISPLAY=gif2herc
if not x%2 == x set GIF_DISPLAY = %2

@echo on

gifbg -d tl -s 320 200 -c 255 255 255 -l 64 > bg1.gif
gifcomb %GIF_DIR%porsche.gif bg1.gif | %GIF_DISPLAY%

gifhisto -t %GIF_DIR%cheryl.gif | sort/r | more
gifhisto -b -s 200 512 %GIF_DIR%cheryl.gif | gifflip -l | %GIF_DISPLAY%

gifflip -r %GIF_DIR%solid2.gif | gifrsize | %GIF_DISPLAY%

gifinter %GIF_DIR%cheryl.gif | gifflip -x | %GIF_DISPLAY%

gifbg -d "TL" -s 320 175 -c 255 255 255 -l 64 | gifpos -s 640 350 -i   0   0 > b1.gif
gifbg -d "BL" -s 320 175 -c 255 255 255 -l 64 | gifpos -s 640 350 -i   0 175 > b2.gif
gifbg -d "TR" -s 320 175 -c 255 255 255 -l 64 | gifpos -s 640 350 -i 320   0 > b3.gif
gifbg -d "BR" -s 320 175 -c 255 255 255 -l 64 | gifpos -s 640 350 -i 320 175 > b4.gif
gifasm b1.gif b2.gif b3.gif b4.gif > backgrnd.gif
%GIF_DISPLAY% -m 2 backgrnd.gif

copy %GIF_DIR%solid2.gif s1.gif
gifrsize s1.gif > s2.gif
gifrsize s2.gif > s3.gif
gifrsize s3.gif > s4.gif
gifpos -i 360 0 s2.gif | gifinto s2.gif
gifpos -i 540 0 s3.gif | gifinto s3.gif
gifpos -i 630 0 s4.gif | gifinto s4.gif
gifasm s1.gif s2.gif s3.gif s4.gif > sall.gif
giftext sall.gif
%GIF_DISPLAY% sall.gif
del s?.gif

gifpos -s 720 348 -i 400 148 %GIF_DIR%porsche.gif | %GIF_DISPLAY%

gifrsize -s 3 %GIF_DIR%solid2.gif  | gifrsize -u | %GIF_DISPLAY%

gifinter %GIF_DIR%cheryl.gif | gifrsize | %GIF_DISPLAY% -z 2

gifclip -i 1 1 492 345 %GIF_DIR%solid2.gif | gifpos -s 492 345 | %GIF_DISPLAY%

@echo off

rem Remove these variables from current shell
Exit:

set GIF_DIR=
set GIF_DISPLAY=

