/*  exam1.c - Digital Sound Interface Kit V1.01a example code

    Copyright 1993,94 Carlos Hasan
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "sound.h"
#include "ts.h"

int main(void)
{
    DSMCard Card;
    DSM *Module;
    int Volume;

    if (DSMLoadSetup(&Card)) {
        printf("Please run SETUP.EXE to configure.\n");
        return 1;
    }
    if (DSMInit(&Card)) {
        printf("Error Initializing the Sound System.\n");
        return 1;
    }
    if ((Module = DSMLoad("64MANIA.DSM",0L)) == NULL) {
        switch (DSMStatus) {
        case ERR_NORAM:  printf("Not enough system memory.\n"); break;
        case ERR_NODRAM: printf("Not enough card memory.\n"); break;
        case ERR_NOFILE: printf("File not found.\n"); break;
        case ERR_FORMAT: printf("Invalid file format.\n"); break;
        case ERR_ACCESS: printf("File damaged.\n"); break;
        }
        DSMDone();
        return 1;
    }
    printf("Playing music.\n");
    DSMSetupVoices(Module->Song.NumChannels,Module->Song.MasterVolume);
    DSMPlayMusic(Module);

#ifdef __TS_H
    TSInit();
    TSSetRate(70);
    TSSetRoutine(DSMPoll);
#endif

    for (Volume = 0; Volume < 256; Volume++) {
#ifndef __TS_H
        DSMPoll();
#endif
        DSMSetMusicVolume(Volume);
        delay(20);
    }

    while (!kbhit()) {
#ifndef __TS_H
        DSMPoll();
#endif
    }

    for (Volume = 255; Volume > 0; Volume--) {
#ifndef __TS_H
        DSMPoll();
#endif
        DSMSetMusicVolume(Volume);
        delay(20);
    }

    DSMStopMusic();
    DSMFree(Module);
#ifdef __TS_H
    TSDone();
    TSRestoreTime();
#endif
    DSMDone();
    return 0;
}
