/*
  ͻ
                                                                          
                                Robot Walk                                
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define Pi_Over_180 0.01745

float SinD(float a)
{
  return (sin(a * Pi_Over_180));
}

float CosD(float a)
{
  return (cos(a * Pi_Over_180));
}

typedef char name[33];

FILE *textdiskfile;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                              Robot Walk                                \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

float ypos;

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    2\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.100\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000 %3.3f 220.000\n",ypos);
  fprintf(textdiskfile,"   ROTATE  =    0.000\n");
  fprintf(textdiskfile,"   TILT    =   16.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SKY\n");
  fprintf(textdiskfile,"   HORCOL  =    0.500    0.600    0.700\n");
  fprintf(textdiskfile,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(textdiskfile,"   CLOUDS  = FALSE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PLASTICTILE\n");
  fprintf(textdiskfile,"   TEXTURE = CHECKER\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    8.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(textdiskfile,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TILE    =    0.012\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = STEEL\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.600    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   GLOSS   =    1.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = PLASTICTILE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  150.000 %3.3f 350.000\n",ypos);
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
}

float hgt;

void sph(float x, float y, float z, float rad)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y + ypos + 660.0,z + hgt);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = STEEL\n");
}

void cyl(float x1, float y1, float z1, float x2, float y2, float z2, float rad)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = %3.3f %3.3f %3.3f\n",x1,y1 + ypos + 660.0,z1 + hgt);
  fprintf(textdiskfile,"   BASERAD = %3.3f\n",rad);
  fprintf(textdiskfile,"   APEXLOC = %3.3f %3.3f %3.3f\n",x2,y2 + ypos + 660.0,z2 + hgt);
  fprintf(textdiskfile,"   MATL    = STEEL\n");
}

void make()
{
  Byte t;
  float a, b;
  float c, d;
  float phase;

  ypos = -660.0;
  phase = 0.0;
  for (t = 1; t <= numberofframes; t++)
  {
    writestudio();
    hgt = -3 * CosD(phase * 2.0);

	  /*  Body  */

    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"BOX\n");
    fprintf(textdiskfile,"   LOC     =  -50.000 %f %f\n",-200.000 + ypos + 660.0,50.0 + hgt);
    fprintf(textdiskfile,"   V1      =  100.000    0.000    0.000\n");
    fprintf(textdiskfile,"   V2      =    0.000   60.000    0.000\n");
    fprintf(textdiskfile,"   V3      =    0.000    0.000   70.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");

	      /*  Head  */

    cyl(0.0,-170.0,125.0,0.0,-170.0,155.0,20.0);
    sph(0.0,-170.0,155.0,20.0);

	  /*  Eyes  */

    a = 22.4 * CosD(270.0 + 12.0 * SinD(phase + 45.0) - 26.56);
    b = -170.0 + 22.4 * SinD(270.0 + 12.0 * SinD(phase + 45.0) - 26.56);
    c = 22.4 * CosD(270.0 + 12.0 * SinD(phase + 45.0) + 26.56);
    d = -170.0 + 22.4 * SinD(270.0 + 12.0 * SinD(phase + 45.0) + 26.56);
    sph(a,b,150.0,5.0);
    sph(c,d,150.0,5.0);

	  /*  Lips  */

    sph(a,b,135.0,5.0);
    cyl(a,b,135.0,c,d,135.0,5.0);
    sph(c,d,135.0,5.0);

	  /*  Neck  */

    sph(0.0,-170.0,125.0,10.0);

	  /*  Shoulders  */

    sph(-70.0,-170.0,105.0,12.0);
    cyl(-70.0,-170.0,105.0,70.0,-170.0,105.0,12.0);
    sph(70.0,-170.0,105.0,12.0);

	  /*  Left Arm  */

    a = -170.0 + 15 * CosD(phase);
    b = 50.0;
    cyl(70.0,-170.0,105.0,70.0,a,b,12.0);
    sph(70.0,a,b,12.0);

	  /*  Right Arm  */

    a = -170.0 + 15 * CosD(phase + 180.0);
    b = 50.0;
    cyl(-70.0,-170.0,105.0,-70.0,a,b,12.0);
    sph(-70.0,a,b,12.0);

	  /*  Left Leg  */

    a = -170.0 + 15 * CosD(phase + 180.0);
    b = 15.0;
    cyl(25.0,-170.0,55.0,25.0,a,b,20.0);
    sph(25.0,a,b,20.0);

	  /*  Right Leg  */

    a = -170.0 + 15 * CosD(phase);
    b = 15.0;
    cyl(-25.0,-170.0,55.0,-25.0,a,b,20.0);
    sph(-25.0,a,b,20.0);
    ypos = ypos + (2.0 / 0.012) / numberofframes;
			    /*  0.012 = 1/2 tile size  */

    phase = phase + (360.0 / numberofframes);
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"ENDFRAME\n");
  }
}

void main()
{
  strcpy(filename,"ROBOT.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}