/*
  ͻ
                                                                          
                       Pool Table with Cue and Balls                      
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define Pi_Over_180 0.01745

float SinD(float a)
{
  return (sin(a * Pi_Over_180));
}

float CosD(float a)
{
  return (cos(a * Pi_Over_180));
}

typedef char name[13];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                     Pool Table with Cue and Balls                      \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.800    0.800    0.800\n");
  fprintf(textdiskfile,"   REFLWGT =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    3\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.500\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000  -700.000  125.000\n");
  fprintf(textdiskfile,"   ROTATE  =    0.000\n");
  fprintf(textdiskfile,"   TILT    =   15.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CARPET\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.450    0.800    0.490\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CUE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.300    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CUETIP\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.500    0.500\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =    2.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = WHITE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.550    0.550    0.550\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.150    0.150    0.150\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BLACK\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = RED\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.300    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.000    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.150    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = YELLOW\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.600    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BLUE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.000    0.000    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = GREEN\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.200    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.000    0.600    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.200    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PURPLE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.300    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.100    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = MAROON\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.100    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.250    0.350\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.150    0.100    0.150\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = ORANGE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.500    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =   15.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = REDSTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.000    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = YELLOWSTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.600    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BLUESTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.000    0.000    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = GREENSTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.200    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.000    0.600    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.200    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PURPLESTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.300    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.100    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = MAROONSTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.100    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.250    0.350\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.150    0.100    0.150\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = ORANGESTRIPE\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.500    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = CARPET\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =    0.000  350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  120.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.650    0.650    0.650\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =    0.000 -500.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  120.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.650    0.650    0.650\n");
}

void sph(float x, float y, float z, float rad, char * color)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = %s\n",color);
}

void make()
{
  Byte frame;
  float phase;
  float x1, y1, z1;
  float x2, y2, z2;
  float x3, y3, z3;
  float x4, y4, z4;
  float x5, y5, z5;
  float x6, y6, z6;
  float x7, y7, z7;
  float x8, y8, z8;
  float x9, y9, z9;
  float x10, y10, z10;
  float x11, y11, z11;
  float x12, y12, z12;
  float x13, y13, z13;
  float x14, y14, z14;
  float x15, y15, z15;
  float rad, hgt;
  float dx, dy;
  float scale;

  phase = -90.0;
  rad = 16.0;
  scale = rad * 5;
  writestudio();

      /*  Caclulate the Positions of the Pool Balls  */

  hgt = rad;
  dx = CosD(phase);
  dy = SinD(phase);
  x1 = scale * dx;
  y1 = scale * dy;
  z1 = hgt;
  dx = CosD(phase + 120.0);
  dy = SinD(phase + 120.0);
  x15 = scale * dx;
  y15 = scale * dy;
  z15 = hgt;
  dx = CosD(phase + 240.0);
  dy = SinD(phase + 240.0);
  x11 = scale * dx;
  y11 = scale * dy;
  z11 = hgt;
  x6 = (x1 + x15) / 2.0;   /*  p6 = (p1 + p15) / 2  */
  y6 = (y1 + y15) / 2.0;
  z6 = hgt;
  x13 = (x11 + x15) / 2.0;   /*  p13 = (p11 + p15) / 2  */
  y13 = (y11 + y15) / 2.0;
  z13 = hgt;
  x4 = (x11 + x1) / 2.0;   /*  p4 = (p11 + p1) / 2  */
  y4 = (y11 + y1) / 2.0;
  z4 = hgt;
  x2 = (x1 + x4) / 2.0;   /*  p2 = (p1 + p4) / 2  */
  y2 = (y1 + y4) / 2.0;
  z2 = hgt;
  x3 = (x1 + x6) / 2.0;   /*  p3 = (p1 + p6) / 2  */
  y3 = (y1 + y6) / 2.0;
  z3 = hgt;
  x5 = (x4 + x6) / 2.0;   /*  p5 = (p4 + p6) / 2  */
  y5 = (y4 + y6) / 2.0;
  z5 = hgt;
  x7 = (x4 + x11) / 2.0;   /*  p7 = (p4 + p11) / 2  */
  y7 = (y4 + y11) / 2.0;
  z7 = hgt;
  x8 = (x4 + x13) / 2.0;   /*  p8 = (p4 + p13) / 2  */
  y8 = (y4 + y13) / 2.0;
  z8 = hgt;
  x9 = (x6 + x13) / 2.0;   /*  p9 = (p6 + p13) / 2  */
  y9 = (y6 + y13) / 2.0;
  z9 = hgt;
  x10 = (x6 + x15) / 2.0;   /*  p10 = (p6 + p15) / 2  */
  y10 = (y6 + y15) / 2.0;
  z10 = hgt;
  x12 = (x11 + x13) / 2.0;   /*  p12 = (p11 + p13) / 2  */
  y12 = (y11 + y13) / 2.0;
  z12 = hgt;
  x14 = (x13 + x15) / 2.0;   /*  p14 = (p13 + p15) / 2  */
  y14 = (y13 + y15) / 2.0;
  z14 = hgt;

      /*  Cue  */

  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =     0.000   -420.000 %3.3f\n",rad);
  fprintf(textdiskfile,"   BASERAD =     4.000\n");
  fprintf(textdiskfile,"   BASELOC =     0.000   -432.000 %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = CUETIP\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC =     0.000   -432.000 %3.3f\n",rad);
  fprintf(textdiskfile,"   BASERAD =     4.000\n");
  fprintf(textdiskfile,"   BASELOC =     0.000   -800.000 %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = CUE\n");

      /*  Cue Ball  */

  sph(0.0,-390.0,hgt,rad,"WHITE");

      /*  Pool Balls  */

  sph(x1,y1,z1,rad,"RED");
  sph(x2,y2,z2,rad,"YELLOW");
  sph(x3,y3,z3,rad,"BLUE");
  sph(x4,y4,z4,rad,"GREEN");
  sph(x5,y5,z5,rad,"PURPLE");
  sph(x6,y6,z6,rad,"MAROON");
  sph(x7,y7,z7,rad,"ORANGE");
  sph(x8,y8,z8,rad,"BLACK");
  sph(x9,y9,z9,rad,"ORANGESTRIPE");
  sph(x10,y10,z10,rad,"MAROONSTRIPE");
  sph(x11,y11,z11,rad,"PURPLESTRIPE");
  sph(x12,y12,z12,rad,"GREENSTRIPE");
  sph(x13,y13,z13,rad,"BLUESTRIPE");
  sph(x14,y14,z14,rad,"YELLOWSTRIPE");
  sph(x15,y15,z15,rad,"REDSTRIPE");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
}

void main()
{
  strcpy(filename,"POOLTABL.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}