/*
  ͻ
                                                                          
                               Die and Card                               
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/


#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"

typedef char name[32];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                              Die and Card                              \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.800    0.800    0.800\n");
  fprintf(textdiskfile,"   REFLWGT =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    2\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.300\n");
  fprintf(textdiskfile,"   OBSPOS  =  100.000  -800.000  150.000\n");
  fprintf(textdiskfile,"   ROTATE  =  -13.000\n");
  fprintf(textdiskfile,"   TILT    =   13.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CARPET\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.450    0.800    0.490\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = WHITE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.600    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   GLOSS   =    2.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BLACK\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.050    0.050    0.050\n");
  fprintf(textdiskfile,"   GLOSS   =    2.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = RED\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.300    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.000    0.000\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.150    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    5.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CHROME\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   18.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = CARPET\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =    0.000  350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  120.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.650    0.650    0.650\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =    0.000 -500.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  120.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.650    0.650    0.650\n");
}

void sph(TDA pt, float rad)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",pt[0],pt[1],pt[2]);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = WHITE\n");
}

void cyl(TDA pt1, TDA pt2, float rad)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = %3.3f %3.3f %3.3f\n",pt1[0],pt1[1],pt1[2]);
  fprintf(textdiskfile,"   BASERAD = %3.3f\n",rad);
  fprintf(textdiskfile,"   APEXLOC = %3.3f %3.3f %3.3f\n",pt2[0],pt2[1],pt2[2]);
  fprintf(textdiskfile,"   MATL    = WHITE\n");
}

void cir(TDA p, float rad, TDA v1, TDA v2)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",p[0],p[1],p[2]);
  fprintf(textdiskfile,"   V1      = %3.3f %3.3f %3.3f\n",v1[0],v1[1],v1[2]);
  fprintf(textdiskfile,"   V2      = %3.3f %3.3f %3.3f\n",v2[0],v2[1],v2[2]);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = RED\n");
}

void pln(Byte side, float rad, TDA p1, TDA p2, TDA p3, float x, float y, float z)
{
  TDA v1, v2, p;
  float dotrad;
  TDA t1, t2, cp;
  TDA cp1, cp2;
  TDA cp3, cp4;
  TDA adj;

  VecSub(p2,p1,v1);
  VecSub(p3,p1,v2);
  Vec(x,y,z,adj);
  VecAdd(p1,adj,p);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",p[0],p[1],p[2]);
  fprintf(textdiskfile,"   V1      = %3.3f %3.3f %3.3f\n",v1[0],v1[1],v1[2]);
  fprintf(textdiskfile,"   V2      = %3.3f %3.3f %3.3f\n",v2[0],v2[1],v2[2]);
  fprintf(textdiskfile,"   MATL    = WHITE\n");
  dotrad = rad * 0.65;
  switch (side)
  {
    case 1: VecAdd(p2,p3,t1);
	    VecScalMult(0.5,t1,t2);
	    VecAdd(t2,adj,cp);
	    cp[2] = cp[2] + 0.5;
	    cir(cp,dotrad,v1,v2);
	    break;
    case 2: VecAdd(p2,p3,t1);
	    VecScalMult(0.5,t1,t1);
	    VecAdd(p2,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp);
	    cp[1] = cp[1] - 0.5;
	    cir(cp,dotrad,v1,v2);
	    VecAdd(p3,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp);
	    cp[1] = cp[1] - 0.5;
	    cir(cp,dotrad,v1,v2);
	    break;
    case 3: VecAdd(p2,p3,t1);
	    VecScalMult(0.5,t1,t1);
	    VecAdd(t1,adj,cp);
	    cp[0] = cp[0] + 0.5;
	    cir(cp,dotrad,v1,v2);
	    VecAdd(p2,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp);
	    cp[0] = cp[0] + 0.5;
	    cir(cp,dotrad,v1,v2);
	    VecAdd(p3,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp);
	    cp[0] = cp[0] + 0.5;
	    cir(cp,dotrad,v1,v2);
	    break;
    case 4: VecAdd(p2,p3,t1);
	    VecScalMult(0.5,t1,t1);
	    VecAdd(p2,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp1);
	    cp1[0] = cp1[0] - 0.5;
	    cir(cp1,dotrad,v1,v2);
	    VecAdd(p3,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp2);
	    cp2[0] = cp2[0] - 0.5;
	    cir(cp2,dotrad,v1,v2);
	    Vec(cp1[0],cp2[1],cp1[2],cp);
	    cir(cp,dotrad,v1,v2);
	    Vec(cp1[0],cp1[1],cp2[2],cp);
	    cir(cp,dotrad,v1,v2);
	    break;
    case 5: VecAdd(p2,p3,t1);
	    VecScalMult(0.5,t1,t1);
	    VecAdd(t1,adj,cp);
	    cp[1] = cp[1] + 0.5;
	    cir(cp,dotrad,v1,v2);
	    VecAdd(p2,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp1);
	    cp1[1] = cp1[1] + 0.5;
	    cir(cp1,dotrad,v1,v2);
	    VecAdd(p3,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp2);
	    cp2[1] = cp2[1] + 0.5;
	    cir(cp2,dotrad,v1,v2);
	    Vec(cp2[0],cp1[1],cp1[2],cp);
	    cir(cp,dotrad,v1,v2);
	    Vec(cp1[0],cp1[1],cp2[2],cp);
	    cir(cp,dotrad,v1,v2);
	    break;
    case 6: VecAdd(p2,p3,t1);
	    VecScalMult(0.5,t1,t1);
	    VecAdd(p2,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp1);
	    cp1[2] = cp1[2] - 0.5;
	    cir(cp1,dotrad,v1,v2);
	    VecAdd(p3,t1,t2);
	    VecScalMult(0.5,t2,t2);
	    VecAdd(t2,adj,cp2);
	    cp2[2] = cp2[2] - 0.5;
	    cir(cp2,dotrad,v1,v2);
	    Vec(cp1[0],cp2[1],cp1[2],cp3);
	    cir(cp3,dotrad,v1,v2);
	    Vec(cp1[0],cp1[1],cp2[2],cp4);
	    cir(cp4,dotrad,v1,v2);
	    VecAdd(cp1,cp3,t1);
	    VecScalMult(0.5,t1,cp);
	    cir(cp,dotrad,v1,v2);
	    VecAdd(cp2,cp4,t1);
	    VecScalMult(0.5,t1,cp);
	    cir(cp,dotrad,v1,v2);
	   break;
  }
}

void die(float x, float y, float z, float rad)
{
  TDA p1, p2, p3, p4, p5, p6, p7, p8;

  Vec(x,y,z + rad,p1);
  Vec(x + 4.0 * rad,y,z + rad,p2);
  Vec(x + 4.0 * rad,y + 4.0 * rad,z + rad,p3);
  Vec(x,y + 4.0 * rad,z + rad,p4);
  Vec(x,y,z + rad + 4.0 * rad,p5);
  Vec(x + 4.0 * rad,y,z + rad + 4.0 * rad,p6);
  Vec(x + 4.0 * rad,y + 4.0 * rad,z + rad + 4.0 * rad,p7);
  Vec(x,y + 4.0 * rad,z + rad + 4.0 * rad,p8);
  sph(p1,rad);
  sph(p2,rad);
  sph(p3,rad);
  sph(p4,rad);
  sph(p5,rad);
  sph(p6,rad);
  sph(p7,rad);
  sph(p8,rad);
  cyl(p1,p2,rad);
  cyl(p2,p3,rad);
  cyl(p3,p4,rad);
  cyl(p4,p1,rad);
  cyl(p5,p6,rad);
  cyl(p6,p7,rad);
  cyl(p7,p8,rad);
  cyl(p8,p5,rad);
  cyl(p1,p5,rad);
  cyl(p2,p6,rad);
  cyl(p3,p7,rad);
  cyl(p4,p8,rad);

  /*    Pln(6, rad, p1, p4, p2,  0.0,  0.0, -rad);  */
  /*  6 - no bottom generation  */
  pln(2,rad,p1,p2,p5,0.0,-rad,0.0);   /*  2  */
  pln(3,rad,p3,p7,p2,rad,0.0,0.0);   /*  3  */
  pln(5,rad,p3,p4,p7,0.0,rad,0.0);   /*  5  */
  pln(4,rad,p1,p5,p4,-rad,0.0,0.0);   /*  4  */
  pln(1,rad,p5,p6,p8,0.0,0.0,rad);   /*  1  */
}

void pokerchip(float x, float y, float z, float rad, char * color)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  1.000  0.000\n");
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = %s\n",color);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = %3.3f %3.3f %3.3f\n",x,y,z);
  fprintf(textdiskfile,"   BASERAD = %3.3f\n",rad);
  fprintf(textdiskfile,"   APEXLOC = %3.3f %3.3f %3.3f\n",x,y,z - 5.0);
  fprintf(textdiskfile,"   MATL    = %s\n",color);
}

void spade(float x, float y, float z, float rad, char * color)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  0.000  1.000\n");
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = %s\n",color);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",(x + 1.7 * rad),y,z);
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  0.000  1.000\n");
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = %s\n",color);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"TRIANGLE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",(x - rad * 0.95),y,(z + 0.33 * rad));
  fprintf(textdiskfile,"   V1      = %3.3f  0.000  0.000\n",(3.6 * rad));
  fprintf(textdiskfile,"   V2      = %3.3f  0.000 %3.3f\n",(1.85 * rad),(3.0 * rad));
  fprintf(textdiskfile,"   MATL    = %s\n",color);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"TRIANGLE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",(x + 0.85 * rad),y,(z - 0.34 * rad));
  fprintf(textdiskfile,"   V1      = %3.3f  0.000 %3.3f\n",(-0.75 * rad),(-1.1 * rad));
  fprintf(textdiskfile,"   V2      = %3.3f  0.000 %3.3f\n",(0.75 * rad),(-1.1 * rad));
  fprintf(textdiskfile,"   MATL    = %s\n",color);
}

void make()
{
  Byte t;

  writestudio();

      /*  Ace of Spades  */

  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -40.000 -19.000   0.000\n");
  fprintf(textdiskfile,"   V1      =  80.000   0.000   0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000   0.000 128.000\n");
  fprintf(textdiskfile,"   MATL    = WHITE\n");
  spade(-12.0,-20.0,50.0,14.0,"BLACK");

    /*  Stack of Poker Chips  */

  for (t = 1; t <= 12; t++)
    pokerchip(-60.0,-85.0,t * 6.0,25.0,"RED");

    /*  Dice  */

  die(-80.0,-320.0,0.0,7.5);
  die(50.0,-335.0,0.0,7.5);

    /*  Tumbler  */

  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -170.000 -30.000 0.000\n");
  fprintf(textdiskfile,"   BASERAD = 60.000\n");
  fprintf(textdiskfile,"   APEXLOC = -170.000 -30.000 90.000\n");
  fprintf(textdiskfile,"   MATL    = CHROME\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"RING\n");
  fprintf(textdiskfile,"   LOC     = -170.000 -30.000 90.000\n");
  fprintf(textdiskfile,"   V1      =   1.000  0.000  0.000\n");
  fprintf(textdiskfile,"   V2      =   0.000  1.000  0.000\n");
  fprintf(textdiskfile,"   RAD1    = 45.000\n");
  fprintf(textdiskfile,"   RAD2    = 60.000\n");
  fprintf(textdiskfile,"   MATL    = BRASS\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
}

void main()
{
  strcpy(filename,"DIE&CARD.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}