/*
  ͻ
                                                                          
                               Desert Scene                               
                                                                          
                 by Larry Sharp and Christopher D. Watkins 	           
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

typedef char name[32];

FILE *textdiskfile;
name filename;

Word xresolution  = 640;
Word yresolution  = 480;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                             Desert Scene                               \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"              by Larry Sharp and Christopher D. Watkins                 \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.800    0.800    0.800\n");
  fprintf(textdiskfile,"   REFLWGT =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    1\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    1.200\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000 -250.000 175.000\n");
  fprintf(textdiskfile,"   ROTATE  =    0.000\n");
  fprintf(textdiskfile,"   TILT    =   10.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SKY\n");
  fprintf(textdiskfile,"   HORCOL  =    0.000    0.000    0.300\n");
  fprintf(textdiskfile,"   ZENCOL  =    0.400    0.000    0.400\n");
  fprintf(textdiskfile,"   CLOUDS  = FALSE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = SAND\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    1.000    0.700    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   AMPL    =    0.100\n");
  fprintf(textdiskfile,"   PHASE   =    0.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = SANDBLOCK\n");
  fprintf(textdiskfile,"   TEXTURE = GRIT\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   DIFRFL  =    1.000    0.700    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = SAND\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  500.000 4500.000 3000.000\n");
  fprintf(textdiskfile,"   RADIUS  =  700.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.600    0.600    0.600\n");
}

void make()
{
  float x, y, z, rad;

  writestudio();
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PYRAMID\n");
  fprintf(textdiskfile,"   LOC     = -700.000 1000.000    0.000\n");
  fprintf(textdiskfile,"   V1      =  400.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  400.000    0.000\n");
  fprintf(textdiskfile,"   HEIGHT  =  200.000\n");
  fprintf(textdiskfile,"   MATL    = SANDBLOCK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PYRAMID\n");
  fprintf(textdiskfile,"   LOC     = -300.000  500.000    0.000\n");
  fprintf(textdiskfile,"   V1      =  400.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  400.000    0.000\n");
  fprintf(textdiskfile,"   HEIGHT  =  200.000\n");
  fprintf(textdiskfile,"   MATL    = SANDBLOCK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PYRAMID\n");
  fprintf(textdiskfile,"   LOC     =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V1      =  400.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  400.000    0.000\n");
  fprintf(textdiskfile,"   HEIGHT  =  200.000\n");
  fprintf(textdiskfile,"   MATL    = SANDBLOCK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = -250.000  100.000 -100.000\n");
  fprintf(textdiskfile,"   RADIUS  =  150.000\n");
  fprintf(textdiskfile,"   MATL    = SAND\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = -300.000  150.000 -150.000\n");
  fprintf(textdiskfile,"   RADIUS  =  200.000\n");
  fprintf(textdiskfile,"   MATL    = SAND\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = -200.000   75.000  -65.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   MATL    = SAND\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
}

void main()
{
  strcpy(filename, "DESERT.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Larry Sharp and Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}