/*
   ***********************************************************************
   *									 *
   *                        Scene Script Generator			 *
   *									 *
   *               by Christopher D. Watkins and Larry Sharp		 *
   *									 *
   ***********************************************************************
*/


#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "malloc.h"
#include "defs.h"

typedef char String[32];

/* ***********************************************************************
   *									 *
   *		         Math and Screen Routines			 *
   *									 *
   ***********************************************************************
*/

void Vec(float r, float s, float t, TDA A)
{
  A[0]=r;
  A[1]=s;
  A[2]=t;
}

void VecCopy(TDA A, TDA B)
{
  B[0]=0.0+A[0];
  B[1]=0.0+A[1];
  B[2]=0.0+A[2];
}

void VecScalMult(float r, TDA A, TDA B)
{
  B[0]=r*A[0];
  B[1]=r*A[1];
  B[2]=r*A[2];
}

void VecNull(TDA A)
{
  A[0]=0.0;
  A[1]=0.0;
  A[2]=0.0;
}

void Set_Text_Screen(int tc, int tb)
{
  textcolor(tc);
  textbackground(tb);
  clrscr();
}

/* ***********************************************************************
   *									 *
   *			      Load a .SCN File				 *
   *									 *
   ***********************************************************************


  .3D and .SCN FORMAT:

A description of the XXXXXXXX.Scn file.  This is the first line.

1                                Number of Frames in sequence

TRUE   0   0  500  500           Do Perspective   Mx  My  Mz  D
 245  25                         Viewing Angle and Tilt
  45  45                         Light Angle and Tilt
FALSE                            Perform Vertical Sort
FALSE                            Place Edge Reflectors
FALSE                            Place Edge Reflectors at Zero

1                                Number of Objects in Frame

Grid.Dat                         Object File Name
    0.3    0.3    0.3            Ambient Color
    0.5    0.5    0.5            Diffuse Color
    0.2    0.2    0.2            Specular Color
    5                            Gloss
   50.0   50.0   50.0            Scale
    0.0    0.0    0.0            Rotate
   50.0   50.0    0.0            Translate
FALSE                            Object is reflected in mirrors
FALSE                            Allow Sort of Object
TRUE                             Object is a mirror
*/

#define  Max_Frame 30L
#define  Max_Objects 20

typedef struct{
  char Object_Name[14];
  TDA Translate;
  TDA Rotate;
  TDA Scale;
  Boolean Reflection;
  TDA Amb_Color;
  TDA Dif_Color;
  TDA Spc_Color;
  Byte Gloss;
  Boolean Sortable;
  Boolean Mirror;
} Object_Record;

Byte Object_Num, Frame_Num;

typedef struct{
  Boolean Perspective;
  int Mx;
  int My;
  int Mz;
  int D;
  int View_Angle;
  int View_Tilt;
  int Light_Angle;
  int Light_Tilt;
  Boolean Vert_Sort;
  Boolean Add_Edge_Reflectors;
  Boolean Add_Edge_Reflectors_At_Zero;
  float Mix;
  float Darken;
  Byte Last_Object;
  Object_Record Object_List[Max_Objects];
} Frame_Record;

static Frame_Record far *Frame_List;

Byte Object_Num, Frame_Num;
Byte Last_Frame_Num;
char Comment[80];

#define Frame Frame_List[Frame_Num]
#define Frame_Object Frame_List[Frame_Num].Object_List[Object_Num]

void Init_Frame_Buffer()
{
  strcpy(Comment, "");
  for(Frame_Num=0; Frame_Num<Max_Frame; Frame_Num++)
  {
    Frame.Perspective=false;
    Frame.Mx=0;
    Frame.My=0;
    Frame.Mz=0;
    Frame.D=0;
    Frame.View_Angle=0;
    Frame.View_Tilt=0;
    Frame.Light_Angle=0;
    Frame.Vert_Sort=0;
    Frame.Add_Edge_Reflectors=false;
    Frame.Add_Edge_Reflectors_At_Zero=false;
    Frame.Mix=0;
    Frame.Darken=0;
    Frame.Last_Object=1;
    for(Object_Num=0; Object_Num<Max_Objects; Object_Num++)
    {
      strcpy(Frame_Object.Object_Name, "");
      VecNull(Frame_Object.Translate);
      VecNull(Frame_Object.Rotate);
      VecNull(Frame_Object.Scale);
      Frame_Object.Reflection=false;
      VecNull(Frame_Object.Amb_Color);
      VecNull(Frame_Object.Dif_Color);
      VecNull(Frame_Object.Spc_Color);
      Frame_Object.Gloss=0;
      Frame_Object.Sortable=false;
      Frame_Object.Mirror=false;
    }
  }
  Frame_Num=1;
  Last_Frame_Num=1;
  Object_Num=1;
}

void Scale(float x, float y, float z)
{
  Vec(x, y, z, Frame_Object.Scale);
}

void Rotate(float x, float y, float z)
{
  Vec(x, y, z, Frame_Object.Rotate);
}

void Translate(float x, float y, float z)
{
  Vec(x, y, z, Frame_Object.Translate);
}

void Reflect_Object(Boolean state)
{
  Frame_Object.Reflection=state;
}

void Obj_Amb_Color(float r, float g, float b)
{
  Vec(r, g, b, Frame_Object.Amb_Color);
}

void Obj_Dif_Color(float r, float g, float b)
{
  Vec(r, g, b, Frame_Object.Dif_Color);
}

void Obj_Spc_Color(float r, float g, float b)
{
  Vec(r, g, b, Frame_Object.Spc_Color);
}

void Obj_Gloss(Byte gls)
{
  Frame_Object.Gloss=gls;
}

void Allow_Sort(Boolean state)
{
  Frame_Object.Sortable=state;
}

void Mirrored(Boolean state)
{
  Frame_Object.Mirror=state;
}

/* ***********************************************************************
   *									 *
   *		       Load Scene from .SCN Disk File			 *
   *									 *
   ***********************************************************************
*/

FILE *In_File;
FILE *Out_File;

Boolean Duplicate;
char b2s[8];

Boolean Bool(char B[8])
{
  if((B[0]=='F') || (B[0]=='f'))
    return(false);
  else
    return(true);
}

void Bool_To_String(Boolean b)
{
  if(b==false)
    strcpy(b2s, "false");
  else
    strcpy(b2s, "true");
}

Byte Get_Num()
{
  char c[8];
  int Sel1, Sel2;
  Byte Sel;

  do
  {
    while(!isdigit(c[0]))
    {
      while(!kbhit());
      c[0]=getch();
    }
    Sel1=10*((c[0])-48);
    c[0]='a';
    while(!isdigit(c[0]))
    {
      while(!kbhit());
      c[0]=getch();
    }
    Sel2=(c[0])-48;
    Sel=Sel1+Sel2;
  }
  while(Sel>20);
  return(Sel);
}

#define Frame0 Frame_List[0]
#define Frame_Object0 Frame_List[0].Object_List[Object_Num]

void Duplication()
{
  for(Frame_Num=1; Frame_Num<Max_Frame; Frame_Num++)
  {
    Frame.Perspective=Frame0.Perspective;
    Frame.Mx=Frame0.Mx;
    Frame.My=Frame0.My;
    Frame.Mz=Frame0.Mz;
    Frame.D=Frame0.D;
    Frame.View_Angle=Frame0.View_Angle;
    Frame.View_Tilt=Frame0.View_Tilt;
    Frame.Light_Angle=Frame0.Light_Angle;
    Frame.Light_Tilt=Frame0.Light_Tilt;
    Frame.Vert_Sort=Frame0.Vert_Sort;
    Frame.Add_Edge_Reflectors=Frame0.Add_Edge_Reflectors;
    Frame.Add_Edge_Reflectors_At_Zero=Frame0.Add_Edge_Reflectors_At_Zero;
    Frame.Mix=Frame0.Mix;
    Frame.Darken=Frame0.Darken;
    Frame.Last_Object=Frame0.Last_Object;
    for(Object_Num=1; Object_Num<Max_Objects; Object_Num++)
    {
      strcpy(Frame_Object.Object_Name, Frame_Object0.Object_Name);
      VecCopy(Frame_Object0.Translate, Frame_Object.Translate);
      VecCopy(Frame_Object0.Rotate, Frame_Object.Rotate);
      VecCopy(Frame_Object0.Scale, Frame_Object.Scale);
      Frame_Object.Reflection=Frame_Object0.Reflection;
      VecCopy(Frame_Object0.Amb_Color, Frame_Object.Amb_Color);
      VecCopy(Frame_Object0.Dif_Color, Frame_Object.Dif_Color);
      VecCopy(Frame_Object0.Spc_Color, Frame_Object.Spc_Color);
      Frame_Object.Sortable=Frame_Object0.Sortable;
      Frame_Object.Mirror=Frame_Object0.Mirror;
    }
  }
}

void File_IO_Error()
{
  sound(1000);
  delay(500);
  nosound();
  clrscr();
  printf("File I/O Error!\nHit any key to exit....");
  getch();
  exit(1);
}

void Load_Scene_File(String File_Name)
{
  char B[8];
  int i1, i2, i3, i4;
  float f1, f2, f3;
  char Object_File_Name[82];
  char blank[82];

  if((In_File=fopen(File_Name, "rt"))==NULL)
    File_IO_Error();
  fgets(Comment, 80, In_File);
  fgets(blank, 80, In_File);
  fscanf(In_File, "%d", &Last_Frame_Num);
  if(Last_Frame_Num==1)
    Duplicate=true;
  else
    Duplicate=false;
  for(Frame_Num=0; Frame_Num<Last_Frame_Num; Frame_Num++)
  {
    fgets(blank, 80, In_File);
    fscanf(In_File, "%s %d %d %d %d", B, &i1, &i2, &i3, &i4);
    Frame.Perspective=Bool(B);
    Frame.Mx=i1;
    Frame.My=i2;
    Frame.Mz=i3;
    Frame.D=i4;
    fscanf(In_File, "%d %d", &i1, &i2);
    Frame.View_Angle=i1;
    Frame.View_Tilt=i2;
    fscanf(In_File, "%d %d", &i1, &i2);
    Frame.Light_Angle=i1;
    Frame.Light_Tilt=i2;
    fscanf(In_File, "%s", B);
    Frame.Vert_Sort=Bool(B);
    fscanf(In_File, "%s", B);
    Frame.Add_Edge_Reflectors=Bool(B);
    fscanf(In_File, "%s", B);
    Frame.Add_Edge_Reflectors_At_Zero=Bool(B);
    fscanf(In_File, "%f", &f1);
    Frame.Mix=f1;
    fscanf(In_File, "%f", &f1);
    Frame.Darken=f1;
    fgets(blank, 80, In_File);
    fscanf(In_File, "%d", &i1);
    Frame.Last_Object=i1;
    for(Object_Num=0; Object_Num<Frame.Last_Object; Object_Num++)
    {
      fgets(blank, 80, In_File);
      fgets(blank, 80, In_File);
      fgets(Object_File_Name, 80, In_File);
      strcpy(Frame_Object.Object_Name, Object_File_Name);
      fscanf(In_File, "%f %f %f", &f1, &f2, &f3);
      Obj_Amb_Color(f1, f2, f3);
      fscanf(In_File, "%f %f %f", &f1, &f2, &f3);
      Obj_Dif_Color(f1, f2, f3);
      fscanf(In_File, "%f %f %f", &f1, &f2, &f3);
      Obj_Spc_Color(f1, f2, f3);
      fscanf(In_File, "%d", &i1);
      Obj_Gloss(i1);
      fscanf(In_File, "%f %f %f", &f1, &f2, &f3);
      Scale(f1, f2, f3);
      fscanf(In_File, "%f %f %f", &f1, &f2, &f3);
      Rotate(f1, f2, f3);
      fscanf(In_File, "%f %f %f", &f1, &f2, &f3);
      Translate(f1, f2, f3);
      fscanf(In_File, "%s", B);
      Reflect_Object(Bool(B));
      fscanf(In_File, "%s", B);
      Allow_Sort(Bool(B));
      fscanf(In_File, "%s", B);
      Mirrored(Bool(B));
    }
  }
  fclose(In_File);
  if(Duplicate)
    Duplication();
}

void Save_Scene_File(String File_Name)
{
  char B[8];
  int i1, i2, i3, i4;
  float f1, f2, f3;
  String Object_File_Name;
  String blank;

  if((Out_File=fopen(File_Name, "wt"))==NULL)
    File_IO_Error();
  fprintf(Out_File, "%s", Comment);
  fprintf(Out_File, "\n");
  fprintf(Out_File, "%d\n", Last_Frame_Num);
  for(Frame_Num=0; Frame_Num<Last_Frame_Num; Frame_Num++)
  {
    fprintf(Out_File, "\n");
    Bool_To_String(Frame.Perspective);
    fprintf(Out_File, "%s %d %d %d %d\n", b2s,
					  Frame.Mx,
					  Frame.My,
					  Frame.Mz,
					  Frame.D);
    fprintf(Out_File, "%d %d\n", Frame.View_Angle, Frame.View_Tilt);
    fprintf(Out_File, "%d %d\n", Frame.Light_Angle, Frame.Light_Tilt);
    Bool_To_String(Frame.Vert_Sort);
    fprintf(Out_File, "%s\n", b2s);
    Bool_To_String(Frame.Add_Edge_Reflectors);
    fprintf(Out_File, "%s\n", b2s);
    Bool_To_String(Frame.Add_Edge_Reflectors_At_Zero);
    fprintf(Out_File, "%s\n", b2s);
    fprintf(Out_File, "%4.4f\n", Frame.Mix);
    fprintf(Out_File, "%4.4f\n", Frame.Darken);
    fprintf(Out_File, "\n");
    fprintf(Out_File, "%d\n", Frame.Last_Object);
    for(Object_Num=0; Object_Num<Frame.Last_Object; Object_Num++)
    {
      fprintf(Out_File, "\n");
      fprintf(Out_File, "%s", Frame_Object.Object_Name);
      fprintf(Out_File, "%4.4f %4.4f %4.4f\n", Frame_Object.Amb_Color[0],
					       Frame_Object.Amb_Color[1],
					       Frame_Object.Amb_Color[2]);
      fprintf(Out_File, "%4.4f %4.4f %4.4f\n", Frame_Object.Dif_Color[0],
					       Frame_Object.Dif_Color[1],
					       Frame_Object.Dif_Color[2]);
      fprintf(Out_File, "%4.4f %4.4f %4.4f\n", Frame_Object.Spc_Color[0],
					       Frame_Object.Spc_Color[1],
					       Frame_Object.Spc_Color[2]);
      fprintf(Out_File, "%d\n", Frame_Object.Gloss);
      fprintf(Out_File, "%4.4f %4.4f %4.4f\n", Frame_Object.Scale[0],
					       Frame_Object.Scale[1],
					       Frame_Object.Scale[2]);
      fprintf(Out_File, "%4.4f %4.4f %4.4f\n", -Frame_Object.Rotate[0],
					       -Frame_Object.Rotate[1],
					       -Frame_Object.Rotate[2]);
      fprintf(Out_File, "%4.4f %4.4f %4.4f\n", -Frame_Object.Translate[0],
					       -Frame_Object.Translate[1],
					       -Frame_Object.Translate[2]);
      Bool_To_String(Frame_Object.Reflection);
      fprintf(Out_File, "%s\n", b2s);
      Bool_To_String(Frame_Object.Sortable);
      fprintf(Out_File, "%s\n", b2s);
      Bool_To_String(Frame_Object.Mirror);
      fprintf(Out_File, "%s\n", b2s);
    }
  }
  fclose(Out_File);
}

String Scene_File, Org_File, tmp;

void Get_Scene_File_Name()
{
  Byte x, y;

  textcolor(YELLOW);
  textbackground(BLUE);
  gotoxy(1, 8);
  cprintf("Enter File Name -> ");
  x=wherex();
  y=wherey();
  textcolor(WHITE+BLINK);
  cprintf("%s", "SPHRPLAN");
  textcolor(YELLOW);
  gotoxy(x, y);
  while(!(kbhit()));
  cprintf("            ");
  gotoxy(x, y);
  gets(Scene_File);
  if(!(strcmp(Scene_File, "")))
    strcpy(Scene_File, "SPHRPLAN");
  strupr(Scene_File);
  strcpy(Org_File, Scene_File);
}

void Create_Script()
{
  clrscr();
  printf("3D Modeler Script File Generator\n\nCreate Script\n\n");
  Get_Scene_File_Name();
  strcpy(tmp, Scene_File);
  strcat(Scene_File, ".ORG");
  Save_Scene_File(Scene_File);
  strcpy(Scene_File, tmp);
  strcat(Scene_File, ".SCN");
  Save_Scene_File(Scene_File);
}

void Load_Script()
{
  clrscr();
  printf("3D Modeler Script File Generator\n\nLoad Script\n\n");
  Frame_Num=0;
  Get_Scene_File_Name();
  strcat(Scene_File, ".SCN");
  Load_Scene_File(Scene_File);
}

void Display()
{
  clrscr();
  printf("<Lft/Rgt> +/- Frm -- <Dn/Up> +/- Obj -- <A/D> Add/Del Frm -- <+/-> Add/Del Obj\n");
  printf("-------------------------- <Spc> Edit --- <Esc> Menu -------------------------\n");
  printf("<00> Comment = %s", Comment);
  printf("------->  Frame %d  <-------\n", Frame_Num);
  Bool_To_String(Frame.Perspective);
  printf("<01> Perspective = %s\n", b2s);
  printf("<02> Mx, My, Mz D = %d %d %d %d\n", Frame.Mx, Frame.My, Frame.Mz, Frame.D);
  printf("<03> View Angle & Tilt = %d %d\n", Frame.View_Angle, Frame.View_Tilt);
  printf("<04> Light Angle & Tilt = %d %d\n", Frame.Light_Angle, Frame.Light_Tilt);
  Bool_To_String(Frame.Vert_Sort);
  printf("<05> Vertical Sort = %s\n", b2s);
  Bool_To_String(Frame.Add_Edge_Reflectors);
  printf("<06> Edge Reflectors         = %s\n", b2s);
  Bool_To_String(Frame.Add_Edge_Reflectors_At_Zero);
  printf("<07> Edge Reflectors At Zero = %s\n", b2s);
  printf("<08> Mix    = %4.4f\n", Frame.Mix);
  printf("<09> Darken = %4.4f\n", Frame.Darken);
  printf("-------->  Object %d  <--------\n", Object_Num);
  printf("<10> Name = %s",Frame_Object.Object_Name);
  printf("<11> Ambient Color  = %4.4f %4.4f %4.4f\n", Frame_Object.Amb_Color[0],
						      Frame_Object.Amb_Color[1],
						      Frame_Object.Amb_Color[2]);
  printf("<12> Diffuse Color  = %4.4f %4.4f %4.4f\n", Frame_Object.Dif_Color[0],
						      Frame_Object.Dif_Color[1],
						      Frame_Object.Dif_Color[2]);
  printf("<13> Specular Color = %4.4f %4.4f %4.4f\n", Frame_Object.Spc_Color[0],
						      Frame_Object.Spc_Color[1],
						      Frame_Object.Spc_Color[2]);
  printf("<14> Gloss = %d\n",Frame_Object.Gloss);
  printf("<15> Scale     = %4.4f %4.4f %4.4f\n", Frame_Object.Scale[0],
						 Frame_Object.Scale[1],
						 Frame_Object.Scale[2]);
  printf("<16> Rotate    = %4.4f %4.4f %4.4f\n", -Frame_Object.Rotate[0],
						 -Frame_Object.Rotate[1],
						 -Frame_Object.Rotate[2]);
  printf("<17> Translate = %4.4f %4.4f %4.4f\n", -Frame_Object.Translate[0],
						 -Frame_Object.Translate[1],
						 -Frame_Object.Translate[2]);
  Bool_To_String(Frame_Object.Reflection);
  printf("<18> Object will Reflect   = %s\n", b2s);
  Bool_To_String(Frame_Object.Sortable);
  printf("<19> Object is Sortable    = %s\n", b2s);
  Bool_To_String(Frame_Object.Mirror);
  printf("<20> Object is a Reflector = %s", b2s);
}

void Edit_Script()
{
  String B;
  Boolean Fin2, Edit;
  Word Sel;
  Byte Dir;

  clrscr();
  printf("3DModeler Script File Gnerator\n\nEdit Script\n\n\n");
  Frame_Num=0;
  Object_Num=0;
  Display();
  Fin2=false;
  Edit=false;
  while(!Fin2)
  {
    while(!kbhit());
    Dir=getch();
    switch(Dir)
    {
      case 'M' : if(Frame_Num==(Last_Frame_Num-1))
		   Frame_Num=0;
		 else
		   ++Frame_Num;
		 break;
      case 'K' : if(Frame_Num==0)
		   Frame_Num=(Last_Frame_Num-1);
		 else
		   --Frame_Num;
		 break;
      case 'P' : if(Object_Num==(Frame.Last_Object-1))
		   Object_Num=0;
		 else
		   ++Object_Num;
		 break;
      case 'H' : if(Object_Num==0)
		   Object_Num=(Frame.Last_Object-1);
		 else
		   --Object_Num;
		 break;
      case ' ' : Edit=true;
		 break;
      case 27  : Fin2=true;
		 break;
      case '+' : if(Frame.Last_Object==Max_Objects)
		 {
		   sound(1000);
		   delay(200);
		   nosound();
		 }
		 else
		 {
		   ++Frame.Last_Object;
		   Object_Num=(Frame.Last_Object-1);
		 }
		 break;
      case '-' : if(Frame.Last_Object==0)
		 {
		   sound(1000);
		   delay(200);
		   nosound();
		 }
		 else
		 {
		   --Frame.Last_Object;
		   Object_Num=(Frame.Last_Object-1);
		 }
		 break;
      case 'a' : if(Last_Frame_Num==Max_Frame)
		 {
		   sound(1000);
		   delay(200);
		   nosound();
		 }
		 else
		 {
		   ++Last_Frame_Num;
		   Frame_Num=(Last_Frame_Num-1);
		 }
		 break;
      case 'd' : if(Last_Frame_Num==0)
		 {
		   sound(1000);
		   delay(200);
		   nosound();
		 }
		 else
		 {
		   --Last_Frame_Num;
		   Frame_Num=(Last_Frame_Num-1);
		 }
		 break;
    }
    if(!Fin2)
    {
      Display();
      if(Edit)
      {
	Sel=Get_Num();
	switch(Sel)
	{
	  case 0  : gotoxy(1, 3);
		    printf("<00> Comment = ");
		    gets(Comment);
		    gotoxy(1, 3);
		    printf("<00> Comment = %s", Comment);
		    break;
	  case 1  : gotoxy(1, 5);
		    printf("<01> Perspective = ");
		    gets(B);
		    Frame.Perspective=Bool(B);
		    gotoxy(1, 5);
		    printf("<01> Perspective = %s", B);
		    break;
	  case 2  : gotoxy(1, 6);
		    printf("<02> Mx, My, Mz, D = ");
		    scanf("%d %d %d %d", &Frame.Mx, &Frame.My,
					 &Frame.Mz, &Frame.D);
		    gotoxy(1, 6);
		    printf("<02> Mx, My, Mz, D = %d %d %d %d", Frame.Mx,
							       Frame.My,
							       Frame.Mz,
							       Frame.D);
		    break;
	  case 3  : gotoxy(1, 7);
		    printf("<03> ViewAngle, ViewTilt = ");
		    scanf("%d %d", &Frame.View_Angle, &Frame.View_Tilt);
		    gotoxy(1, 7);
		    printf("<03> ViewAngle, ViewTilt = %d %d", Frame.View_Angle,
							       Frame.View_Tilt);
		    break;
	  case 4  : gotoxy(1, 8);
		    printf("<04> LightAngle, LightTilt = ");
		    scanf("%d %d", &Frame.Light_Angle, &Frame.Light_Tilt);
		    gotoxy(1, 8);
		    printf("<04> LightAngle, LightTilt = %d %d", Frame.Light_Angle,
								 Frame.Light_Tilt);
		    break;
	  case 5  : gotoxy(1, 9);
		    printf("<05> Vertical Sort = ");
		    gets(B);
		    Frame.Vert_Sort=Bool(B);
		    gotoxy(1, 9);
		    printf("<05> Vertical Sort = %s", B);
		    break;
	  case 6  : gotoxy(1, 10);
		    printf("<06> Edge Reflectors = ");
		    gets(B);
		    Frame.Add_Edge_Reflectors=Bool(B);
		    gotoxy(1, 10);
		    printf("<06> Edge Reflectors = %s", B);
		    break;
	  case 7  : gotoxy(1, 11);
		    printf("<07> Edge Reflectors At Zero = ");
		    gets(B);
		    Frame.Add_Edge_Reflectors_At_Zero=Bool(B);
		    gotoxy(1, 11);
		    printf("<07> Edge Reflectors = %s", B);
		    break;
	  case 8  : gotoxy(1, 12);
		    printf("<08> Mix = ");
		    scanf("%f", &Frame.Mix);
		    gotoxy(1, 12);
		    printf("<08> Mix = %4.4f", Frame.Mix);
		    break;
	  case 9  : gotoxy(1, 13);
		    printf("<09> Darken = ");
		    scanf("%f", &Frame.Darken);
		    gotoxy(1, 13);
		    printf("<09> Darken = %4.4f", Frame.Darken);
		    break;
	  case 10 : gotoxy(1, 15);
		    printf("<10> Name = ");
		    gets(Frame_Object.Object_Name);
		    gotoxy(1, 15);
		    printf("<10> Name = %s", Frame_Object.Object_Name);
		    break;
	  case 11 : gotoxy(1, 16);
		    printf("<11> Ambient Color = ");
		    scanf("%f %f %f", &Frame_Object.Amb_Color[0],
				      &Frame_Object.Amb_Color[1],
				      &Frame_Object.Amb_Color[2]);
		    gotoxy(1, 16);
		    printf("<11> Ambient Color = %4.4f %4.4f %4.4f", Frame_Object.Amb_Color[0],
								     Frame_Object.Amb_Color[1],
								     Frame_Object.Amb_Color[2]);
		    break;
	  case 12 : gotoxy(1, 17);
		    printf("<12> Diffuse Color = ");
		    scanf("%f %f %f", &Frame_Object.Dif_Color[0],
				      &Frame_Object.Dif_Color[1],
				      &Frame_Object.Dif_Color[2]);
		    gotoxy(1, 17);
		    printf("<12> Diffuse Color = %4.4f %4.4f %4.4f", Frame_Object.Dif_Color[0],
								     Frame_Object.Dif_Color[1],
								     Frame_Object.Dif_Color[2]);
		    break;
	  case 13 : gotoxy(1, 18);
		    printf("<13> Specular Color = ");
		    scanf("%f %f %f", &Frame_Object.Spc_Color[0],
				      &Frame_Object.Spc_Color[1],
				      &Frame_Object.Spc_Color[2]);
		    gotoxy(1, 18);
		    printf("<13> Specular Color = %4.4f %4.4f %4.4f", Frame_Object.Spc_Color[0],
								      Frame_Object.Spc_Color[1],
								      Frame_Object.Spc_Color[2]);
		    break;
	  case 14 : gotoxy(1, 19);
		    printf("<14> Gloss = ");
		    scanf("%d", &Frame_Object.Gloss);
		    gotoxy(1, 19);
		    printf("<14> Gloss = %d", Frame_Object.Gloss);
		    break;
	  case 15 : gotoxy(1, 20);
		    printf("<15> Scale     = ");
		    scanf("%f %f %f", &Frame_Object.Scale[0],
				      &Frame_Object.Scale[1],
				      &Frame_Object.Scale[2]);
		    gotoxy(1, 20);
		    printf("<15> Scale     = %4.4f %4.4f %4.4f", Frame_Object.Scale[0],
								 Frame_Object.Scale[1],
								 Frame_Object.Scale[2]);
		    break;
	  case 16 : gotoxy(1, 21);
		    printf("<16> Rotate    = ");
		    scanf("%f %f %f", &Frame_Object.Rotate[0],
				      &Frame_Object.Rotate[1],
				      &Frame_Object.Rotate[2]);
		    gotoxy(1, 21);
		    printf("<16> Rotate    = %4.4f %4.4f %4.4f", Frame_Object.Rotate[0],
								 Frame_Object.Rotate[1],
								 Frame_Object.Rotate[2]);
		    break;
	  case 17 : gotoxy(1, 22);
		    printf("<17> Translate = ");
		    scanf("%f %f %f", &Frame_Object.Translate[0],
				      &Frame_Object.Translate[1],
				      &Frame_Object.Translate[2]);
		    gotoxy(1, 22);
		    printf("<17> Translate = %4.4f %4.4f %4.4f", Frame_Object.Translate[0],
								 Frame_Object.Translate[1],
								 Frame_Object.Translate[2]);
		    break;
	  case 18 : gotoxy(1, 23);
		    printf("<18> Object will Reflect   = ");
		    gets(B);
		    Frame_Object.Reflection=Bool(B);
		    gotoxy(1, 23);
		    printf("<18> Object will Reflect   = %s", B);
		    break;
	  case 19 : gotoxy(1, 24);
		    printf("<19> Object is Sortable    = ");
		    gets(B);
		    Frame_Object.Sortable=Bool(B);
		    gotoxy(1, 24);
		    printf("<19> Object is Sortable    = %s", B);
		    break;
	  case 20 : gotoxy(1, 25);
		    printf("<20> Object is a Reflector = ");
		    gets(B);
		    Frame_Object.Mirror=Bool(B);
		    gotoxy(1, 25);
		    printf("<20> Object is a Reflector = %s", B);
		    break;
	}
      }
    }
    Edit=false;
    Display();
  }
}

void Save_Script()
{
  clrscr();
  printf("3D Modeler Script File Generator\n\nSave Script\n\n");
  Get_Scene_File_Name();
  strcat(Org_File, ".ORG");
  Save_Scene_File(Org_File);
  strcat(Scene_File, ".SCN");
  Save_Scene_File(Scene_File);
}

Boolean Fin;

void Exit_Program()
{
  clrscr();
  printf("Exiting 3DModeler Script File Generator\n\n");
  Fin=true;
}

void Menu()
{
  int Sel;
  char c[5]="\n\n";

  clrscr();
  printf("3DModeler Script File Generator\n\nBy Christopher D. Watkins\n\n");
  printf(">>>>> Menu <<<<<\n\n");
  printf("<1> Create Script\n");
  printf("<2> Load Script\n");
  printf("<3> Edit Script\n");
  printf("<4> Save Script\n");
  printf("<5> Exit\n");
  do
  {
    while(!isdigit(c[0]))
    {
      while(!kbhit());
      c[0]=getch();
    }
    Sel=(c[0])-48;
  }
  while((Sel>5) || (Sel<1));
  switch(Sel)
  {
    case 1 : Create_Script(); break;
    case 2 : Load_Script();   break;
    case 3 : Edit_Script();   break;
    case 4 : Save_Script();   break;
    case 5 : Exit_Program();  break;
  }
}

void main()
{
  Frame_List=farcalloc(Max_Frame, sizeof(Frame_Record));
  Set_Text_Screen(YELLOW, BLUE);
  Init_Frame_Buffer();
  Fin=false;
  while(Fin==false)
    Menu();
  farfree(Frame_List);
  Set_Text_Screen(LIGHTGRAY, BLACK);
}