/* ***********************************************************************
   *									 *
   *                         Variable Declarations	 		 *
   *									 *
   *		 Original Material by Christopher D. Watkins		 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#define NumVerticiesInFacet 4
#define MaxVertexNumInFacet 4
#define ScaleData 23000
#define ScaleImage 100

/*
#define MaxFacet 1678	     	      independant : MaxFacet  = n
#define MaxVertex 6712	     	      verticies   MaxVertex = 4 * n
*/

#define MaxFacet 3600
#define MaxVertex 3721

int LastVertex, LastFacet;
int LastVertexNumInFacet;
int VertexNum, FacetNum;
int VertexNumInFacet;
TDIA Vertex[MaxVertex+1];
static int far *Facet;

/* ***********************************************************************
   *									 *
   *	       Routines to Load and Save Vertex and Facet Data		 *
   *									 *
   ***********************************************************************

   InitVertexBuffer - clear memory for facet and vertex data
   LoadData         - load facet and vertex data
   SaveData	    - save facet and vertex data
*/

float InvScaleData, InvScaleImage;

void InitVertexBuffer()
{
  InvScaleData=1.0/ScaleData;
  InvScaleImage=1.0/ScaleImage;
  for(VertexNum=0; VertexNum<=MaxVertex; VertexNum++)
    VecNullInt(Vertex[VertexNum]);
  for(FacetNum=0; FacetNum<=MaxFacet; FacetNum++)
  {
    for(VertexNumInFacet=0; VertexNumInFacet<=MaxVertexNumInFacet; VertexNumInFacet++)
      Facet[(FacetNum*5)+VertexNumInFacet]=0;
  }
}

typedef char Name[20];

FILE *DiskFile;
Name FileName;

void LoadData(Name FileName)
{
  TDIA temp;
  int x, y, z;

  DiskFile=fopen(FileName, "r+b");
  LastVertex=getw(DiskFile);
  LastFacet=getw(DiskFile);
  LastVertexNumInFacet=getw(DiskFile);
  for(VertexNum=1; VertexNum<=LastVertex; VertexNum++)
  {
    x=getw(DiskFile);
    y=getw(DiskFile);
    z=getw(DiskFile);
    if((abs(x)>ScaleData) || (abs(y)>ScaleData) || (abs(z)>ScaleData))
    {
      printf("Error : data out of range - Vertex #%d\n", VertexNum);
      exit(1);
    }
    else
      VecInt(x, y, z, Vertex[VertexNum]);
  }
  for(FacetNum=1; FacetNum<=LastFacet; FacetNum++)
  {
    for(VertexNumInFacet=1; VertexNumInFacet<=LastVertexNumInFacet; VertexNumInFacet++)
      Facet[(FacetNum*5)+VertexNumInFacet]=getw(DiskFile);
  }
  fclose(DiskFile);
}

void SaveData(Name FileName)
{
  int x, y, z;

  DiskFile=fopen(FileName, "w+b");
  putw(LastVertex, DiskFile);
  putw(LastFacet, DiskFile);
  putw(LastVertexNumInFacet, DiskFile);
  for(VertexNum=1; VertexNum<=LastVertex; VertexNum++)
  {
    UnVecInt(Vertex[VertexNum], &x, &y, &z);
    putw(x, DiskFile);
    putw(y, DiskFile);
    putw(z, DiskFile);
  }
  for(FacetNum=1; FacetNum<=LastFacet; FacetNum++)
  {
    for(VertexNumInFacet=1; VertexNumInFacet<=LastVertexNumInFacet; VertexNumInFacet++)
      putw(Facet[(FacetNum*5)+VertexNumInFacet], DiskFile);
  }
  fclose(DiskFile);
}

typedef struct{
  int x;
  int y;
} PixelVector;

typedef PixelVector PixelArray[NumVerticiesInFacet+2];
typedef TDA VoxelArray[NumVerticiesInFacet+1];