/* ***********************************************************************
   *									 *
   *		          Cylinder Database Generator		         *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "malloc.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"
#include "modelsup.h"
#include "shpmk.h"

int Theta, DTheta, HalfDTheta;

void SetupCylinder(int NumOfFacets)
{
  VertexNum=1;
  VertexNumInFacet=1;
  LastFacet=NumOfFacets;
  LastVertexNumInFacet=4;
  LastVertex=LastFacet*LastVertexNumInFacet;
  DTheta=360/LastFacet;
  HalfDTheta=DTheta/2;
  Theta=HalfDTheta;
}

int NumFacetsOnEndCap, T;

void EndCaps()
{
  int tmp;

  NumFacetsOnEndCap=LastFacet/2-1;
  tmp=NumFacetsOnEndCap&1;
  if(tmp==1)
    Theta=-90+HalfDTheta;
  else
    Theta=-90+DTheta;
  for(T=1; T<=NumFacetsOnEndCap; T++)
  {
    AddVertex(CosD(Theta-HalfDTheta), SinD(Theta-HalfDTheta), 1.0);
    AddVertex(CosD(Theta+HalfDTheta), SinD(Theta+HalfDTheta), 1.0);
    AddVertex(CosD(180-Theta-HalfDTheta), SinD(180-Theta-HalfDTheta), 1.0);
    AddVertex(CosD(180-Theta+HalfDTheta), SinD(180-Theta+HalfDTheta), 1.0);
    ++FacetNum;
    ++LastFacet;
    VertexNumInFacet=1;
    AddVertex(CosD(Theta+HalfDTheta), SinD(Theta+HalfDTheta), -1.0);
    AddVertex(CosD(Theta-HalfDTheta), SinD(Theta-HalfDTheta), -1.0);
    AddVertex(CosD(180-Theta+HalfDTheta), SinD(180-Theta+HalfDTheta), -1.0);
    AddVertex(CosD(180-Theta-HalfDTheta), SinD(180-Theta-HalfDTheta), -1.0);
    ++FacetNum;
    ++LastFacet;
    VertexNumInFacet=1;
    Theta+=DTheta;
  }
}

void MakeCylinderDatabase()
{
  for(FacetNum=1; FacetNum<=LastFacet; FacetNum++)
  {
    AddVertex(CosD(Theta-HalfDTheta), SinD(Theta-HalfDTheta), -1.0);
    AddVertex(CosD(Theta+HalfDTheta), SinD(Theta+HalfDTheta), -1.0);
    AddVertex(CosD(Theta+HalfDTheta), SinD(Theta+HalfDTheta), 1.0);
    AddVertex(CosD(Theta-HalfDTheta), SinD(Theta-HalfDTheta), 1.0);
    Theta+=DTheta;
    VertexNumInFacet=1;
  }
  EndCaps();
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupCylinder(90);
  MakeCylinderDatabase();
  SaveData("CYLINDER.DAT");
  Exit_Graphics();
  farfree(Facet);
}
