/*
  ͻ
                                                                          
                 Three-Dimensional Iterated Function Systems              
                                                                          
                         By Christopher D. Watkins                        
                                                                          
  ͼ
*/


#include "stdio.h"
#include "stdlib.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

char mapping[80];
float h[8], k[8], l[8];
Byte maxmap;
float r, scale;

void Line()
{
  strcpy(mapping, "Line");
  h[0]=-1.00;  h[1]=1.00;
  k[0]=-1.00;  k[1]=1.00;
  l[0]=-1.00;  l[1]=1.00;
  maxmap=2;
  r=0.5;
  scale=500.0;
}

void Triangle()
{
  strcpy(mapping, "Triangle");
  h[0]=-0.71;  h[1]=0.00;  h[2]=0.71;
  k[0]=-0.71;  k[1]=1.00;  k[2]=-0.71;
  l[0]=0.00;   l[1]=0.00;  l[2]=0.00;
  maxmap=3;
  r=0.5;
  scale=500.0;
}

void Pentagon()
{
  strcpy(mapping, "2D Pentagon");
  h[0]=0.50;   h[1]=1.00;   h[2]=0.0;    h[3]=0.84;   h[4]=0.16;
  k[0]=0.00;   k[1]=0.30;   k[2]=0.30;   k[3]=1.00;   k[4]=1.00;
  l[0]=0.00;   l[1]=0.00;   l[2]=0.00;   l[3]=0.00;   l[4]=0.00;
  maxmap=5;
  r=0.5;
  scale=400.0;
}

void Tetrahedron2D()
{
  strcpy(mapping, "2D Tetrahedron");
  h[0]=0.56;   h[1]=0.00;   h[2]=0.67;    h[3]=1.00;
  k[0]=0.00;   k[1]=0.88;   k[2]=1.00;    k[3]=0.90;
  l[0]=0.00;   l[1]=0.00;   l[2]=0.00;    l[3]=0.00;
  maxmap=4;
  r=0.5;
  scale=600.0;
}

void MengerSponge2D()
{
  strcpy(mapping, "2D Menger Sponge");
  h[0]=0.00;   h[1]=0.50;   h[2]=1.00;    h[3]=1.00;
  h[4]=0.50;   h[5]=0.00;   h[6]=0.50;    h[7]=0.50;
  k[0]=0.14;   k[1]=0.00;   k[2]=0.14;    k[3]=0.64;
  k[4]=1.00;   k[5]=0.64;   k[6]=0.27;    k[7]=0.31;
  l[0]=0.00;   l[1]=0.00;   l[2]=0.00;    l[3]=0.00;
  l[4]=0.00;   l[5]=0.00;   l[6]=0.00;    l[7]=0.00;
  maxmap=8;
  r=0.3333333333;
  scale=700.0;
}

void Tetrahedron3D()
{
  strcpy(mapping, "3D Tetrahedron");
  h[0]=0.00;   h[1]=0.00;   h[2]=-0.71;    h[3]= 0.71;
  k[0]=0.00;   k[1]=1.00;   k[2]=-0.71;    k[3]=-0.71;
  l[0]=1.00;   l[1]=0.00;   l[2]= 0.00;    l[3]= 0.00;
  maxmap=4;
  r=0.5;
  scale=250.0;
}

void MengerSponge3D()
{
  strcpy(mapping, "3D Menger Sponge");
  h[0]=0.00;   h[1]=1.00;   h[2]=0.00;    h[3]=1.00;
  h[4]=0.00;   h[5]=1.00;   h[6]=0.00;    h[7]=1.00;
  k[0]=0.00;   k[1]=0.00;   k[2]=1.00;    k[3]=1.00;
  k[4]=0.00;   k[5]=0.00;   k[6]=1.00;    k[7]=1.00;
  l[0]=0.00;   l[1]=0.00;   l[2]=0.00;    l[3]=0.00;
  l[4]=1.00;   l[5]=1.00;   l[6]=1.00;    l[7]=1.00;
  maxmap=8;
  r=0.3333333333;
  scale=400.0;
}

void MengerSpongeSlice3D()
{
  strcpy(mapping, "3D Menger Sponge Slice");
  h[0]=0.00;   h[1]=1.00;   h[2]=0.00;    h[3]=1.00;
  h[4]=0.00;   h[5]=1.00;   h[6]=0.00;
  k[0]=0.00;   k[1]=0.00;   k[2]=1.00;    k[3]=1.00;
  k[4]=0.00;   k[5]=0.00;
  l[0]=0.00;   l[1]=0.00;   l[2]=0.00;    l[3]=0.00;
  l[4]=1.00;   l[5]=1.00;
  maxmap=6;
  r=0.3333333333;
  scale=400.0;
}

void Diamond3D()
{
  strcpy(mapping, "3D Diamond");
  h[0]= 0.00;  h[1]= 0.71;  h[2]=-0.71;  h[3]= 0.71;  h[4]=-0.71;  h[5]= 0.00;
  k[0]= 0.00;  k[1]= 0.71;  k[2]=-0.71;  k[3]=-0.71;  k[4]= 0.71;  k[5]= 0.00;
  l[0]= 1.00;  l[1]= 0.00;  l[2]= 0.00;  l[3]= 0.00;  l[4]= 0.00;  l[5]=-1.00;
  maxmap=6;
  r=0.3333333333;
  scale=600.0;
}

float x, y, z;

void Iterate()
{
  int m;
  float xn, yn, zn;
  Byte col;

  m=random(maxmap);
  xn=(x+h[m])*r;
  yn=(y+k[m])*r;
  zn=(z+l[m])*r;
  if(m==7)
    col=35;
  else
    col=(m+1)*36-1;
  Cartesian_Plot_3D(Round(xn), Round(yn), Round(zn), col);
  x=xn;
  y=yn;
  z=zn;
}

Byte q;
int sel;

int Get_Selection()
{
  char c[4];

  clrscr();
  puts("0 : Line");
  puts("1 : Triangle");
  puts("2 : Pentagon");
  puts("3 : 2D Tetrahedron");
  puts("4 : 2D Menger Sponge");
  puts("5 : 3D Tetrahedrom");
  puts("6 : 3D Menger Sponge");
  puts("7 : Menger Sponge Slice");
  puts("8 : Diamond");
  puts("9 : Exit");
  while(!isdigit(c[0]))
  {
    while(!kbhit());
    c[0]=getch();
  }
  return(atoi(c));
}

void main()
{
  Title();
  while((sel=Get_Selection())<9)
  {
    for(q=0; q<8; q++)
    {
      h[q]=0.0;
      k[q]=0.0;
      l[q]=0.0;
    }
    Init_Graphics(56);
    switch(sel)
    {
      case 0 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       Line();
	       break;
      case 1 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 45);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       Triangle();
	       break;
      case 2 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       Pentagon();
	       break;
      case 3 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       Tetrahedron2D();
	       break;
      case 4 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       MengerSponge2D();
	       break;
      case 5 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       Tetrahedron3D();
	       break;
      case 6 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       MengerSponge3D();
	       break;
      case 7 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       MengerSpongeSlice3D();
	       break;
      case 8 : Init_Perspective(false, 0, 0, 500, 500);
	       Init_Plotting(205, 15);
	       Put_Axis_And_Palette(true);
	       Axis_And_Palette();
	       Diamond3D();
	       break;
    }
    for(q=0; q<maxmap; q++)
    {
      h[q]*=scale;
      k[q]*=scale;
      l[q]*=scale;
    }
    x=h[0];
    y=k[0];
    z=l[0];
    while(!(kbhit()))
      Iterate();
    Exit_Graphics();
  }
  Set_Mode(3);
}