/****************************************************************************/
/*                                                                          */
/*   VRServer - Vertical Retrace Interrupt Server, v1.00                    */
/*   ---------------------------------------------------                    */
/*                                                                          */
/* File:        VRSERVER.H                                                  */
/*                                                                          */
/* Description: Definitions for the functions in VRServer                   */
/*                                                                          */
/* Compiler(s): Borland C++ 3.1                                             */
/*                                                                          */
/* by Petteri Kangaslampi 1993. NOT COPYRIGHTED, PUBLIC DOMAIN.             */
/*                                                                          */
/****************************************************************************/


#ifndef __VRSERVER
#define __VRSERVER


#ifdef __cplusplus
extern "C" {
#endif


/****************************************************************************/
/*                                                                          */
/* Function:    void InitVRServer(void (*PreVRFunct)(), void (*VRFunt)());  */
/*                                                                          */
/* Description: Initializes the VRServer and synchronises it the VR.        */
/*                                                                          */
/* Arguments:   void (*PreVRFunct)()    function called before the VR       */
/*              void (*VRFunct)()       function called in the VR           */
/*                                                                          */
/****************************************************************************/

void InitVRServer(void (*PreVRFunct)(), void (*VRFunt)());



/****************************************************************************/
/*                                                                          */
/* Function:    void SyncVRServer(void);                                    */
/*                                                                          */
/* Description: Synchronises the VRServer timer to the screen refresh.      */
/*                                                                          */
/* Arguments:   none                                                        */
/*                                                                          */
/****************************************************************************/

void SyncVRServer(void);



/****************************************************************************/
/*                                                                          */
/* Function:    void RemoveVRServer(void);                                  */
/*                                                                          */
/* Description: Removes the VRServer timer and returns the normal timer     */
/*               frequency.                                                 */
/* Arguments:   none                                                        */
/*                                                                          */
/****************************************************************************/

void RemoveVRServer(void);


#ifdef __cplusplus
}
#endif



#endif