/*
	Example1.C version 1.0
	by Robert Schmidt of Ztiff Zox Softwear 1993

	Example of making use of a TWEAK file by loading it directly at
		run-time.  This program needs the file(s) created by TWEAK
		available at run-time.
*/

#include <conio.h>
#include "TwkUser.h"	/* declares the neccessary functions and types */

main()
	{
	/* Define the pointer that should point to the loaded array of
	   Registers, and the int to hold its size */

    RegisterPtr rarray;
	int rsize;

	/* Now use the loadRegArray function declared in TwkUser.h to load the
	   TWEAK file.  Memory is automatically allocated.  Note that the
	   second argument is the address of the pointer defined above!
	   The returned value is the number of Register elements loaded. */

    rsize = loadRegArray("320x240.256", &rarray);

	/* rarray now points to the loaded array.  The second argument to
	   outRegArray is the number if Register elements in the array. */

    outRegArray(rarray, rsize);

	/* The mode is now set, so wait for the user to press a key...
	   Nothing much interesting to look at, I'm afraid. */

    getch();
	textmode(C80);

	/* Free the Register array allocated in loadRegArray.  *You* are
	   responsible for doing this! */

    free(rarray);

	return 0;
	}
