// plasma.c
// Lord Helmet
//------------------------------------------Synergy Design


#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>

void FastPutPixel(short, short, unsigned char);
unsigned char FastGetPixel(short, short);
void fastsetRGB(unsigned char[]);
void subdivide(short, short, short, short);
void adjust(short, short, short, short, short, short);

float f = 2.0;

void main(argc, argv)
int argc;
char *argv[];
{
  union REGS regs;
  unsigned char palette[768];
  short i;

  if(argc != 2)
    {
      printf("Uncorrect number of arguments\n");
      printf("Type     PLASMA ROUGHNESS\n");
      printf("Example usage : PLASMA 2.0\n");
      exit(0);
    }
  f = atof(argv[1]);

  regs.h.ah = 0;
  regs.h.al = 19;
  int86(0x10, &regs, &regs);

  for(i=0;i<3;i++)
    palette[i] = 0;

  for(i=0;i<64;i++)
    {
      palette[3*i+3] = i; palette[3*i+4] = 63-i; palette[3*i+5] = 0;
      palette[3*i+195] = 63-i; palette[3*i+196] = 0; palette[3*i+197] = i;
      palette[3*i+387] = 0; palette[3*i+388] = i; palette[3*i+389] = 63-i;
    }
  fastsetRGB(palette);

  randomize();
  FastPutPixel(0, 0, 1+random(192));
  FastPutPixel(319, 0, 1+random(192));
  FastPutPixel(319, 199, 1+random(192));
  FastPutPixel(0, 199, 1+random(192));
  subdivide(0, 0, 319, 199);

  for(;!kbhit(););                /* checks for keyboard hit */

  regs.h.ah = 0;
  regs.h.al = 3;
  int86(0x10, &regs, &regs);
}

void subdivide(short x1, short y1, short x2, short y2)
{
  short x, y;
  float v;

  if(kbhit())
    exit(0);
  if((x2-x1 >= 2) || (y2-y1 >= 2))
    {
      x = (x1+x2)/2;
      y = (y1+y2)/2;

      adjust(x1, y1, x, y1, x2, y1);
      adjust(x2, y1, x2, y, x2, y2);
      adjust(x1, y2, x, y2, x2, y2);
      adjust(x1, y1, x1, y, x1, y2);

      if(FastGetPixel(x, y) == 0)
	{
	  v = (FastGetPixel(x1, y1)+FastGetPixel(x2, y1)+FastGetPixel(x2, y2)+FastGetPixel(x1, y2))/4;
	  FastPutPixel(x, y, (unsigned char)v);
	}

      subdivide(x1, y1, x, y);
      subdivide(x, y1, x2, y);
      subdivide(x, y, x2, y2);
      subdivide(x1, y, x, y2);
    }
}

void adjust(short xa, short ya, short x, short y, short xb, short yb)
{
  short d;
  float v;

  if(FastGetPixel(x, y) == 0)
    {
      d = abs(xa-xb)+abs(ya-yb);
      v = (FastGetPixel(xa, ya)+FastGetPixel(xb, yb))/2 + (random(100)-50)*d*f/100;
      v = (v<1) ? 1 : v;
      v = (v>192) ? 192 : v;
      FastPutPixel(x, y, (unsigned char)v);
    }
}
void fastsetRGB(unsigned char palette[])


{
  #define PAL_ADR 0x03c8

  unsigned long temp;
  unsigned short palofs;
  unsigned short palseg;

  temp = (unsigned long)palette;
  palofs = (unsigned short)temp;
  palseg = (unsigned short)(temp >> 16);

  printf("");

	asm	pushf
	asm	push	si
	asm	push	ds
	asm	cld

	asm	mov  	ax,palseg
	asm	mov	ds,ax
	asm	xor	al,al
	asm	mov	cx,768
	asm	mov	dx,PAL_ADR
	asm     mov	si,palofs
	asm	out	dx,al

	asm	inc	dx
lus:	asm	lodsb
	asm	out	dx,al
	asm	loop	lus

	asm	pop	ds
	asm	pop	si
	asm	popf
}

/*--------------------------------------------------------------------------*/

void FastPutPixel(short x, short y ,unsigned char kleur)
{
	asm	pushf
	asm	push	es

	asm	mov	ax,0xA000
	asm	mov	es,ax

	asm	mov	ax,y
	asm	mov	bx,x
	asm	xchg	ah,al
	asm	add	bx,ax
	asm	shr	ax,2
	asm	add	bx,ax

	asm	mov	al,kleur
	asm	mov	es:[bx],al

	asm 	pop	es
	asm	popf
}

/*--------------------------------------------------------------------------*/

void FastSetOne(char index,char r,char g,char b)
{
	asm	mov	al,index
	asm	mov	dx,PAL_ADR
	asm	out	dx,al

	asm	inc	dx
	asm	mov	al,r
	asm	out	dx,al
	asm	mov	al,g
	asm	out	dx,al
	asm	mov	al,b
	asm	out	dx,al
}

/*--------------------------------------------------------------------------*/

unsigned char FastGetPixel(short x,short y)
{
  unsigned char kleur;

	asm	pushf
	asm	push	es

	asm	mov	ax,0xA000
	asm	mov	es,ax

	asm	mov	ax,y
	asm	mov	bx,x
	asm	xchg	ah,al
	asm	add	bx,ax
	asm	shr	ax,2
	asm	add	bx,ax

	asm	mov	al,es:[bx]
	asm	mov 	kleur,al

	asm 	pop	es
	asm	popf
  return(kleur);
}
