/*********************************************************************
** QFML DEMO :
**   ALTHOUGH THIS LISTING CAN'T BE MODIFIED, IT SHOWS HOW QFM WORKS.
**     IT LOADS TWO 320x200x256 IMAGES INTO THE MEMORY ALLOCATED BY
**   OPENMEM AND MOVES A WINDOW IN THEM WICH CAN BE SEEN ON THE
**   SCREEN.
**     TO SEE A DEATILED EXPLANATION OF QFM'S FUNCTIONS READ DE READ-
**   ME FILE AND THE QFML.H FILE.
**
**   THE PAN IMAGE FORMAT IS JUST A QUICK RAW FORMAT.
**   THE VIDEO.H AND VIDEO.C HAVE NOT BEEN INCLUDED IN THIS PACKAGE
** BUT THEY ARE NOT REALLY  IMPORTANT AS IT IS JUST A SIMPLE DRIVER
** FOR MCGA MODE.
**
** (C) RENDER OF ACC TEAM (1995)
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "video.h"
#include "qfml.h"                // To use QFML functions include this file
                                 // and link with qfml.obj

#define word unsigned int
#define dword unsigned long int
#define byte unsigned char
#define NUM 2

//-------------------------------------------------
// Just a function to load the palette to use

void
LoadMCGAPalette3(char *nombre,byte *colores,char extendido)
{
	FILE	*f;
	int	b,c,a;

	f=fopen(nombre,"rb");
	if (!ferror(f)){
		if (extendido)
				colores[0]=getc(f);
		a=0;
		do{
			colores[a]=getc(f);
			a=a+1;
		}while ( (!feof(f)) && (a<768) );
		b=FP_SEG(colores);
		c=FP_OFF(colores);
		asm{
				mov	ah,0x10
				mov 	al,0x12
				mov	bx,0
				mov	cx,256
				mov	dx,c
				mov 	es,b

				int	0x10
		}
		fclose(f);
  }else printf("\  Error: File error.\n");
}

//----------------------------------------------------
// Just a function to rotate the palette (very simple)

void
CicloPal(byte *colores)
{
	word b,c;

    for (int a=3;a<768;a++)
		colores[a]++;


	b=FP_SEG(colores);
	c=FP_OFF(colores);
	asm{
			mov	ah,0x10
			mov 	al,0x12
			mov	bx,0
			mov	cx,256
			mov	dx,c
			mov 	es,b

			int	0x10
	}
}

//============================================================
// Look carefully at this one, this is the IMPORTANT BIT.

void
main(void)
{
    dword First_addr;                 // Keeps starting QFM's memory address
    dword MCGA_off;                   // Plane address of video mem.
    dword num_ks;                     // Keeps the amount of K's reserved
    dword p5;                         // Auxiliar

    dword a;                          // Used as an offset to First_addr
    byte pal[768];                    // For the palette to rotate

    char *cads[]={                    // File names
		"screen01.pan",
     "screen02.pan",
    };


    // First of all start QFM before leaving textmode
    if (StartPL()) exit(1);

    // Then open the whole mem after the first Megabyte.
    if (OpenMem()) {
      LeavePL();           // Leave QFM mode before leaving your code.(ALWAYS)
      exit(1);
    }

    // We get the amount of memory available
    num_ks=GiveAmo();
    if (num_ks<130) {      // We need a minimum of 128 k
      CloseMem();          // Close mem. before leavinf QFM. (ALWAYS)
      LeavePL();           // Leave QFM mode before leaving your code.(ALWAYS)
    }
    printf ("Available memory after first Mgb. (Kbytes):%lu\n",num_ks);

    // Then we need the starting address of this block in plane
    // memory. Observe it will always be after position 1048576 (1Mb)
    First_addr=GiveSta();
    printf ("First Address:%lu\n",First_addr);

    // Wait just a little before leaving text mode
    delay(50*50);
    PutVideo(0x13);        // This is a <video.h> function. It starts 13h mode

    // We need the starting address of video ram. As a example I use the
    // VirToPL function to translate a seg:off mode to a 4Gb offset
    MCGA_off=VirToPL(0xa000,0);       //MCGA_off MCGA

    // Then we load the two screens, one after the other.
    // Observe that in 320x200x256 mode the screen is just
    // an array of 64000 bytes containg each the color register of that
    // pixel. For Example color of pixel x=29,y=30 is just offset
    // y*320+x in the segment A000h
    for(a=0;a<NUM;a++){
      LoadMCGAScreen(cads[a],1);      // This is a <video.h> function.It loads
                                      // a PAN and puts it into video memory.
      p5=First_addr+64000L*a;         // We calculate the 4Gb offset were we
      Pl2Pl(MCGA_off,p5,64000L);      // will copy the 64000 array to
    }

    LoadMCGAPalette3(cads[0],pal,1);  // Just Load a palette

    ClearVideo();                     // Clear the screen

    // repeat this bucle until a key is hit
    for (;!kbhit();){

        for (a=0;( (a<(NUM-1)*64000)&&(!kbhit()) );a+=320){
            Pl2Pl(First_addr+a,MCGA_off,64000L);    // Show a part of the two screens
            CicloPal(pal);            // Rotate the palette
        }
        for (a=(NUM-1)*64000L;( (a>1280)&&(!kbhit()) );a-=320){
            Pl2Pl(First_addr+a,MCGA_off,64000L);    // Show a part of the two screens
            CicloPal(pal);            // Rotate the palette
        }
    }

    // And leave
    QuitVideo();                      // Quit video mode
    getch();                          // Clear keyboard buffer

    // Close openned mem. before living
    CloseMem();

    // Leave QFM before termination
    LeavePL();
}