;
;  PAL.ASM  //  ARM 12/93
;

        Ideal
        Model TPascal
        P286
        Radix 10

        CODESEG

PUBLIC GetPalette    ; ( var RGB; from: byte; count : word );
PUBLIC SetPalette    ; ( var RGB; from: byte; count : word );
PUBLIC DimPalette    ; ( var RGB; col : byte )


; // SetPalette

MACRO OUT_dx_al
   out dx, al
   jmp $+2
   jmp $+2
   jmp $+2
ENDM

       PROC SetPalette FAR
       ARG RGB : DWord, FROM : Byte, COUNT : Word
          les di, [RGB]
          mov dx, 3c8h
          mov al, [FROM]
          OUT_dx_al

          inc dx
          mov cx, [COUNT]
       @@1:
          mov al, [es:di]
          OUT_dx_al
          mov al, [es:di+1]
          OUT_dx_al
          mov al, [es:di+2]
          OUT_dx_al
          add di,3
          dec cx
          jnz @@1
       ret
       ENDP


; // GetPalette

MACRO IN_al_dx
   in al, dx
   jmp $+2
   jmp $+2
   jmp $+2
ENDM

       PROC GetPalette FAR
       ARG RGB : DWord, FROM : Byte, COUNT : Word
          les di, [RGB]
          mov dx, 3c7h
          mov al, [FROM]
          OUT_dx_al

          add dx,2
          mov cx, [COUNT]
       @@1:
          IN_al_dx
          mov [es:di],al
          IN_al_dx
          mov [es:di+1], al
          IN_al_dx
          mov [es:di+2], al
          add di,3
          dec cx
          jnz @@1
       ret
       ENDP



; // DimPalette : dims palette one notch
;

MACRO COMPONENT op
LOCAL @@@1
         mov bl, [es:di]
         op bl
         js @@@1
         sub bl, [cs:si+bx]
         mov [es:di], bl
      @@@1:
         inc di
ENDM

       PROC DimPalette FAR
       ARG RGB : DWord, COL : Byte
         les di, [RGB]
         add di, 3               ; don't mess with color 0

         mov al, [COL]
         xor ah, ah
         shl ax,6
         add ax, offset DivTable
         mov si, ax              ; [cs:si+bx] = bx/COL

         xor bh, bh
         mov cx, 255
      @1:
         COMPONENT inc    ; red
         COMPONENT dec    ; green
         COMPONENT dec    ; blue

         dec cx
         jnz @1

       les di, [RGB]
       push es
       push di
       push 0
       push 256
       call SetPalette

       @@exit:
       ret
       ENDP

; Division table:
;
;    N/D (N=0..63,D=1..33) is accessed at offset 64*(D-1) + N
;


DivTable:
       D = 1
       REPT 33
         N = 0
         REPT 64
           db N/D
           N = N + 1
         ENDM
         D = D + 1
       ENDM


       END


