;****************************************************************************
; Filename: LTOA.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.02.09
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PSZ @ltoa(LONG value,PSZ string,LONG radix);
;    Input: Eax, value - value to convert to ASCII
;           Edx, string - string pointer
;           Ecx, radix - radix to convert too, 2 to 36
;   Output: string pointer
;  Comment: Converts a value to a string. @ltoa is sign sensitive and will
;           add a '-' if the sign bit is set. The radix must be between 2 and
;           36 or @ltoa will return NULL. The string output can be up to 33
;           characters (including the '\0').
;****************************************************************************

        Include STDDEF.INC

        Codeseg

Extrn NumberConvert:Byte

Proc     ltoa ,3
                Cmp     Ecx,2
                Jb      @@Exit
                Cmp     Ecx,36
                Ja      @@Exit
                Or      Eax,Eax
                Push    Ebx
                Jns     @@Next
                Sub     Esp,36
                Mov     [Byte Edx],"-"
                Neg     Eax                
                Push    Edx
                Lea     Ebx,[Esp+4+35]
                Mov     [Byte Ebx],0
        Align   4
@@Loop00:       Clear   Edx
                Div     Ecx
                Dec     Ebx
                Mov     Dl,[NumberConvert+Edx]
                TestZ   Eax
                Mov     [Ebx],Dl
                Jnz     @@Loop00
                Mov     Eax,[Esp]
                Mov     Edx,Ebx
                Inc     Eax
                Call    @stpcpy
                Mov     Edx,Eax
                Pop     Eax
                Add     Esp,36
                Pop     Ebx
                Ret
        Align   4
@@Next:         Sub     Esp,36
                Push    Edx
                Lea     Ebx,[Esp+4+35]
                Mov     [Byte Ebx],0
        Align   4
@@Loop01:       Clear   Edx
                Div     Ecx
                Dec     Ebx
                Mov     Dl,[NumberConvert+Edx]
                TestZ   Eax
                Mov     [Ebx],Dl
                Jnz     @@Loop01
                Mov     Eax,[Esp]
                Mov     Edx,Ebx
                Call    @stpcpy
                Mov     Edx,Eax
                Pop     Eax
                Add     Esp,36
                Pop     Ebx
                Ret
        Align   4
@@Exit:         Clear   Eax
                Ret
Endp

        End
