;-----------------------------------------------       -----------------------+
;OK, KLEINE STERN-ROUTINE						      |
;--------------							--------------+
;doc lazy of the lkcc berlin						      |
;---------------				------------------------------|
;some greets to: !twin,tt,trill,xxs,ds,ea,synec,lion,iku,tga,baco,stone,brain |
;-----------------					----------------------|
;look  " . "-file for more information					      |
;---------------------------		--------------------------------------|

.model	small
.286
.stack	100h

assume cs:code,ds:data

code	segment
;-------------------------------------
;SOME EQUS
;------------
bs_width	equ	320
stars_number	equ	200	;LIKE LINES IN MODE 13H
random_byte	equ	63	;2^X-1 XN

;---------------------------------------
;SOME VARS
;-----------
count		dw	0

;------------------------------------------
;JSUT THE STRUC FOR THE TABLE
;----------------
star_field	struc
	st_adr		dw	0
	st_start_adr	dw	0
	st_left		dw	0
	st_left_strt	dw	0
	st_bgrd_color	db	0
	st_color	db	0
	st_speed	db	0	;1/2/4/5/8
	st_wait		db	0
	st_next		dw	0	;JUST TO GET LENGTH OF STRUC
star_field	ends

start:

	;------------------------
	;SET MODE
		mov	ax,13h
		int	10h

		cli
	;-------------------------
	;SET PAL
		push	seg data
		pop	ds
		mov	si,offset hpal
		call	raster
		call	setpal

	;------------------------
	;SET SEGS
		mov	ax,0a000h
		mov	es,ax

		push	seg dspic
		pop	ds
	;-----------------------
	;PIC TO SCREEN
		sub	di,di
		sub	si,si
		mov	cx,32000
		rep	movsw

	;-------------------------
	;BEGIN OF THE STARS
		push	seg data
		pop	ds

		call	setstar

	;-------------------------------------------
	;MAKE PIC BIGHT
	;WITH THE HELP OF PAL AND HPAL
	;HPAL IS THE PALLETTE WHICH IS OUTED
	; TO THE VGA..
	;PAL IS THE PALLETTE WHICH ISI THE GOAL
	;------
		push	seg data
		pop	ds

		mov	bl,63		;GRAY-STEPS
br_lop1:	push	bx
		mov	di,offset hpal
		mov	si,offset pal
		mov	cx,768
br_lop2:	lodsb
		sub	al,bl
		jnb	br_jmp1
		sub	al,al
br_jmp1:	mov	[di],al
		inc	di
		loop	br_lop2
		call	frame
		pop	bx
		dec	bl
	;-------
		jne	br_lop1

	;-----------------------------
	; WAIT FOR A KEY
	;--------------------
wait_key:	call	frame
		in	al,60h
		cmp	al,1
		jne	wait_key

	;-------------------------------------------
	;MAKE PIC DARK
	;------
		mov	bl,63		;GRAY-STEPS
	;-------
dr_lop1:	push	bx
		mov	di,offset hpal
		mov	cx,768
dr_lop2:	cmp	byte ptr [di],0
		je	dr_jmp1
		dec	byte ptr [di]
dr_jmp1:	inc	di
		loop	dr_lop2
		call	frame
	;-------
		pop	bx
		dec	bl
		jne	dr_lop1

		mov	ax,3
		int	10h
		mov	ah,4ch
		int	21h


;-----------------------------------
;MAIN-CALL
;----------
frame:		call	raster
		mov	si,offset hpal
		call	setpal
		call	stars
		ret

;--------------------------------------
;PUT SOME DATAS INTO THE TABLE
;-----------
setstar:	push	0a000h
		pop	es
		push	seg data
		pop	ds
		mov	di,offset star_datas
		mov	si,bs_width-1		;BS_START
		mov	cx,stars_number
	;------
st0:		mov	[di.ST_ADR],si		;ADR.
		mov	[di.ST_START_ADR],si
		mov	al,es:[si]
		mov	[di.ST_BGRD_COLOR],al
		mov	ah,byte ptr cs:[count]		;RANDOM
		and	ah,3
		inc	ah
		cmp	ah,3
		jnz	st1
		inc	ah
	;AL:=1,2,4
st1:		mov	[di.ST_SPEED],ah

		mov	bl,ah

		add	ah,251
		mov	[di+st_color],ah	;COLOR

		sub	bh,bh
		mov	ax,320
		sub	dx,dx
		div	bx
		mov	[di.st_left],ax
		mov	[di.st_left_strt],ax

		mov	al,byte ptr cs:[count+1]
		mov	byte ptr [di.st_wait],al		;WAIT
		in	al,41h
		mov	ah,al
		in	al,40h
		sub	word ptr cs:[count],ax
		add	word ptr cs:[count],di

		add	di,st_next
		add	si,bs_width
		loop	st0
	;------
		ret


;---------------------------------------
;MOVE STARS AND PUT THEM TO SCREEN
;----------------
stars:		push	seg data	;SURE IS SURE...
		pop	ds
		push	0a000h
		pop	es

		mov	cx,stars_number
		mov	di,offset star_datas
	;------
star1:		push	cx
		cmp	byte ptr [di.st_wait],0
		jz	move
		dec	byte ptr [di.st_wait]
		jmp	next

move:		mov	al,[di.st_bgrd_color]
		mov	ah,[di.st_color]
		mov	bx,[di.st_adr]
		cmp	es:[bx],ah
		jnz	no
		mov	byte ptr es:[bx],al

no:		dec	word ptr [di.st_left]	;LEFT
		jz	new

		mov	dl,[di.st_speed]
		sub	dh,dh
		sub	bx,dx
		cmp	es:[bx],al
		jnz	no2
		mov	es:[bx],ah
no2:		mov	[di],bx		;NEW ADR

next:		in	al,41h
		mov	ah,al
		in	al,42h
		add	word ptr cs:[count],ax
		add	di,st_next
		pop	cx
		loop	star1
	;------
		ret


new:		mov	bx,[di.st_start_Adr]
		mov	[di.st_adr],bx
		mov	bx,[di.st_left_strt]
		mov	[di.st_left],bx
		mov	al,byte ptr cs:[count]
		and	al,random_byte
		mov	[di.st_wait],al
		jmp	next


;----------------------------
;WAIT FOR VBL
;-------------
raster:		mov	ah,8
		mov	dx,3dah
rast1:		in	al,dx
		and	al,ah
		je	rast1
		ret

;--------------------------------------------
;PUT PAL TO VGA
;-------------------
setpal:		mov	cx,300h	;DS:SI & CLI
		sub	al,al
setcx:		mov	dx,3c8h
		out	dx,al
		inc	dx
		rep	outsb
		ret

code	ends


;------------------------
dspic segment
include pic.dat
dspic ends

;------------------------
data	segment byte
pal:
	include pal.dat
hpal:
	db 768 dup (0)
star_datas:
	db	stars_number*st_next dup (?)
data	ends

end start