:h1. The Toolbar
:artwork name='TOOLBAR.BMP'.
:p.

At the top of the Workarea there are a collection of icons that
represent the Toolbar (or Template) area. These items can be
dragged into the document to create new elements. In some cases,
the tool can also be double-clicked to open a secondary window.
:h2. The Document Tool
:artwork name='BOOK.BMP'.
:p.

If the workarea is empty, then dropping the document tool in it
creates a new document. SpHyDir prompts for the name of the new
file (which should be in the library and should end in HTM or
HTML).
:p.

Within an existing document, the DOC tool creates a subdocument
link to another HTML file. The user can always link another HTML
file to any hotword in any paragraph or point in the text.
However, a Subdocument link is used to build a single large
logical document out of a sequence of smaller files.
:p.

A Subdocument object can go anywhere, but it will not make much
sense or produce good results unless all the Subdocument are at
the end of a file.
:p.

Drag the Document Tool over and drop it in the file as you would
create a paragraph or point. The Subdocument definition is then
completed by dragging the WPS icon for an HTM or HTML file over
and dropping it on the newly created object. If the dropped file
was previously processed by SpHyDir, the Title of that document
can be extracted from the Extended Attributes of the file and
will appear next to the Subdocument icon.
:p.

Within the current file, the Subdocument object behaves like a
Paragraph whose entire contents is the TITLE of another HTML
file and where that TITLE text is a hypertext link to the other
file.
:p.

However, the Subdocument structure is also stored as Extended
Attributes of the files in the library. Each *.HTM or *.HTML
file has pointers to the files that it claims as subdocuments
and to its "parent" (a file that claims it as a subdocument).
The order in which the Subdocument objects appear in the parent
establishes a :hp1.Next:ehp1. and :hp1.Previous:ehp1. ordering
to the sudocument HTML files, which SpHyDir maintains and can
use to generate uniform Headers and Trailers.
:h2. The Section Tool
:artwork name='SECTION.BMP'.
:p.

Sections correspond to document elements introduced by an
H1...H6 HTML tag. Although SpHyDir recognizes these tags on
input, it discards their original level number. When HTML is
generated, the highest level section is given an H1 tag, then
next level becomes H2, and so on. Sections have no explicit
ending delimiter, so a section extends till the end of the
document or until a new section of the same or a higher level is
encountered. SpHyDir will probably work best if the entire HTML
file is contained in a single top level (H1) section.
:h2. The Paragraph Tool
:artwork name='PARA.BMP'.
:p.

The Paragraph Tool produces an ordinary paragraph of text.
Actually, paragraphs contain text, formatting tags (bold,
italics,etc.), and hypertext links to other files and documents
keyed to hotword phrases.
:h2. The Image Tool
:artwork name='IMG.BMP'.
:p.

The Image Tool represents a graphic insert. First, drag and drop
the image tool to the location in the document where the image
is logically positioned. Then finish the definition by dropping
the WPS icon of a GIF file on top of the Image object. Currently
SpHyDir requires the GIF data type (XBM and JPG may be added
later). Since the IBM IPF system doesn't support GIF, generated
IPF source uses the same file name and an extension of BMP. GIF
files can be converted to BMP files using the GBM utilities or
any of a number of other graphics programs.
:p.

HTML authors are reminded that there are still a number of
disadvantaged users who try to surf the net using charcter mode
Unix. To accomodate such people, an Image should have alternate
text (represented by the ALT attribute). The entry area at the
top of the workarea can be used to type a phrase that will be
displayed as alternate text.
:p.

By default, an Image object will be displayed by itself. This is
probably the best choice for large images. An icon, on the other
hand, should be displayed inline (as is the Image icon itself at
the start of this section). When an Image object is selected, a
"spin field" appears under the entry area at the top of the work
area. Within this field, the selection "None" for alignment,
places the image by itself. Otherwise, the text of a subsequent
paragraph will appear to the right of the image. Top, Middle,
and Bottom are standard HTML alignments. Left is an alignment
option supported by Netscape.
:h2. The Ordered List Tool
:artwork name='OLIST.BMP'.
:p.

An Ordered List Tool contains a sequence of numbered points. The
list pushes down the tree structure one level. Drag the Point
Tool and drop it in the list. Each Point acts much like a
paragraph. Lists may also include Paragraph Objects (unexpected
but widely used) and Subdocument Objects (useful when you want
to number the chapters). A list may not contain a Section
object!
:h2. The Unordered List Tool
:artwork name='ULIST.BMP'.
:p.

An unordered lists contains unnumbered points, generally
delimited by a "bullet" character. Unordered lists follow the
same rules as the previous discussion of Ordered Lists.
:h2. The Definition (Glossary) List Tool
:artwork name='DEF.BMP'.
:p.

A Definition List defines a set of terms. Each item in the list
is preceeded by the term to be defined, set off from the
definition by different levels of indentation. The Point Tool is
used for definition lists as well. The Point Tool changes its
behavior depending on the type of list in which it is placed.
:h2. The Point Tool
:artwork name='POINT.BMP'.
:p.

The icon of a hand making a "point" represents the general list
item. An item in a numbered or unnumbered list simply has text.
An item in a Definition List also has the term or phrase being
defined. This term can be entered in the Entry area at the top
right of the workarea.
:h2. The Target Tool
:artwork name='BULLSEYE.BMP'.
:p.

The Target object generates a permanent public hypertext target.
Type a name (preferably without blanks) in the entry area at the
top of the workarea. This name can then be used in hypertext
links from other documents in the library. Although SpHyDir may
generate internal targets for section headers (to make the TOC
work), these names will change if the section is renamed. A
Target object is only renamed if the user changes it, so it
becomes a more reliable target for long term use.
:p.

There are three views about hypertext targets. HTML allows any
word, even any letter, to be the target of a hypertext link.
This level of precision is meanless to the viewer. IPF requires
a hypertext link to jump to a header that generates its own
Window. In HTML terms, the IPF strategy would only allow HTML
files to be targets and not individual subsections. This
explains why OS/2 HLP and INF files seem to be fragmented into
silly, unmanagably small individual panels.
:p.

SpHyDir tries to split the difference. A Target is an object, so
it can only go in front of Section, Paragraph, Image, List, or
Point objects. When SpHyDir encounters a target while reading
HTML, it moves in in front of the paragraph or point in which it
was found. When SpHyDir generates IPF, however, it will probably
have to move the reference back to the start of the current
Section.
:h2. The Preformatted Text Tool
:artwork name='PRE.BMP'.
:p.

Within an ordinary paragraph, line breaks and multiple blanks
are ignored. The Preformatted Text object is used for examples
where the lines and spaces are important. In most browsers,
Preformatted Text is rendered in a font with characters of equal
width.
:h2. The Forms Tools
:artwork name='FORM.BMP'.
:p.

The Form Tool creates an interactive area in which the Web user
can enter data to submit a request or query. A Form can include
all of the previous document objects, and data fields from the
bottom row of the toolbar. To process a form, the server must
execute a program written by the form designer. This makes the
use of Forms an advanced topic that will be described in a
separate section.
:h2. Missing Tools
:p.

There are other document elements that are not used frequently
enough to warrant a place on the Toolbar. In particular, the
Horizontal Rule <HR> tag is generated by positioning at a
section or paragraph, holding Alt and pressing H. The line goes
in front of the selected object.
:h1. The Problem of Position
:p.

SpHyDir would be simple if the VX-Rexx and OS/2 programming
interface allowed the user to drop tools and components in
between two existing document elements. This would clearly
indicate where the new element is to go. However, the
environment requires the tools, files, and other objects to be
dropped on top of existing components. This forces SpHyDir to
invent some rules about positioning.
:p.

A Target is a label for the thing that follows it. If you drop a
Target on a paragraph or section, then it makes sense to assume
that the Target should go in front of whatever you drop it on.
When a hypertext reference is made to the target name, the
following document component will be what shows up on the screen
after the jump. You may not drop a Target on the Document object
that is the first object in the tree, since there is no "before"
to place the Target and because the start of the document
doesn't need any label, the filename will do fine to identify
it.
:p.

Sections and Lists contain things. In the Workplace, if you drop
a file on the icon of a folder, the file goes into the folder.
So the normal behavior is that if you drop anything (other than
a Target) on a Section or a List, then the new element is added
inside that Section or List in front of anything already there.
:p.

If you drop something on a Paragraph, Image, or Point then the
new item goes after the thing you dropped it on. Thus to add a
new Point to the end of an existing list, drop the Point tool on
the last Point in the list. To add a new Point to the beginning
of a list, drop the Point tool on the parent List object.
:p.

These rules seem to cover all but two cases. Lists can be nested
inside other lists. When this occurs, there is no way to add a
new outer point after the end of a nested inner list because
every time you try to drop a point on the inner list icon the
new point is positioned inside the inner list instead of after
it in the outer list. Similarly, there is no way to add one
section after another because whenever you drop something on a
section it goes inside it and not behind it. So there is an
extra rule that if you hold down Ctrl when dropping a Point on a
List the Point goes after the list, and if you hold down Ctrl
when dropping the Section tool on an existing Section, the new
Section goes behind the current section. This is not entirely
satisfactory. A section can go on for many screens, and it it
somewhat unexpected to have to go many screens back to the start
of a section in order to drop something on the section object
and add it many screens down after the section end. I am waiting
for a better idea to come to mind.
:p.

Originally, the idea would be that Ctrl-dropping a tool placed
the tool after the thing on which you dropped it. That seemed
like a good rule, but it doesn't work with Sections because you
can't put a paragraph, image, or list after a Section. Sections
don't end, you see, until a new Section begins (in HTML terms, a
section ends when a new H1...H6 header is encountered). The only
thing that you can put behind a section is another Section.
Everything else that you try to put behind the section ends up
inside it anyway.
