:h1. Using SpHyDir
:p.

If you begin by expecting every document element (every
paragraph, image, list, or point) to act like a Workplace file,
then you have a fairly good starting view of how to use SpHyDir.
The only complex point is positioning new elements in the tree,
since OS/2 objects don't have an order.
:h2. How do I edit an HTML document?
:p.

Drag the WPS object for an HTML file and drop it on the SpHyDir
Workarea window (if SpHyDir is running) or on a WPS Program
Object representing the SpHyDir program (to Launch SpHyDir and
read in the file). SpHyDir opens the file, parses the HTML, and
builds the tree representing the document structure.
:p.

Only one document can be in the workarea at a time, so if a
second document is dropped on the first SpHyDir will ask
permission to clear the first document and replace it with the
second. Save any changes that you want to keep first before
starting to edit a new document.
:h2. How do I make changes?
:p.

The text in a paragraph, list point, or definition is treated
like the "contents" of the document object. Double-click on the
paragraph or point object and it appears to "open", presenting
the Text Edit window in which changes can be typed. To speed
things up, the text edit window also has buttons to go forward
to the next paragraph, back to the previous one, and to insert a
new paragraph after the current one and begin editing it.
:p.

Section titles, the alternate text of images, and the term being
defined in a definition list are treated as if they were object
Names (like the file name under a Workplace file icon). In some
cases you can use WPS file renaming conventions (point to a
Section title, hold down Alt while clicking on the text, then
change the text in place and click somewhere else at the end).
However, is rather awkward in practice. There is an entry area
at the top right of the workarea window. It can be used to edit
the "name" of the currently selected document element in the
tree below.
:h2. How do I enter special characters?
:p.

If the question applies to the three ordinary ASCII characters
("&amp.", "<", and ">") that HTML uses to delimit control
features, just type them. SpHyDir removes the HTML control
features when the document is read in and recreates it when the
document is regenerated.
:p.

For foreign language (ISO 8859-1) characters, SpHyDir currently
doesn't have explict support. The author is in search of an
appropriate entry area control or simple text editor that will
allow these characters to be displayed and edited directly.
:p.

Because the paragraph boundaries are represented by objects, the
user can enter a line break (<BR>) by simply typing Return to
split the current text.
:h2. How do I delete objects?
:p.

Drag the object to the WPS shredder. Alternately, select the
object and press Ctrl-D.
:h2. How do I add new elements to the document?
:p.

At the top left of the workarea window there are a set of icons
alternately viewed as the "Toolbar" and as "Templates". They act
to the document much like the OS/2 Template folder acts to the
rest of the workplace. Drag the icon for a Section, Paragraph,
Image, List, or other tool and drop it where you want the new
element to go. This creates an empty element that needs to be
filled in.
:UL.
:li. 
When the paragraph tool is dropped, the edit window opens and
you may type text. You can also paste text from the Clipboard.
Dropping an external file on the Text Editor window is
ambiguous. Some files have long lines with CR-LF at the
paragraph boundaries, some have blank lines at paragraph
boundaries and CR-LF is a line break. SpHyDir will shortly be
extended to support an XSpO (external Rexx program) interface to
handling files dropped on the Text Edit window.
:li. 
When the image tool is dropped, it creates an empty Image
object. Drag a GIF file over from one of the OS/2 disk folders
and drop it on the object to assign a file. Add alternate text
in the entry field at the top of the workarea. Pushbuttons allow
you to select the alignment of the image with any trailing text.
:eUL.
:h2. How do I create links to other files?
:p.

To create a hypertext link to a file in the local library, open
the Workplace folder containing the target file. Now hold
Ctrl-Shift down and drag the icon of the file over and drop it
on the paragraph, point, or image from which the link is to be
made. If you drop on an image, then there is no further work.
Images can have only one hypertext link and the entire image is
the link. If you drop on a paragraph or point, then the Hotword
Selection window opens displaying the available text. Drag the
mouse to "select" the word or phrase that will represent the
link. Click the OK button. Hotwords are delimited in the text by
an opening and closing triangle character. You may change the
contents of the hotword area, but do not delete the funny
triangle characters or SpHyDir will get confused.
:p.

SpHyDir has a Link Manager window to handle URL links to Web
documents out there somewhere in the network. The Link Manager
displays documents in a browser hotlist. A supplied XSpO (an
external Rexx program) can be dropped on a paragraph, point, or
image to create a link to whatever network document the IBM Web
Explorer is currently displaying.
:h2. How do I save the file and quit?
:p.

When the workarea has the input focus, press F2 to generate HTML
and continue editing, F3 to quit without generating, and F4 to
generate HTML and then quit. The status message at the bottom of
the window will indicate that HTML is being generated and then
has been written. If you press F2 and nothing happens, then
click once on the workarea to make sure it has the focus. If you
try to quit and have modified the file in the Workarea, a
message will pop up asking whether you want to Generate or
Discard the file.
:h2. How do I move paragraphs around?
:p.

You can drag an individual paragraph around, but only within the
visible window. To move more data, to move a greater distance,
or to move between files, there is special support to mark a
range of objects, copy them to a "clipboard" and paste them
somewhere else.
:p.

SpHyDir wants to create the image of selecting a range of
objects, moving them around, copying them to the clipboard, and
pasting them back into the file. However, the native support for
selection, movement, and the real OS/2 clipboard are not able to
handle this problem correctly. Reluctantly, SpHyDir has been
forced to reinvent some of this infrastructure.
:p.

The user can select a range of objects to move within a document
or to copy to another document. First select one object and
press Alt-L as if you were establishing a "line mark" in the EPM
or Kedit editors. Once you begin to mark a section of the
document, you may extend the marked area forward or backward,
but only within the current level of the document tree. The mark
can be extended :hp1.over:ehp1. but not :hp1.into:ehp1. lists or
subsections. Nor can the start or end of the mark be extended
outside the section or list in which it is started.
:artwork name='MARK.BMP'.
:p.

Marking creates two new objects&colon. Mark Start and Mark End.
Initially these objects are placed around the currently selected
object when Alt-L is pressed. The Mark objects can then be
"slid" forward or backward along the line that represents the
current level of the tree. They cannot be slid into a subsection
or list (to a lower level) nor can they be slid outside the
section or list in which they started. The Mark can also be
automatically adjusted by selecting another object at the same
level of the tree and pressing Alt-L again (expanding the scope
of the Mark just as additional lines are added in the EPM editor
when you move to another line and press Alt-L a second time).
:p.

Once a section has been marked, you can copy it to the Clipboard
by pressing Ctrl-Ins (the standard OS/2 keyboard sequence for
Copy). However, the OS/2 Clipboard really doesn't know how to
hold SpHyDir objects, so the same effect is achieved by opening
a new Window and copying all of the objects between the two
marks (including all the objects contained in subsections and
lists) from the workarea window to a second container that
SpHyDir calls "The Clipboard". In the current release, the
Clipboard window becomes visible (for debugging) though it can
be minimized or can be dragged over to the side of the desktop.
:p.

The objects in the Clipboard can then be moved to another part
of the original document by selecting a destination object and
pressing Shift-Ins (the OS/2 standard for Paste). They can be
copied to another file by dragging another HTM file to the
workarea (replacing the original source document) and then
pasting from the Clipboard to a second document.
:p.

However, Clipboard objects cannot be copied to another part of
the same document. This fell out from the way the Clipboard got
coded and, at the moment, it seems to be a useful feature. When
the user marks objects and presses Ctrl-Ins, there were two
programming choices. One choice copies all of the objects to the
Clipboard. The alternative creates what is essentially a Shadow
of the original record in the clipboard (what VX-Rexx calls a
"shared record"). Like the Workplace shadow, the two objects are
actually different views of the same data. If you were to edit
the text of a paragraph after copying it to the SpHyDir
Clipboard, the text of the Clipboard copy would also change.
However, while a Workplace shadow cannot exist when the original
is deleted, a VX-REXX shared record continues to exist until all
of its related objects have been deleted. Thus the Clipboard
copy of the data continues to exist after the original object in
the workarea has been deleted or the entire document has been
replaced.
:p.

A shared record can exist in two different containers, but there
can be only one copy of the record per container. By choosing to
use Shadows in the Clipboard instead of full copies, SpHyDir
does not support duplicating large blocks of text within the
same Hypertext document.
:p.

When you select another location and press Ctrl-Ins, the SpHyDir
Paste tries to copy the shared record from the Clipboard back to
the original document. However, since there is already a copy of
the record in the workarea and no container can have two copies
of the same record, the Paste operation actually moves the old
record from its previous location to the new position. If you
delete the document in the workarea and load a new document
(even a new copy of the original document) then a new set of
records are created. Now the Clipboard has the only copy of the
old records and Paste copies the information into the new
document.
:p.

I am a bit suspicious of any feature that takes this much time
to explain. On the other hand, a hypertext document should be
short and it doesn't make a lot of sense to duplicate large
blocks of text within such a file. There is a strong sense that
the way this Mark and Clipboard logic works is probably the
Right Way to handle this particular problem with this particular
set of data. Only by gaining experience with this technique will
it become clear if this is really the best approach.
:p.

Note that the SpHyDir specialized Clipboard, Cut, and Paste
apply only to the management of objects from the Workarea.
Within the Text Edit window opened by double-clicking a
paragraph or point, the behavior of text selection, Cut, Copy,
and Paste is completely normal and operates through the normal
OS/2 clipboard. Text data can be exchanged between another OS/2
program and the Text Edit window through the ordinary cut and
paste mechanisms.
