:h1. Forms Support
:p.

Modern HTML and Web Browser programs allow the user to enter
data and make selections with standard GUI Boxes, Buttons, and
Lists. Collectively, these features are know as "forms" support.
There are two steps. First, the author must design the data
entry form using HTML language elements. Secondly, a program
must be written in some supported language to process the data
that the user enters.
:p.

HTML forms provide a subset of the standard GUI dialog features
that will be familiar to users of Visual Basic or other visual
programming languages. The user is presented with a set of
single line and multiline text entry fields, checkboxes, radio
buttons, selection lists, and push buttons. The user makes
selections and enters data. Then a push button (or the Enter
key) transmits data to the server.
:h2. Forms Handling Programs
:p.

The data entered in a form has to be passed to locally written
code that runs on the Web server machine. For a Unix machine,
this program receives data through the "CGI" protocol. CGI
specifies a particular way to pass information about the
request, the remote machine, and the local server environment.
Most CGI programs are written in either C or Perl.
:p.

However, SpHyDir runs in OS/2 and is written in Rexx. IBM has a
very nice Web server package for this environment called
GOSERVE. Each arriving request is passed to a locally customized
Rexx filter program running as a subthread of the server.
Whatever efficiency is lost using an interpreted language like
Rexx is gained back by using threads instead of creating a new
process for each request.  Although GOSERVE provides all the
necessary forms support, it doesn't use precisely the same
conventions as the CGI interface.  SpHyDir will talk more
generically about a "forms processing program" while other
sources would probably call the same thing a "CGI program"
without assuming that there could be any other kind of server.
:p.

Each GUI object in the HTML form is associated with a variable
name. The data and selections are transmitted as a sequence of
":hp1.name:ehp1. = :hp1.value:ehp1." pairs, where name is the
variable :hp1.name:ehp1. associated with a field or button and
:hp1.value:ehp1. is the data typed or the alternative selected.
This sequence of name and value pair must be processed by
program that processes the request.
:p.

After the request is processed, the results are sent back to the
remote user. Normally, the format of this result is another HTML
file. Frequently, the response will also have Forms objects. The
contents of the response file will include some insertions based
on the results of the previous request.
:p.

Thus a comprehensive tool to simplify Form processing has to
solve three problems&colon.
:OL.
:li. 
It must provide the user with an easy way to specify the GUI
objects (entry fields, buttons, check boxes, and selection
lists). SpHyDir does this by providing Toolbar of GUI objects
just as Visual Basic and VX-Rexx solve the same problem with
similar toolbars.
:li. 
It must provide a simple way to decode the incoming
"variable=value" pairs. The Rexx language (along with some
helper functions provided by GOSERVE) makes this a trivial task,
but it is not a very difficult problem in any language.  SpHyDir
provides a Rexx "helper" routine named SpHyDir_Decode in the
SPHYHLPR.VRS file that provides this service.
:li. 
It must provide a way to insert data into the reply sent back to
the user. 
:p.

Some existing programs generate the entire response with program
statements&colon.
.br
SAMPprintf("<TITLE>Response to Your
Request</TITLE>\n");/SAMP
.br
This is tedious, difficult to read, and impossible to validate.
:p.

A second approach scans an HTML file and inserts data&colon.
.br
SAMP<TITLE>
.br
%insert TITLETEXT
.br
</TITLE>/SAMP
.br
This is slow because it requires a syntax scan during every
reply. 
:p.

SpHyDir provides (IMHO) a better solution.  The programmer uses
SpHyDir to create a ordinary HTML file with text and forms
objects.  As SpHyDir generates the HTML, it separately tabulates
the location of strings or insertion points that correspond to
the various forms variable names.  If the file is fetched as a
*.HTM file, then everything goes out as it was designed. 
However, if a forms processing program wants to send the file
back as a reply to a previous query, then it can call a helper
routine (SpHyDir_Reply in the supplied Rexx-GOSERVE example)
that extracts from the program the current value of all
variables whose names correspond to the variable names assigned
to the forms objects in the HTML file.  These current values
from the program are inserted into the file as it is sent back
to the user and populate the fields, boxes, buttons, and lists
that are available for the next reply.
:eOL.
:p.

Rexx is a particularly attractive language in which to do this
kind of programming because access to its variable names and
symbol table is simple and flexible. The combination of SpHyDir,
Web Explorer, GOSERVE, and Rexx-based Forms processing programs
provides a simple but powerful Web development environment.
However, local requirements will soon make it necessary to
extend this development environment to real CGI programs running
on Windows NT or Unix servers.
:h2. Forms are poorly Form-matted
:p.

The ambiguities of HTML that cause problems for SpHyDir in
normal text are made worse when Forms are processed. Consider a
simple example&colon.
:p.

:artwork name='TINYFORM.BMP'.
:p.

The top line is a simple entry area for typed characters. The
second line presents three alternatives using the "radio button"
metaphor (only one can be selected, and choosing one deselects
the others). The last line is a check box that can be set or
cleared by clicking it.
:p.

In visual programming languages, such as Visual Basic, each
radio button or check box has a "caption" defining the text that
follows the box or button and describes the option. In this
example, the captions are "HTTP", "Gopher", "FTP", and "BINARY".
Occasionally, but less frequently, a Text Entry object would
also have a caption (in this case "Identify a Server
Machine&colon."). In any case, the Caption is an attribute of
the object and is part of the object definition.
:p.

However, in HTML a box or button object is just the box or
button itself. Any caption text is just ordinary "paragraph"
text. There is no limit on its size, contents, or structure.
Just as SpHyDir had to invent a chapter and section structure by
looking at Heading tags, it must also construct GUI programming
objects by assuming that the captions are reasonable and
obvious.
:p.

All GUI objects (entry areas, buttons, boxes, and selection
lists) must be inside a FORM area. However, the form can also
contain ordinary text, images, ordered and unordered lists,
sections, and everything else that is valid in a document.
Unlike a paper form, where the instructions are usually separate
so that the input can be easily processed, an HTML form can have
the input widely scattered through the text. When the form is
submitted, only the values of the entry fields and the
selections made by the user are transmitted, not the captions
and text.
:p.

A user will become confused, however, if each Radio Button
option is accompanied with three screens full of explanation.
The relationship between the buttons would be lost. Therefore,
it is probably best if each field or button has a short clean
caption. Furthermore, based on a universal GUI practice, the
caption of a data entry area would ususally come in front of the
entry field (as the example "Identify a Server Machine&colon."),
while the label of a check box or radio button comes right after
it.
:p.

In normal text, most of the SpHyDir objects start a new line.
This is not true of Form Objects. If a browser can fit the next
button on the same line, it will do so. The only way to be sure
that there is a line break is to create a paragraph (<P>) tag.
:p.

In normal text, every SpHyDir object is "paragraph sized" or
larger. SpHyDir knows to create a line break when paragraphs,
ordered lists, and headers are encountered. But several forms
objects may have to go on the same line. One idea would be to
create a higher "grouping" object to which they might all
belong, but SpHyDir is based on the principle that format should
follow from document structure, and it seems wrong to create
artificial structure to duplicate a format feature.
:p.

It has always been possible to create an empty paragraph. Simply
drag the Paragraph tool to the document to create a new
paragraph, then type nothing in it. When the HTML is generated,
this creates a line of the form&colon.
.br
<P> </P>
.br
in the output. The problem is that SpHyDir ignores empty
paragraphs when reading in normal text, so this structural
element is lost when the document is re-edited. SpHyDir relaxes
this rule, and will preserve empty paragraphs when they are
encountered inside a Form structure. A form designer should drop
an empty paragraph object between any two buttons, fields, or
boxes that are supposed to appear on different lines.
:h2. Form Tools
:p.

The Toolbar contains template objects for all the GUI elements
that HTML supports. If this document is viewed using a Web
Browser, examples of the Forms objects will appear in the
document. They are not connected to any processing program at
this time. Attempting to submit anything from these form objects
will return an error message. Just go back to the document and
continue. Forms examples will not appear in the INF version of
this material, because forms are not supported in IPF.
:h3. The Forms Tool
:p.

:artwork name='FORM.BMP'.
:p.

Interactive form elements are valid only within a section of a
document maked as a Form. The Form Tool creates such a section.
Drag the Form Tool over and drop it anywhere in a document
except within another Form. This creates a new level in the
document tree. All other form objects, and all ordinary document
objects, are valid within a Form section.
:p.

Each form must be associated with the name of a program that the
server will run to process the data from the form. When the form
object is created or selected, an entry area becomes visible
into which a program identifier can be typed. The exact format
for program identifiers depends on the type of server being
used. On a Unix server, this is usually the name of a program in
the "cgi-bin" subdirectory, as in "/cgi-bin/program". On other
systems, this may be any program name.
:h3. The Single Line Text Entry Field
:p.

:artwork name='ENTRYFLD.BMP'.
:p.

The Entry Field Tool creates a "single line" text entry area.
This is the type of field that would be used to read simple data
like a name, phone number, E-Mail address, or book title.
:p.

The caption for the Entry Field Object is treated like paragraph
text. When the field is created, or when the object is
double-clicked, the standard Text Edit window opens. Although
the user can type an arbitrary amount of text into the window,
the caption should generally be short. When the object is
closed, it is the caption and not the default field contents
that appears next to the Entry Field Object in the SpHyDir
Workarea.
:p.

:artwork name='ENTRYDEF.BMP'.
:p.

An Entry Field object has attributes. When the object is created
or is selected by clicking with the first mouse button, a set of
fields becomes visible in the upper right section of the
Workarea. Yes, these are also "entry fields", but they are part
of the VX-Rexx application and not the HTML Forms. Many of these
attributes are common or similar across all the Forms objects.
For each type of object, the appropriate set of fields becomes
visible.
:p.

The first (top) attribute is a variable name. When the form is
submitted, the text entered into the field will be transmitted
as the value of a "name=value" sequence. For example, entering
"Yale University" into a field with this definition would
transmit the sequence&colon.
.br
SAMPsampentry=Yale University/SAMP
.br
to the Web Server. This value, along with any other values from
other fields in the form, will be passed to the program
designated by the FORM object to handle the data.
:p.

In many cases, the Text Entry field will be initially empty and
the user will be expected to type a value in. HTML allows an
initial value to be transmitted from the server. This string
will appear in the Text Entry field and will be transmitted back
as its value if the user doesn't change it. A static default
value can be entered in the second (long middle) field.
:p.

A default value can also be generated dynamically from a
previous Web Server program that requested transmission of the
current page. To allow this, SpHyDir creates a "symbol table"
external but connected to the HTML source for the page. This
table is attached as an Extended Attribute of the file in the
OS/2 or NT file system, and is stored less elegantly as a
separate file in Unix. For this field, the table would contain a
line of the form&colon.
.br
ENTRY SAMPENTRY nnnn 18
.br
Where "ENTRY" is the type of forms object, "SAMPENTRY" is the
name of the variable associated with the field, "nnnn" will be
replaced with the byte offset in the field of the default value
(in this example, the offset of the "S" in "Sample Entry
Field"), and 18 is the length of the static default value.
:p.

An Entry field generates HTML text of the form&colon.
.br
<INPUT TYPE="TEXT" NAME="SAMPENTRY" VALUE="Sample Entry Field"
SIZE="30" MAXLENGTH="30">
.br
If no static default text is provided, a VALUE="" is generated
to simplify the insertion of a dynamic default text from the
symbol table. SpHyDir helper routines simplify the insertion of
dynamic default text from forms processing programs.
:p.

The last attributes of an Entry Field include a checkbox to
declare that this is a Password field (so the data typed in
should be masked out) and two length fields. The first length
specifies the size of the box, the second field is the maximum
amount of data that can be typed into the box. If the maximum
amount is larger than the size of the box, or is omitted all
together, then when the user gets to the end of the box the
previous characters shift left to make room.
:h3. The Multiline Entry Field
:p.

:artwork name='MLE.BMP'.
:p.

A Multiline Entry (MLE) Object generates an area with scroll
bars into which the user can type an arbitrary amount of text.
This is ususally used for freeform feedback (to send comments,
suggestions, or complaints to the author). It can also be used
to annotate information.
:p.

An MLE is a large object, so it has no formal caption. If you
want to describe it, do so in the paragraph that preceeds or
follows it. The contents of the MLE object, which can be edited
by double clicking the object and opening the Text Edit window,
is the static data that will appear as a default within the MLE
window when it is displayed on the remote screen.
:p.

An MLE field in a Web Browser will not support font changes or
hypertext links. SpHyDir may eventually get around to disabling
these options in the Text Edit window. Meanwhile, when editing
default text for an MLE, don't use italics, bold, or any of the
other format tags.
:p.

:artwork name='MLEDEF.BMP'.
:p.

An MLE is associated with a variable name. When the form is
submitted, the new content of the MLE will be assigned as a
value to that variable name. SpHyDir creates a entry in the
Variables Extended Attribute with the type of "MLE", the name of
the variable, the location of the start of the default text, and
the length of the static default text. This can be used by the
helper routine to insert an alternate string dynamically into
the form as it is being transmitted. The content of such a
string would be whatever HTML declares to be valid between the
<TEXTAREA> and </TEXTAREA> tags.
:p.

An MLE also has a size specified as rows and columns. They
appear in the two lower numeric boxes and can be changed to fit
the application needs.
:h3. The Checkbox Tool
:p.

:artwork name='CHECKBOX.BMP'.
:p.

The Checkbox Tool creates a standard GUI Checkbox object. A
caption follows the Checkbox to describe the option. The caption
is regarded as the "contents" of the object and may be edited by
double-clicking the checkbox object to open the Text Edit
window. Unlike the MLE, the checkbox caption is ordinary text
and may contain emphasis (bold, italics) or hypertext links.
:p.

The Checkbox is associated with a variable name. When the
checkbox is seleted, a "name=ON" pair is returned. A static
default value can be set by clicking the "Checked" option when
the checkbox object is currently selected.
:p.

:artwork name='CHECKDEF.BMP'.
:p.

A Checkbox has a variable name. It can also be statically
assigned an initial value by checking the "Checked" checkbox for
the Checkbox object. [This is about the fourth pass through this
document, and it just gets worse as it gets more precise.]
:p.

There are different ways to express the value of a Checkbox
variable. As a number it would be 0 or 1. In other contexts it
might be "YES" and "NO" or "TRUE" and "FALSE". In HTML, the
checkbox is turned on by adding the keyword "CHECKED" to the tag
that defines it&colon.
.br
SAMP<INPUT TYPE="CHECKBOX" NAME="NOMAYO" CHECKED>/SAMP
.br
However, when the user submits the form and the box is checked,
the variable name is returned with the value "ON" as in&colon.
.br
SAMPNOMAYO=ON/SAMP
.br
Clearly this is a muddy area and may be subject to further
refinement.
:p.

When SpHyDir generates the Variables EA for this field, the
entry will have the form&colon.
.br
CHECKBOX NOMAYO nnnn 7
.br
Where the type is CHECKBOX, the variable name is NOMAYO, nnnn is
the byte offset in the file of the blank following the variable
name, and the length is either 0 or 7 since the word "CHECKED"
has seven letters and is either present or omitted.
:h3. The Radio Button Tool
:p.

:artwork name='RADIOBUT.BMP'.
:p.

The RadioButton Tool is used to specifiy one of a set of
mutually exclusive alternatives. Only one can be selected, and
selecting that option automatically turns off the other
alternatives.
:p.

The Web server is&colon.
:p.

The caption of the RadioButton, which can be edited by
doubleclicking the object to open the Text Edit Window, is
ordinary text and may have emphasis and hyperlinks. However, if
the captions are large enough so that the alternatives cannot
all fit on the same line, the user must provide additional HTML
markup (such as the <HR> tag) to group related buttons together.
:p.

:artwork name='RADIODEF.BMP'.
:p.

When a RadioButton Object is created or selected, three fields
become visible at the top of the Workarea. The first field
provides the variable name for this button (and implicitly all
other buttons that are part of the same grouping). The second
field contains a string that will be assigned to the variable
when this particular button is selected. Under these fields, a
Checkbox allows this particular button to be selected as the
default for the group. To be meaningful, only one button in each
group can be checked as the default.
:p.

In Visual Basic and VX-Rexx, radio buttons have to be collected
in a Group Box to be related to each other. In HTML forms, radio
buttons are related by having the same variable name. The value
assigned to that variable name distinguishes one button from
another.
:p.

Radio Buttons pose a problem for the symbol table in the
Extended Attribute. Up to this point, every HTML object produced
one entry with its own variable name, and there was one
insertion point for the value of that variable. However, each
Radio Button has a tag location, and to override a static
default with dynamic information from a program, the "CHECKED"
attribute in all of the tags has to be manipulated. So for every
radio button, the Variables EA gets a separate entry&colon.
.br
SAMPRADIOBUT SERVER=UNIX nnnn 0
.br
RADIOBUT SERVER=OS2 nnnn 0
.br
RADIOBUT SERVER=NT nnnn 0/SAMP
.br
The "nnnn" in each line is the offset in the file of the blank
that follows the name and either preceeds ">" (if the length is
0) or "CHECKED>" (if the length is 7). An acceptable strategy is
to process these entries in order, checking the current value of
the program's "SERVER" variable against the possible matching
strings "UNIX", "OS2", and "NT". If a match is made, then
"CHECKED" is inserted into the HTML file, if not and the length
is 7 then the old "CHECKED" string is removed.
:h3. The Spin and Listbox Objects
:p.

:artwork name='SPIN.BMP'.
:p.

A Spin field displays a sequence of alternatives within a single
window. CUA rules suggest that the Spin choice is appropriate
when the alternatives are ordered, but the Spin object also
allows a small number of alternatives to be meaningfully
displayed in a small space. In HTML terms, a Spin object
corresponds to a SELECT tag with no SIZE parameter.
:p.

Get a dozen eggs&colon.
:p.

An interesting feature here is that Web Explorer seems to mess
up the order and selection rules. It defaults to the last
alternative chosen, when the standard clearly says that the
first is the default, and it seems to get "bigger" and "smaller"
reversed.
:p.

:artwork name='LISTBOX.BMP'.
:p.

A Listbox provides another way to display alternatives. It is
probably more suitable if the number of options is large. This
Object is also a SELECT list, but with the SIZE parameter
specified.
:p.

:artwork name='LBDEF.BMP'.
:p.

For both selection objects, a static list of alternatives can be
entered through the Text Edit window by doubleclicking the
object. Each alternative is typed on a separate line. Press
Enter between alternatives. Do not use character emphasis or try
to assign links to the alternatives.
:p.

List alternatives can be assigned dynamically by creating an
array of character strings. For example, in Rexx a set of
alternatives might be specified by the sequence&colon.
.br
account.0=3
.br
account.1="Checking"
.br
account.2="Savings"
.br
account.3="Money Market"
.br
If the user chose the second option, this would then feed back
as the string "account=Savings" which the Rexx helper routines
would use to assign the string "Savings" to the variable ACCOUNT
in the next program. [A note to those who are not Rexx wizards,
the scalar variable ACCOUNT is completely independent of the
"stem" ACCOUNT. (with the trailing period). This strategy uses
the stem to hold the list of alternatives, and uses the scalar
to designate which alternative was selected.]
:h3. Pushbuttons
:p.

:artwork name='PUSHBUT.BMP'.
:p.

After filling in the required fields, the user triggers an
action on the server by pressing a Pushbutton. If no Pushbutton
object appears in the form, pressing the Enter key may also
transmit data.
:p.

A default Pushbutton with no options is labelled "SUBMIT". It
will trigger transmission of the data, but will add nothing to
the datastream itself. Multiple "SUBMIT" buttons would be
indistinguishable from each other.
:p.

Each Pushbutton has attributes&colon.
:p.

:artwork name='PUSHDEF.BMP'.
:p.

The left entry box is the name of a variable. The right box is
both the value assigned to the variable when the button is
pushed and also the label placed on the face of the button.
:p.

When an explicit variable name is assigned to a Pushbutton
object, an entry is also made in the Variable Extended
Attribute. It identifies a type of "PUSHBUT", the variable name,
the offset of the static value string, and its length. If the
helper functions are used, they will check for a variable of the
same name in the calling program and will substitute its current
value in the Pushbutton definition. This means that the caption
of the Pushbutton can be dynamically changed by the calling
program.
:p.

A special version of the Pushbutton control is established if
the Hidden attribute is checked when the button object is
selected. A Hidden field doesn't appear on the user's screen,
but it is passed back as part of the data stream to the next
program. This can be used to pass a handle, transaction ID, or
other state information from one screen to the next.
